/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class ResultSlot
extends Slot {
    private final CraftingContainer craftSlots;
    private final Player player;
    private int removeCount;

    public ResultSlot(Player p_40166_, CraftingContainer p_40167_, Container p_40168_, int p_40169_, int p_40170_, int p_40171_) {
        super(p_40168_, p_40169_, p_40170_, p_40171_);
        this.player = p_40166_;
        this.craftSlots = p_40167_;
    }

    @Override
    public boolean mayPlace(ItemStack p_40178_) {
        return false;
    }

    @Override
    public ItemStack remove(int p_40173_) {
        if (this.hasItem()) {
            this.removeCount += Math.min(p_40173_, this.getItem().getCount());
        }
        return super.remove(p_40173_);
    }

    @Override
    protected void onQuickCraft(ItemStack p_40180_, int p_40181_) {
        this.removeCount += p_40181_;
        this.checkTakeAchievements(p_40180_);
    }

    @Override
    protected void onSwapCraft(int p_40183_) {
        this.removeCount += p_40183_;
    }

    @Override
    protected void checkTakeAchievements(ItemStack p_40185_) {
        Container container;
        if (this.removeCount > 0) {
            p_40185_.onCraftedBy(this.player.level(), this.player, this.removeCount);
        }
        if ((container = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder $$1 = (RecipeCraftingHolder)((Object)container);
            $$1.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }

    @Override
    public void onTake(Player p_150638_, ItemStack p_150639_) {
        this.checkTakeAchievements(p_150639_);
        NonNullList<ItemStack> $$2 = p_150638_.level().getRecipeManager().getRemainingItemsFor(RecipeType.CRAFTING, this.craftSlots, p_150638_.level());
        for (int $$3 = 0; $$3 < $$2.size(); ++$$3) {
            ItemStack $$4 = this.craftSlots.getItem($$3);
            ItemStack $$5 = $$2.get($$3);
            if (!$$4.isEmpty()) {
                this.craftSlots.removeItem($$3, 1);
                $$4 = this.craftSlots.getItem($$3);
            }
            if ($$5.isEmpty()) continue;
            if ($$4.isEmpty()) {
                this.craftSlots.setItem($$3, $$5);
                continue;
            }
            if (ItemStack.isSameItemSameComponents($$4, $$5)) {
                $$5.grow($$4.getCount());
                this.craftSlots.setItem($$3, $$5);
                continue;
            }
            if (this.player.getInventory().add($$5)) continue;
            this.player.drop($$5, false);
        }
    }

    @Override
    public boolean isFake() {
        return true;
    }
}

