/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public interface Equipable {
    public EquipmentSlot getEquipmentSlot();

    default public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_GENERIC;
    }

    default public InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item p_270453_, Level p_270395_, Player p_270300_, InteractionHand p_270262_) {
        ItemStack $$4 = p_270300_.getItemInHand(p_270262_);
        EquipmentSlot $$5 = Mob.getEquipmentSlotForItem($$4);
        if (!p_270300_.canUseSlot($$5)) {
            return InteractionResultHolder.pass($$4);
        }
        ItemStack $$6 = p_270300_.getItemBySlot($$5);
        if (EnchantmentHelper.hasBindingCurse($$6) && !p_270300_.isCreative() || ItemStack.matches($$4, $$6)) {
            return InteractionResultHolder.fail($$4);
        }
        if (!p_270395_.isClientSide()) {
            p_270300_.awardStat(Stats.ITEM_USED.get(p_270453_));
        }
        ItemStack $$7 = $$6.isEmpty() ? $$4 : $$6.copyAndClear();
        ItemStack $$8 = p_270300_.isCreative() ? $$4.copy() : $$4.copyAndClear();
        p_270300_.setItemSlot($$5, $$8);
        return InteractionResultHolder.sidedSuccess($$7, p_270395_.isClientSide());
    }

    @Nullable
    public static Equipable get(ItemStack p_270317_) {
        BlockItem $$2;
        Item item = p_270317_.getItem();
        if (item instanceof Equipable) {
            Equipable $$1 = (Equipable)((Object)item);
            return $$1;
        }
        FeatureElement featureElement = p_270317_.getItem();
        if (featureElement instanceof BlockItem && (featureElement = ($$2 = (BlockItem)featureElement).getBlock()) instanceof Equipable) {
            Equipable $$3 = (Equipable)((Object)featureElement);
            return $$3;
        }
        return null;
    }
}

