/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class FireChargeItem
extends Item
implements ProjectileItem {
    public FireChargeItem(Item.Properties p_41202_) {
        super(p_41202_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_41204_) {
        Level $$1 = p_41204_.getLevel();
        BlockPos $$2 = p_41204_.getClickedPos();
        BlockState $$3 = $$1.getBlockState($$2);
        boolean $$4 = false;
        if (CampfireBlock.canLight($$3) || CandleBlock.canLight($$3) || CandleCakeBlock.canLight($$3)) {
            this.playSound($$1, $$2);
            $$1.setBlockAndUpdate($$2, (BlockState)$$3.setValue(BlockStateProperties.LIT, true));
            $$1.gameEvent((Entity)p_41204_.getPlayer(), GameEvent.BLOCK_CHANGE, $$2);
            $$4 = true;
        } else if (BaseFireBlock.canBePlacedAt($$1, $$2 = $$2.relative(p_41204_.getClickedFace()), p_41204_.getHorizontalDirection())) {
            this.playSound($$1, $$2);
            $$1.setBlockAndUpdate($$2, BaseFireBlock.getState($$1, $$2));
            $$1.gameEvent((Entity)p_41204_.getPlayer(), GameEvent.BLOCK_PLACE, $$2);
            $$4 = true;
        }
        if ($$4) {
            p_41204_.getItemInHand().shrink(1);
            return InteractionResult.sidedSuccess($$1.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    private void playSound(Level p_41206_, BlockPos p_41207_) {
        RandomSource $$2 = p_41206_.getRandom();
        p_41206_.playSound(null, p_41207_, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, ($$2.nextFloat() - $$2.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public Projectile asProjectile(Level p_338826_, Position p_338780_, ItemStack p_338320_, Direction p_338841_) {
        RandomSource $$4 = p_338826_.getRandom();
        double $$5 = $$4.triangle(p_338841_.getStepX(), 0.11485000000000001);
        double $$6 = $$4.triangle(p_338841_.getStepY(), 0.11485000000000001);
        double $$7 = $$4.triangle(p_338841_.getStepZ(), 0.11485000000000001);
        SmallFireball $$8 = new SmallFireball(p_338826_, p_338780_.x(), p_338780_.y(), p_338780_.z(), $$5, $$6, $$7);
        $$8.setItem(p_338320_);
        return $$8;
    }

    @Override
    public void shoot(Projectile p_338389_, double p_338344_, double p_338646_, double p_338223_, float p_338688_, float p_338812_) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((p_338834_, p_338717_) -> DispenserBlock.getDispensePosition(p_338834_, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1018).build();
    }
}

