/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.DensityEnchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 6;
    private static final float DEFAULT_ATTACK_SPEED = -2.4f;
    private static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;
    private static final float SMASH_ATTACK_FALL_DISTANCE_MULTIPLIER = 3.0f;

    public MaceItem(Item.Properties p_333796_) {
        super(p_333796_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", -2.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState p_333875_, Level p_333847_, BlockPos p_334073_, Player p_334042_) {
        return !p_334042_.isCreative();
    }

    @Override
    public int getEnchantmentValue() {
        return 15;
    }

    @Override
    public boolean hurtEnemy(ItemStack p_334046_, LivingEntity p_333712_, LivingEntity p_333812_) {
        ServerPlayer $$3;
        p_334046_.hurtAndBreak(1, p_333812_, EquipmentSlot.MAINHAND);
        if (p_333812_ instanceof ServerPlayer && MaceItem.canSmashAttack($$3 = (ServerPlayer)p_333812_)) {
            ServerLevel $$4 = (ServerLevel)p_333812_.level();
            $$3.currentImpulseImpactPos = $$3.position();
            $$3.ignoreFallDamageFromCurrentImpulse = true;
            $$3.setDeltaMovement($$3.getDeltaMovement().with(Direction.Axis.Y, 0.01f));
            $$3.connection.send(new ClientboundSetEntityMotionPacket($$3));
            if (p_333712_.onGround()) {
                $$3.setSpawnExtraParticlesOnFall(true);
                SoundEvent $$5 = $$3.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                $$4.playSound(null, $$3.getX(), $$3.getY(), $$3.getZ(), $$5, $$3.getSoundSource(), 1.0f, 1.0f);
            } else {
                $$4.playSound(null, $$3.getX(), $$3.getY(), $$3.getZ(), SoundEvents.MACE_SMASH_AIR, $$3.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback($$4, $$3, p_333712_);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidRepairItem(ItemStack p_334031_, ItemStack p_334058_) {
        return p_334058_.is(Items.BREEZE_ROD);
    }

    @Override
    public float getAttackDamageBonus(Player p_335568_, float p_335575_) {
        int $$2 = EnchantmentHelper.getEnchantmentLevel(Enchantments.DENSITY, p_335568_);
        float $$3 = DensityEnchantment.calculateDamageAddition($$2, p_335568_.fallDistance);
        return MaceItem.canSmashAttack(p_335568_) ? 3.0f * p_335568_.fallDistance + $$3 : 0.0f;
    }

    private static void knockback(Level p_335716_, Player p_335955_, Entity p_335810_) {
        p_335716_.levelEvent(2013, p_335810_.getOnPos(), 750);
        p_335716_.getEntitiesOfClass(LivingEntity.class, p_335810_.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(p_335955_, p_335810_)).forEach(p_337941_ -> {
            Vec3 $$3 = p_337941_.position().subtract(p_335810_.position());
            double $$4 = MaceItem.getKnockbackPower(p_335955_, p_337941_, $$3);
            Vec3 $$5 = $$3.normalize().scale($$4);
            if ($$4 > 0.0) {
                p_337941_.push($$5.x, 0.7f, $$5.z);
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Player p_338613_, Entity p_338698_) {
        return p_337938_ -> {
            ArmorStand $$6;
            boolean $$3 = !p_337938_.isSpectator();
            boolean $$4 = p_337938_ != p_338613_ && p_337938_ != p_338698_;
            boolean $$5 = !p_338613_.isAlliedTo((Entity)p_337938_);
            boolean $$8 = !(p_337938_ instanceof ArmorStand) || !($$6 = (ArmorStand)p_337938_).isMarker();
            boolean $$9 = p_338698_.distanceToSqr((Entity)p_337938_) <= Math.pow(3.5, 2.0);
            return $$3 && $$4 && $$5 && $$8 && $$9;
        };
    }

    private static double getKnockbackPower(Player p_338265_, LivingEntity p_338630_, Vec3 p_338866_) {
        return (3.5 - p_338866_.length()) * (double)0.7f * (double)(p_338265_.fallDistance > 5.0f ? 2 : 1) * (1.0 - p_338630_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(Player p_338434_) {
        return p_338434_.fallDistance > 1.5f && !p_338434_.isFallFlying();
    }
}

