/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public abstract class ProjectileWeaponItem
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = p_43017_ -> p_43017_.is(ItemTags.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(p_43015_ -> p_43015_.is(Items.FIREWORK_ROCKET));

    public ProjectileWeaponItem(Item.Properties p_43009_) {
        super(p_43009_);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(LivingEntity p_43011_, Predicate<ItemStack> p_43012_) {
        if (p_43012_.test(p_43011_.getItemInHand(InteractionHand.OFF_HAND))) {
            return p_43011_.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (p_43012_.test(p_43011_.getItemInHand(InteractionHand.MAIN_HAND))) {
            return p_43011_.getItemInHand(InteractionHand.MAIN_HAND);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(Level p_331270_, LivingEntity p_330728_, InteractionHand p_331152_, ItemStack p_330646_, List<ItemStack> p_331726_, float p_331007_, float p_331445_, boolean p_331107_, @Nullable LivingEntity p_331167_) {
        float $$9 = 10.0f;
        float $$10 = p_331726_.size() == 1 ? 0.0f : 20.0f / (float)(p_331726_.size() - 1);
        float $$11 = (float)((p_331726_.size() - 1) % 2) * $$10 / 2.0f;
        float $$12 = 1.0f;
        for (int $$13 = 0; $$13 < p_331726_.size(); ++$$13) {
            ItemStack $$14 = p_331726_.get($$13);
            if ($$14.isEmpty()) continue;
            float $$15 = $$11 + $$12 * (float)(($$13 + 1) / 2) * $$10;
            $$12 = -$$12;
            p_330646_.hurtAndBreak(this.getDurabilityUse($$14), p_330728_, LivingEntity.getSlotForHand(p_331152_));
            Projectile $$16 = this.createProjectile(p_331270_, p_330728_, p_330646_, $$14, p_331107_);
            this.shootProjectile(p_330728_, $$16, $$13, p_331007_, p_331445_, $$15, p_331167_);
            p_331270_.addFreshEntity($$16);
        }
    }

    protected int getDurabilityUse(ItemStack p_331003_) {
        return 1;
    }

    protected abstract void shootProjectile(LivingEntity var1, Projectile var2, int var3, float var4, float var5, float var6, @Nullable LivingEntity var7);

    protected Projectile createProjectile(Level p_331008_, LivingEntity p_330781_, ItemStack p_330846_, ItemStack p_331497_, boolean p_331305_) {
        int $$10;
        int $$9;
        int $$8;
        ArrowItem $$5;
        Item item = p_331497_.getItem();
        ArrowItem $$6 = item instanceof ArrowItem ? ($$5 = (ArrowItem)item) : (ArrowItem)Items.ARROW;
        AbstractArrow $$7 = $$6.createArrow(p_331008_, p_331497_, p_330781_);
        if (p_331305_) {
            $$7.setCritArrow(true);
        }
        if (($$8 = EnchantmentHelper.getItemEnchantmentLevel(Enchantments.POWER, p_330846_)) > 0) {
            $$7.setBaseDamage($$7.getBaseDamage() + (double)$$8 * 0.5 + 0.5);
        }
        if (($$9 = EnchantmentHelper.getItemEnchantmentLevel(Enchantments.PUNCH, p_330846_)) > 0) {
            $$7.setKnockback($$9);
        }
        if (EnchantmentHelper.getItemEnchantmentLevel(Enchantments.FLAME, p_330846_) > 0) {
            $$7.igniteForSeconds(100);
        }
        if (($$10 = EnchantmentHelper.getItemEnchantmentLevel(Enchantments.PIERCING, p_330846_)) > 0) {
            $$7.setPierceLevel((byte)$$10);
        }
        return $$7;
    }

    protected static boolean hasInfiniteArrows(ItemStack p_330642_, ItemStack p_332202_, boolean p_331512_) {
        return p_331512_ || p_332202_.is(Items.ARROW) && EnchantmentHelper.getItemEnchantmentLevel(Enchantments.INFINITY, p_330642_) > 0;
    }

    protected static List<ItemStack> draw(ItemStack p_331565_, ItemStack p_330406_, LivingEntity p_330823_) {
        if (p_330406_.isEmpty()) {
            return List.of();
        }
        int $$3 = EnchantmentHelper.getItemEnchantmentLevel(Enchantments.MULTISHOT, p_331565_);
        int $$4 = $$3 == 0 ? 1 : 3;
        ArrayList<ItemStack> $$5 = new ArrayList<ItemStack>($$4);
        ItemStack $$6 = p_330406_.copy();
        for (int $$7 = 0; $$7 < $$4; ++$$7) {
            $$5.add(ProjectileWeaponItem.useAmmo(p_331565_, $$7 == 0 ? p_330406_ : $$6, p_330823_, $$7 > 0));
        }
        return $$5;
    }

    protected static ItemStack useAmmo(ItemStack p_331207_, ItemStack p_331434_, LivingEntity p_330302_, boolean p_330934_) {
        boolean $$4;
        boolean bl = $$4 = !p_330934_ && !ProjectileWeaponItem.hasInfiniteArrows(p_331207_, p_331434_, p_330302_.hasInfiniteMaterials());
        if (!$$4) {
            ItemStack $$5 = p_331434_.copyWithCount(1);
            $$5.set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return $$5;
        }
        ItemStack $$6 = p_331434_.split(1);
        if (p_331434_.isEmpty() && p_330302_ instanceof Player) {
            Player $$7 = (Player)p_330302_;
            $$7.getInventory().removeItem(p_331434_);
        }
        return $$6;
    }
}

