/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class RecordItem
extends Item {
    private static final Map<SoundEvent, RecordItem> BY_NAME = Maps.newHashMap();
    private final int analogOutput;
    private final SoundEvent sound;
    private final int lengthInTicks;

    protected RecordItem(int p_239614_, SoundEvent p_239615_, Item.Properties p_239616_, int p_239617_) {
        super(p_239616_);
        this.analogOutput = p_239614_;
        this.sound = p_239615_;
        this.lengthInTicks = p_239617_ * 20;
        BY_NAME.put(this.sound, this);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_43048_) {
        BlockPos $$2;
        Level $$1 = p_43048_.getLevel();
        BlockState $$3 = $$1.getBlockState($$2 = p_43048_.getClickedPos());
        if (!$$3.is(Blocks.JUKEBOX) || $$3.getValue(JukeboxBlock.HAS_RECORD).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack $$4 = p_43048_.getItemInHand();
        if (!$$1.isClientSide) {
            Player $$5 = p_43048_.getPlayer();
            BlockEntity blockEntity = $$1.getBlockEntity($$2);
            if (blockEntity instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity $$6 = (JukeboxBlockEntity)blockEntity;
                $$6.setTheItem($$4.copy());
                $$1.gameEvent(GameEvent.BLOCK_CHANGE, $$2, GameEvent.Context.of($$5, $$3));
            }
            $$4.shrink(1);
            if ($$5 != null) {
                $$5.awardStat(Stats.PLAY_RECORD);
            }
        }
        return InteractionResult.sidedSuccess($$1.isClientSide);
    }

    public int getAnalogOutput() {
        return this.analogOutput;
    }

    @Override
    public void appendHoverText(ItemStack p_43043_, Item.TooltipContext p_339671_, List<Component> p_43045_, TooltipFlag p_43046_) {
        p_43045_.add(this.getDisplayName().withStyle(ChatFormatting.GRAY));
    }

    public MutableComponent getDisplayName() {
        return Component.translatable(this.getDescriptionId() + ".desc");
    }

    @Nullable
    public static RecordItem getBySound(SoundEvent p_43041_) {
        return BY_NAME.get(p_43041_);
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public int getLengthInTicks() {
        return this.lengthInTicks;
    }
}

