/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties p_43381_) {
        super(p_43381_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState p_43409_, Level p_43410_, BlockPos p_43411_, Player p_43412_) {
        return !p_43412_.isCreative();
    }

    @Override
    public UseAnim getUseAnimation(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack p_43419_) {
        return 72000;
    }

    @Override
    public void releaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (!(p_43396_ instanceof Player)) {
            return;
        }
        Player $$4 = (Player)p_43396_;
        int $$5 = this.getUseDuration(p_43394_) - p_43397_;
        if ($$5 < 10) {
            return;
        }
        int $$6 = EnchantmentHelper.getRiptide(p_43394_);
        if ($$6 > 0 && !$$4.isInWaterOrRain()) {
            return;
        }
        if (!p_43395_.isClientSide) {
            p_43394_.hurtAndBreak(1, $$4, LivingEntity.getSlotForHand(p_43396_.getUsedItemHand()));
            if ($$6 == 0) {
                ThrownTrident $$7 = new ThrownTrident(p_43395_, $$4, p_43394_);
                $$7.shootFromRotation($$4, $$4.getXRot(), $$4.getYRot(), 0.0f, 2.5f + (float)$$6 * 0.5f, 1.0f);
                if ($$4.hasInfiniteMaterials()) {
                    $$7.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                p_43395_.addFreshEntity($$7);
                p_43395_.playSound(null, $$7, SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!$$4.hasInfiniteMaterials()) {
                    $$4.getInventory().removeItem(p_43394_);
                }
            }
        }
        $$4.awardStat(Stats.ITEM_USED.get(this));
        if ($$6 > 0) {
            SoundEvent $$18;
            float $$8 = $$4.getYRot();
            float $$9 = $$4.getXRot();
            float $$10 = -Mth.sin($$8 * ((float)Math.PI / 180)) * Mth.cos($$9 * ((float)Math.PI / 180));
            float $$11 = -Mth.sin($$9 * ((float)Math.PI / 180));
            float $$12 = Mth.cos($$8 * ((float)Math.PI / 180)) * Mth.cos($$9 * ((float)Math.PI / 180));
            float $$13 = Mth.sqrt($$10 * $$10 + $$11 * $$11 + $$12 * $$12);
            float $$14 = 3.0f * ((1.0f + (float)$$6) / 4.0f);
            $$4.push($$10 *= $$14 / $$13, $$11 *= $$14 / $$13, $$12 *= $$14 / $$13);
            $$4.startAutoSpinAttack(20);
            if ($$4.onGround()) {
                float $$15 = 1.1999999f;
                $$4.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            if ($$6 >= 3) {
                SoundEvent $$16 = SoundEvents.TRIDENT_RIPTIDE_3;
            } else if ($$6 == 2) {
                SoundEvent $$17 = SoundEvents.TRIDENT_RIPTIDE_2;
            } else {
                $$18 = SoundEvents.TRIDENT_RIPTIDE_1;
            }
            p_43395_.playSound(null, $$4, $$18, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack $$3 = p_43406_.getItemInHand(p_43407_);
        if ($$3.getDamageValue() >= $$3.getMaxDamage() - 1) {
            return InteractionResultHolder.fail($$3);
        }
        if (EnchantmentHelper.getRiptide($$3) > 0 && !p_43406_.isInWaterOrRain()) {
            return InteractionResultHolder.fail($$3);
        }
        p_43406_.startUsingItem(p_43407_);
        return InteractionResultHolder.consume($$3);
    }

    @Override
    public boolean hurtEnemy(ItemStack p_43390_, LivingEntity p_43391_, LivingEntity p_43392_) {
        p_43390_.hurtAndBreak(1, p_43392_, EquipmentSlot.MAINHAND);
        return true;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public Projectile asProjectile(Level p_338505_, Position p_338277_, ItemStack p_338353_, Direction p_338220_) {
        ThrownTrident $$4 = new ThrownTrident(p_338505_, p_338277_.x(), p_338277_.y(), p_338277_.z(), p_338353_.copyWithCount(1));
        $$4.pickup = AbstractArrow.Pickup.ALLOWED;
        return $$4;
    }
}

