/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class WindChargeItem
extends Item
implements ProjectileItem {
    private static final int COOLDOWN = 10;

    public WindChargeItem(Item.Properties p_326377_) {
        super(p_326377_);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_326306_, Player p_326042_, InteractionHand p_326470_) {
        if (!p_326306_.isClientSide()) {
            Vec3 $$3 = p_326042_.getEyePosition().add(p_326042_.getForward().scale(0.8f));
            if (!p_326306_.getBlockState(BlockPos.containing($$3)).canBeReplaced()) {
                $$3 = p_326042_.getEyePosition().add(p_326042_.getForward().scale(0.05f));
            }
            WindCharge $$4 = new WindCharge(p_326042_, p_326306_, $$3.x(), $$3.y(), $$3.z());
            $$4.shootFromRotation(p_326042_, p_326042_.getXRot(), p_326042_.getYRot(), 0.0f, 1.5f, 1.0f);
            p_326306_.addFreshEntity($$4);
        }
        p_326306_.playSound(null, p_326042_.getX(), p_326042_.getY(), p_326042_.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (p_326306_.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack $$5 = p_326042_.getItemInHand(p_326470_);
        p_326042_.getCooldowns().addCooldown(this, 10);
        p_326042_.awardStat(Stats.ITEM_USED.get(this));
        $$5.consume(1, p_326042_);
        return InteractionResultHolder.sidedSuccess($$5, p_326306_.isClientSide());
    }

    @Override
    public Projectile asProjectile(Level p_338589_, Position p_338670_, ItemStack p_338308_, Direction p_338206_) {
        RandomSource $$4 = p_338589_.getRandom();
        double $$5 = $$4.triangle(p_338206_.getStepX(), 0.11485000000000001);
        double $$6 = $$4.triangle(p_338206_.getStepY(), 0.11485000000000001);
        double $$7 = $$4.triangle(p_338206_.getStepZ(), 0.11485000000000001);
        return new WindCharge(p_338589_, p_338670_.x(), p_338670_.y(), p_338670_.z(), $$5, $$6, $$7);
    }

    @Override
    public void shoot(Projectile p_338260_, double p_338763_, double p_338177_, double p_338349_, float p_338273_, float p_338257_) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((p_338288_, p_338801_) -> DispenserBlock.getDispensePosition(p_338288_, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).build();
    }
}

