/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record PotionContents(Optional<Holder<Potion>> potion, Optional<Integer> customColor, List<MobEffectInstance> customEffects) {
    private final List<MobEffectInstance> customEffects;
    public static final PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty(), List.of());
    private static final Component NO_EFFECT = Component.translatable("effect.none").withStyle(ChatFormatting.GRAY);
    private static final int EMPTY_COLOR = -524040;
    private static final int BASE_POTION_COLOR = -13083194;
    private static final Codec<PotionContents> FULL_CODEC = RecordCodecBuilder.create(p_337942_ -> p_337942_.group((App)BuiltInRegistries.POTION.holderByNameCodec().optionalFieldOf("potion").forGetter(PotionContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::customColor), (App)MobEffectInstance.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::customEffects)).apply((Applicative)p_337942_, PotionContents::new));
    public static final Codec<PotionContents> CODEC = Codec.withAlternative(FULL_CODEC, BuiltInRegistries.POTION.holderByNameCodec(), PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.POTION).apply(ByteBufCodecs::optional), PotionContents::potion, ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PotionContents::customColor, MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), PotionContents::customEffects, PotionContents::new);

    public PotionContents(Holder<Potion> p_331208_) {
        this(Optional.of(p_331208_), Optional.empty(), List.of());
    }

    public static ItemStack createItemStack(Item p_330388_, Holder<Potion> p_331030_) {
        ItemStack $$2 = new ItemStack(p_330388_);
        $$2.set(DataComponents.POTION_CONTENTS, new PotionContents(p_331030_));
        return $$2;
    }

    public boolean is(Holder<Potion> p_331328_) {
        return this.potion.isPresent() && this.potion.get().is(p_331328_) && this.customEffects.isEmpty();
    }

    public Iterable<MobEffectInstance> getAllEffects() {
        if (this.potion.isEmpty()) {
            return this.customEffects;
        }
        if (this.customEffects.isEmpty()) {
            return this.potion.get().value().getEffects();
        }
        return Iterables.concat(this.potion.get().value().getEffects(), this.customEffects);
    }

    public void forEachEffect(Consumer<MobEffectInstance> p_331190_) {
        if (this.potion.isPresent()) {
            for (MobEffectInstance $$1 : this.potion.get().value().getEffects()) {
                p_331190_.accept(new MobEffectInstance($$1));
            }
        }
        for (MobEffectInstance $$2 : this.customEffects) {
            p_331190_.accept(new MobEffectInstance($$2));
        }
    }

    public PotionContents withPotion(Holder<Potion> p_330288_) {
        return new PotionContents(Optional.of(p_330288_), this.customColor, this.customEffects);
    }

    public PotionContents withEffectAdded(MobEffectInstance p_332083_) {
        return new PotionContents(this.potion, this.customColor, Util.copyAndAdd(this.customEffects, p_332083_));
    }

    public int getColor() {
        if (this.customColor.isPresent()) {
            return this.customColor.get();
        }
        return PotionContents.getColor(this.getAllEffects());
    }

    public static int getColor(Holder<Potion> p_330619_) {
        return PotionContents.getColor(p_330619_.value().getEffects());
    }

    public static int getColor(Iterable<MobEffectInstance> p_331934_) {
        return PotionContents.getColorOptional(p_331934_).orElse(-13083194);
    }

    public static OptionalInt getColorOptional(Iterable<MobEffectInstance> p_332699_) {
        int $$1 = 0;
        int $$2 = 0;
        int $$3 = 0;
        int $$4 = 0;
        for (MobEffectInstance $$5 : p_332699_) {
            if (!$$5.isVisible()) continue;
            int $$6 = $$5.getEffect().value().getColor();
            int $$7 = $$5.getAmplifier() + 1;
            $$1 += $$7 * FastColor.ARGB32.red($$6);
            $$2 += $$7 * FastColor.ARGB32.green($$6);
            $$3 += $$7 * FastColor.ARGB32.blue($$6);
            $$4 += $$7;
        }
        if ($$4 == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(FastColor.ARGB32.color($$1 / $$4, $$2 / $$4, $$3 / $$4));
    }

    public boolean hasEffects() {
        if (!this.customEffects.isEmpty()) {
            return true;
        }
        return this.potion.isPresent() && !this.potion.get().value().getEffects().isEmpty();
    }

    public List<MobEffectInstance> customEffects() {
        return Lists.transform(this.customEffects, MobEffectInstance::new);
    }

    public void addPotionTooltip(Consumer<Component> p_331688_, float p_330466_, float p_332190_) {
        PotionContents.addPotionTooltip(this.getAllEffects(), p_331688_, p_330466_, p_332190_);
    }

    public static void addPotionTooltip(Iterable<MobEffectInstance> p_331825_, Consumer<Component> p_331296_, float p_332038_, float p_332014_) {
        ArrayList $$4 = Lists.newArrayList();
        boolean $$5 = true;
        for (MobEffectInstance $$6 : p_331825_) {
            $$5 = false;
            MutableComponent $$7 = Component.translatable($$6.getDescriptionId());
            Holder<MobEffect> $$8 = $$6.getEffect();
            $$8.value().createModifiers($$6.getAmplifier(), (p_331556_, p_330860_) -> $$4.add(new Pair(p_331556_, p_330860_)));
            if ($$6.getAmplifier() > 0) {
                $$7 = Component.translatable("potion.withAmplifier", $$7, Component.translatable("potion.potency." + $$6.getAmplifier()));
            }
            if (!$$6.endsWithin(20)) {
                $$7 = Component.translatable("potion.withDuration", $$7, MobEffectUtil.formatDuration($$6, p_332038_, p_332014_));
            }
            p_331296_.accept($$7.withStyle($$8.value().getCategory().getTooltipFormatting()));
        }
        if ($$5) {
            p_331296_.accept(NO_EFFECT);
        }
        if (!$$4.isEmpty()) {
            p_331296_.accept(CommonComponents.EMPTY);
            p_331296_.accept(Component.translatable("potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair $$9 : $$4) {
                double $$13;
                AttributeModifier $$10 = (AttributeModifier)$$9.getSecond();
                double $$11 = $$10.amount();
                if ($$10.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || $$10.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
                    double $$12 = $$10.amount() * 100.0;
                } else {
                    $$13 = $$10.amount();
                }
                if ($$11 > 0.0) {
                    p_331296_.accept(Component.translatable("attribute.modifier.plus." + $$10.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format($$13), Component.translatable(((Attribute)((Holder)$$9.getFirst()).value()).getDescriptionId())).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!($$11 < 0.0)) continue;
                p_331296_.accept(Component.translatable("attribute.modifier.take." + $$10.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format($$13 *= -1.0), Component.translatable(((Attribute)((Holder)$$9.getFirst()).value()).getDescriptionId())).withStyle(ChatFormatting.RED));
            }
        }
    }
}

