/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomData EMPTY = new CustomData(new CompoundTag());
    public static final Codec<CustomData> CODEC = CompoundTag.CODEC.xmap(CustomData::new, p_331996_ -> p_331996_.tag);
    public static final Codec<CustomData> CODEC_WITH_ID = CODEC.validate(p_331848_ -> p_331848_.getUnsafe().contains("id", 8) ? DataResult.success((Object)p_331848_) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf(p_331848_)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, p_331280_ -> p_331280_.tag);
    private final CompoundTag tag;

    private CustomData(CompoundTag p_331863_) {
        this.tag = p_331863_;
    }

    public static CustomData of(CompoundTag p_330724_) {
        return new CustomData(p_330724_.copy());
    }

    public static Predicate<ItemStack> itemMatcher(DataComponentType<CustomData> p_332149_, CompoundTag p_330658_) {
        return p_332154_ -> {
            CustomData $$3 = p_332154_.getOrDefault(p_332149_, EMPTY);
            return $$3.matchedBy(p_330658_);
        };
    }

    public boolean matchedBy(CompoundTag p_330550_) {
        return NbtUtils.compareNbt(p_330550_, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> p_331895_, ItemStack p_332185_, Consumer<CompoundTag> p_331274_) {
        CustomData $$3 = p_332185_.getOrDefault(p_331895_, EMPTY).update(p_331274_);
        if ($$3.tag.isEmpty()) {
            p_332185_.remove(p_331895_);
        } else {
            p_332185_.set(p_331895_, $$3);
        }
    }

    public static void set(DataComponentType<CustomData> p_330462_, ItemStack p_332015_, CompoundTag p_331019_) {
        if (!p_331019_.isEmpty()) {
            p_332015_.set(p_330462_, CustomData.of(p_331019_));
        } else {
            p_332015_.remove(p_330462_);
        }
    }

    public CustomData update(Consumer<CompoundTag> p_331451_) {
        CompoundTag $$1 = this.tag.copy();
        p_331451_.accept($$1);
        return new CustomData($$1);
    }

    public void loadInto(Entity p_331834_) {
        CompoundTag $$1 = p_331834_.saveWithoutId(new CompoundTag());
        UUID $$2 = p_331834_.getUUID();
        $$1.merge(this.tag);
        p_331834_.load($$1);
        p_331834_.setUUID($$2);
    }

    public boolean loadInto(BlockEntity p_331657_, HolderLookup.Provider p_331528_) {
        CompoundTag $$2 = p_331657_.saveCustomOnly(p_331528_);
        CompoundTag $$3 = $$2.copy();
        $$2.merge(this.tag);
        if (!$$2.equals($$3)) {
            try {
                p_331657_.loadCustomOnly($$2, p_331528_);
                p_331657_.setChanged();
            }
            catch (Exception $$4) {
                LOGGER.warn("Failed to apply custom data to block entity at {}", (Object)p_331657_.getBlockPos(), (Object)$$4);
                try {
                    p_331657_.loadCustomOnly($$3, p_331528_);
                }
                catch (Exception $$5) {
                    LOGGER.warn("Failed to rollback block entity at {} after failure", (Object)p_331657_.getBlockPos(), (Object)$$5);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public <T> DataResult<CustomData> update(MapEncoder<T> p_331823_, T p_332045_) {
        return p_331823_.encode(p_332045_, (DynamicOps)NbtOps.INSTANCE, NbtOps.INSTANCE.mapBuilder()).build((Object)this.tag).map(p_330397_ -> new CustomData((CompoundTag)p_330397_));
    }

    public <T> DataResult<T> read(MapDecoder<T> p_330352_) {
        MapLike $$1 = (MapLike)NbtOps.INSTANCE.getMap(this.tag).getOrThrow();
        return p_330352_.decode((DynamicOps)NbtOps.INSTANCE, $$1);
    }

    public int size() {
        return this.tag.size();
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public CompoundTag copyTag() {
        return this.tag.copy();
    }

    public boolean contains(String p_331843_) {
        return this.tag.contains(p_331843_);
    }

    public boolean equals(Object p_331195_) {
        if (p_331195_ == this) {
            return true;
        }
        if (p_331195_ instanceof CustomData) {
            CustomData $$1 = (CustomData)p_331195_;
            return this.tag.equals($$1.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    @Deprecated
    public CompoundTag getUnsafe() {
        return this.tag;
    }
}

