/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record ItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of(), true);
    private static final Codec<ItemAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(p_337947_ -> p_337947_.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(ItemAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(ItemAttributeModifiers::showInTooltip)).apply((Applicative)p_337947_, ItemAttributeModifiers::new));
    public static final Codec<ItemAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), p_332621_ -> new ItemAttributeModifiers((List<Entry>)p_332621_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ByteBufCodecs.BOOL, ItemAttributeModifiers::showInTooltip, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = Util.make(new DecimalFormat("#.##"), p_331600_ -> p_331600_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public ItemAttributeModifiers withTooltip(boolean p_335777_) {
        return new ItemAttributeModifiers(this.modifiers, p_335777_);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<Attribute> p_330266_, AttributeModifier p_331954_, EquipmentSlotGroup p_332175_) {
        ImmutableList.Builder $$3 = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry $$4 : this.modifiers) {
            if ($$4.modifier.id().equals(p_331954_.id())) continue;
            $$3.add((Object)$$4);
        }
        $$3.add((Object)new Entry(p_330266_, p_331954_, p_332175_));
        return new ItemAttributeModifiers((List<Entry>)$$3.build(), this.showInTooltip);
    }

    public void forEach(EquipmentSlot p_332158_, BiConsumer<Holder<Attribute>, AttributeModifier> p_331684_) {
        for (Entry $$2 : this.modifiers) {
            if (!$$2.slot.test(p_332158_)) continue;
            p_331684_.accept($$2.attribute, $$2.modifier);
        }
    }

    public double compute(double p_330928_, EquipmentSlot p_330945_) {
        double $$2 = p_330928_;
        for (Entry $$3 : this.modifiers) {
            if (!$$3.slot.test(p_330945_)) continue;
            double $$4 = $$3.modifier.amount();
            $$2 += (switch ($$3.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> $$4;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> $$4 * p_330928_;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> $$4 * $$2;
            });
        }
        return $$2;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> p_330324_, AttributeModifier p_331766_, EquipmentSlotGroup p_331205_) {
            this.entries.add((Object)new Entry(p_330324_, p_331766_, p_331205_));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(p_337948_ -> p_337948_.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(Entry::slot)).apply((Applicative)p_337948_, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ATTRIBUTE), Entry::attribute, AttributeModifier.STREAM_CODEC, Entry::modifier, EquipmentSlotGroup.STREAM_CODEC, Entry::slot, Entry::new);
    }
}

