/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public interface Recipe<C extends Container> {
    public static final Codec<Recipe<?>> CODEC = BuiltInRegistries.RECIPE_SERIALIZER.byNameCodec().dispatch(Recipe::getSerializer, RecipeSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Recipe<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.RECIPE_SERIALIZER).dispatch(Recipe::getSerializer, RecipeSerializer::streamCodec);

    public boolean matches(C var1, Level var2);

    public ItemStack assemble(C var1, HolderLookup.Provider var2);

    public boolean canCraftInDimensions(int var1, int var2);

    public ItemStack getResultItem(HolderLookup.Provider var1);

    default public NonNullList<ItemStack> getRemainingItems(C p_44004_) {
        NonNullList<ItemStack> $$1 = NonNullList.withSize(p_44004_.getContainerSize(), ItemStack.EMPTY);
        for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
            Item $$3 = p_44004_.getItem($$2).getItem();
            if (!$$3.hasCraftingRemainingItem()) continue;
            $$1.set($$2, new ItemStack($$3.getCraftingRemainingItem()));
        }
        return $$1;
    }

    default public NonNullList<Ingredient> getIngredients() {
        return NonNullList.create();
    }

    default public boolean isSpecial() {
        return false;
    }

    default public boolean showNotification() {
        return true;
    }

    default public String getGroup() {
        return "";
    }

    default public ItemStack getToastSymbol() {
        return new ItemStack(Blocks.CRAFTING_TABLE);
    }

    public RecipeSerializer<?> getSerializer();

    public RecipeType<?> getType();

    default public boolean isIncomplete() {
        NonNullList<Ingredient> $$0 = this.getIngredients();
        return $$0.isEmpty() || $$0.stream().anyMatch(p_151268_ -> p_151268_.getItems().length == 0);
    }
}

