/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecipeCache {
    private final Entry[] entries;
    private WeakReference<RecipeManager> cachedRecipeManager = new WeakReference<Object>(null);

    public RecipeCache(int p_307489_) {
        this.entries = new Entry[p_307489_];
    }

    public Optional<RecipeHolder<CraftingRecipe>> get(Level p_307315_, CraftingContainer p_307684_) {
        if (p_307684_.isEmpty()) {
            return Optional.empty();
        }
        this.validateRecipeManager(p_307315_);
        for (int $$2 = 0; $$2 < this.entries.length; ++$$2) {
            Entry $$3 = this.entries[$$2];
            if ($$3 == null || !$$3.matches(p_307684_.getItems())) continue;
            this.moveEntryToFront($$2);
            return Optional.ofNullable($$3.value());
        }
        return this.compute(p_307684_, p_307315_);
    }

    private void validateRecipeManager(Level p_307638_) {
        RecipeManager $$1 = p_307638_.getRecipeManager();
        if ($$1 != this.cachedRecipeManager.get()) {
            this.cachedRecipeManager = new WeakReference<RecipeManager>($$1);
            Arrays.fill(this.entries, null);
        }
    }

    private Optional<RecipeHolder<CraftingRecipe>> compute(CraftingContainer p_307329_, Level p_307202_) {
        Optional<RecipeHolder<CraftingRecipe>> $$2 = p_307202_.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, p_307329_, p_307202_);
        this.insert(p_307329_.getItems(), $$2.orElse(null));
        return $$2;
    }

    private void moveEntryToFront(int p_307277_) {
        if (p_307277_ > 0) {
            Entry $$1 = this.entries[p_307277_];
            System.arraycopy(this.entries, 0, this.entries, 1, p_307277_);
            this.entries[0] = $$1;
        }
    }

    private void insert(List<ItemStack> p_307307_, @Nullable RecipeHolder<CraftingRecipe> p_336146_) {
        NonNullList<ItemStack> $$2 = NonNullList.withSize(p_307307_.size(), ItemStack.EMPTY);
        for (int $$3 = 0; $$3 < p_307307_.size(); ++$$3) {
            $$2.set($$3, p_307307_.get($$3).copyWithCount(1));
        }
        System.arraycopy(this.entries, 0, this.entries, 1, this.entries.length - 1);
        this.entries[0] = new Entry($$2, p_336146_);
    }

    record Entry(NonNullList<ItemStack> key, @Nullable RecipeHolder<CraftingRecipe> value) {
        public boolean matches(List<ItemStack> p_307411_) {
            if (this.key.size() != p_307411_.size()) {
                return false;
            }
            for (int $$1 = 0; $$1 < this.key.size(); ++$$1) {
                if (ItemStack.isSameItemSameComponents(this.key.get($$1), p_307411_.get($$1))) continue;
                return false;
            }
            return true;
        }
    }
}

