/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup.Provider registries;
    private Multimap<RecipeType<?>, RecipeHolder<?>> byType = ImmutableMultimap.of();
    private Map<ResourceLocation, RecipeHolder<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public RecipeManager(HolderLookup.Provider p_324137_) {
        super(GSON, "recipes");
        this.registries = p_324137_;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.hasErrors = false;
        ImmutableMultimap.Builder $$3 = ImmutableMultimap.builder();
        ImmutableMap.Builder $$4 = ImmutableMap.builder();
        RegistryOps $$5 = this.registries.createSerializationContext(JsonOps.INSTANCE);
        for (Map.Entry<ResourceLocation, JsonElement> $$6 : p_44037_.entrySet()) {
            ResourceLocation $$7 = $$6.getKey();
            try {
                Recipe $$8 = (Recipe)Recipe.CODEC.parse($$5, (Object)$$6.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<Recipe> $$9 = new RecipeHolder<Recipe>($$7, $$8);
                $$3.put($$8.getType(), $$9);
                $$4.put((Object)$$7, $$9);
            }
            catch (JsonParseException | IllegalArgumentException $$10) {
                LOGGER.error("Parsing error loading recipe {}", (Object)$$7, (Object)$$10);
            }
        }
        this.byType = $$3.build();
        this.byName = $$4.build();
        LOGGER.info("Loaded {} recipes", (Object)this.byType.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_44016_, C p_44017_, Level p_44018_) {
        return this.byType(p_44016_).stream().filter(p_300819_ -> p_300819_.value().matches(p_44017_, p_44018_)).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_220249_, C p_220250_, Level p_220251_, @Nullable ResourceLocation p_220252_) {
        RecipeHolder<T> $$4;
        if (p_220252_ != null && ($$4 = this.byKeyTyped(p_220249_, p_220252_)) != null && $$4.value().matches(p_220250_, p_220251_)) {
            return Optional.of($$4);
        }
        return this.byType(p_220249_).stream().filter(p_300822_ -> p_300822_.value().matches(p_220250_, p_220251_)).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getAllRecipesFor(RecipeType<T> p_44014_) {
        return List.copyOf(this.byType(p_44014_));
    }

    public <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getRecipesFor(RecipeType<T> p_44057_, C p_44058_, Level p_44059_) {
        return this.byType(p_44057_).stream().filter(p_341576_ -> p_341576_.value().matches(p_44058_, p_44059_)).sorted(Comparator.comparing(p_335290_ -> p_335290_.value().getResultItem(p_44059_.registryAccess()).getDescriptionId())).collect(Collectors.toList());
    }

    private <C extends Container, T extends Recipe<C>> Collection<RecipeHolder<T>> byType(RecipeType<T> p_44055_) {
        return this.byType.get(p_44055_);
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> getRemainingItemsFor(RecipeType<T> p_44070_, C p_44071_, Level p_44072_) {
        Optional<RecipeHolder<T>> $$3 = this.getRecipeFor(p_44070_, p_44071_, p_44072_);
        if ($$3.isPresent()) {
            return $$3.get().value().getRemainingItems(p_44071_);
        }
        NonNullList<ItemStack> $$4 = NonNullList.withSize(p_44071_.getContainerSize(), ItemStack.EMPTY);
        for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
            $$4.set($$5, p_44071_.getItem($$5));
        }
        return $$4;
    }

    public Optional<RecipeHolder<?>> byKey(ResourceLocation p_44044_) {
        return Optional.ofNullable(this.byName.get(p_44044_));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> p_341695_, ResourceLocation p_341666_) {
        RecipeHolder<?> $$2 = this.byName.get(p_341666_);
        if ($$2 != null && $$2.value().getType().equals(p_341695_)) {
            return $$2;
        }
        return null;
    }

    public Collection<RecipeHolder<?>> getOrderedRecipes() {
        return this.byType.values();
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.byName.values();
    }

    public Stream<ResourceLocation> getRecipeIds() {
        return this.byName.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceLocation p_44046_, JsonObject p_44047_, HolderLookup.Provider p_323755_) {
        Recipe $$3 = (Recipe)Recipe.CODEC.parse(p_323755_.createSerializationContext(JsonOps.INSTANCE), (Object)p_44047_).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(p_44046_, $$3);
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> p_44025_) {
        this.hasErrors = false;
        ImmutableMultimap.Builder $$1 = ImmutableMultimap.builder();
        ImmutableMap.Builder $$2 = ImmutableMap.builder();
        for (RecipeHolder<?> $$3 : p_44025_) {
            RecipeType<?> $$4 = $$3.value().getType();
            $$1.put($$4, $$3);
            $$2.put((Object)$$3.id(), $$3);
        }
        this.byType = $$1.build();
        this.byName = $$2.build();
    }

    public static <C extends Container, T extends Recipe<C>> CachedCheck<C, T> createCheck(final RecipeType<T> p_220268_) {
        return new CachedCheck<C, T>(){
            @Nullable
            private ResourceLocation lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(C p_220278_, Level p_220279_) {
                RecipeManager $$2 = p_220279_.getRecipeManager();
                Optional $$3 = $$2.getRecipeFor(p_220268_, p_220278_, p_220279_, this.lastRecipe);
                if ($$3.isPresent()) {
                    RecipeHolder $$4 = $$3.get();
                    this.lastRecipe = $$4.id();
                    return Optional.of($$4);
                }
                return Optional.empty();
            }
        };
    }

    public static interface CachedCheck<C extends Container, T extends Recipe<C>> {
        public Optional<RecipeHolder<T>> getRecipeFor(C var1, Level var2);
    }
}

