/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class RepairItemRecipe
extends CustomRecipe {
    public RepairItemRecipe(CraftingBookCategory p_248679_) {
        super(p_248679_);
    }

    @Nullable
    private Pair<ItemStack, ItemStack> getItemsToCombine(CraftingContainer p_335540_) {
        ItemStack $$1 = null;
        ItemStack $$2 = null;
        for (int $$3 = 0; $$3 < p_335540_.getContainerSize(); ++$$3) {
            ItemStack $$4 = p_335540_.getItem($$3);
            if ($$4.isEmpty()) continue;
            if ($$1 == null) {
                $$1 = $$4;
                continue;
            }
            if ($$2 == null) {
                $$2 = $$4;
                continue;
            }
            return null;
        }
        if ($$1 != null && $$2 != null && RepairItemRecipe.canCombine($$1, $$2)) {
            return Pair.of((Object)$$1, $$2);
        }
        return null;
    }

    private static boolean canCombine(ItemStack p_336139_, ItemStack p_335795_) {
        return p_335795_.is(p_336139_.getItem()) && p_336139_.getCount() == 1 && p_335795_.getCount() == 1 && p_336139_.has(DataComponents.MAX_DAMAGE) && p_335795_.has(DataComponents.MAX_DAMAGE) && p_336139_.has(DataComponents.DAMAGE) && p_335795_.has(DataComponents.DAMAGE);
    }

    @Override
    public boolean matches(CraftingContainer p_44138_, Level p_44139_) {
        return this.getItemsToCombine(p_44138_) != null;
    }

    @Override
    public ItemStack assemble(CraftingContainer p_335863_, HolderLookup.Provider p_335610_) {
        Pair<ItemStack, ItemStack> $$2 = this.getItemsToCombine(p_335863_);
        if ($$2 == null) {
            return ItemStack.EMPTY;
        }
        ItemStack $$3 = (ItemStack)$$2.getFirst();
        ItemStack $$4 = (ItemStack)$$2.getSecond();
        int $$5 = Math.max($$3.getMaxDamage(), $$4.getMaxDamage());
        int $$6 = $$3.getMaxDamage() - $$3.getDamageValue();
        int $$7 = $$4.getMaxDamage() - $$4.getDamageValue();
        int $$8 = $$6 + $$7 + $$5 * 5 / 100;
        ItemStack $$9 = new ItemStack($$3.getItem());
        $$9.set(DataComponents.MAX_DAMAGE, $$5);
        $$9.setDamageValue(Math.max($$5 - $$8, 0));
        ItemEnchantments $$10 = EnchantmentHelper.getEnchantmentsForCrafting($$3);
        ItemEnchantments $$11 = EnchantmentHelper.getEnchantmentsForCrafting($$4);
        EnchantmentHelper.updateEnchantments($$9, p_335294_ -> p_335610_.lookupOrThrow(Registries.ENCHANTMENT).listElements().map(Holder::value).filter(Enchantment::isCurse).forEach(p_330117_ -> {
            int $$4 = Math.max($$10.getLevel((Enchantment)p_330117_), $$11.getLevel((Enchantment)p_330117_));
            if ($$4 > 0) {
                p_335294_.upgrade((Enchantment)p_330117_, $$4);
            }
        }));
        return $$9;
    }

    @Override
    public boolean canCraftInDimensions(int p_44128_, int p_44129_) {
        return p_44128_ * p_44129_ >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

