/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.Ingredient;

public record ShapedRecipePattern(int width, int height, NonNullList<Ingredient> ingredients, Optional<Data> data) {
    private static final int MAX_SIZE = 3;
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, p_311830_ -> p_311830_.data().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> STREAM_CODEC = StreamCodec.ofMember(ShapedRecipePattern::toNetwork, ShapedRecipePattern::fromNetwork);

    public static ShapedRecipePattern of(Map<Character, Ingredient> p_312851_, String ... p_312645_) {
        return ShapedRecipePattern.of(p_312851_, List.of(p_312645_));
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> p_312370_, List<String> p_312701_) {
        Data $$2 = new Data(p_312370_, p_312701_);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack($$2).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(Data p_312037_) {
        String[] $$1 = ShapedRecipePattern.shrink(p_312037_.pattern);
        int $$2 = $$1[0].length();
        int $$3 = $$1.length;
        NonNullList<Ingredient> $$4 = NonNullList.withSize($$2 * $$3, Ingredient.EMPTY);
        CharArraySet $$5 = new CharArraySet(p_312037_.key.keySet());
        for (int $$6 = 0; $$6 < $$1.length; ++$$6) {
            String $$7 = $$1[$$6];
            for (int $$8 = 0; $$8 < $$7.length(); ++$$8) {
                Ingredient $$10;
                char $$9 = $$7.charAt($$8);
                Ingredient ingredient = $$10 = $$9 == ' ' ? Ingredient.EMPTY : p_312037_.key.get(Character.valueOf($$9));
                if ($$10 == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + $$9 + "' but it's not defined in the key");
                }
                $$5.remove($$9);
                $$4.set($$8 + $$2 * $$6, $$10);
            }
        }
        if (!$$5.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.lambda$unpack$4((CharSet)$$5));
        }
        return DataResult.success((Object)new ShapedRecipePattern($$2, $$3, $$4, Optional.of(p_312037_)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> p_311893_) {
        int $$1 = Integer.MAX_VALUE;
        int $$2 = 0;
        int $$3 = 0;
        int $$4 = 0;
        for (int $$5 = 0; $$5 < p_311893_.size(); ++$$5) {
            String $$6 = p_311893_.get($$5);
            $$1 = Math.min($$1, ShapedRecipePattern.firstNonSpace($$6));
            int $$7 = ShapedRecipePattern.lastNonSpace($$6);
            $$2 = Math.max($$2, $$7);
            if ($$7 < 0) {
                if ($$3 == $$5) {
                    ++$$3;
                }
                ++$$4;
                continue;
            }
            $$4 = 0;
        }
        if (p_311893_.size() == $$4) {
            return new String[0];
        }
        String[] $$8 = new String[p_311893_.size() - $$4 - $$3];
        for (int $$9 = 0; $$9 < $$8.length; ++$$9) {
            $$8[$$9] = p_311893_.get($$9 + $$3).substring($$1, $$2 + 1);
        }
        return $$8;
    }

    private static int firstNonSpace(String p_312343_) {
        int $$1;
        for ($$1 = 0; $$1 < p_312343_.length() && p_312343_.charAt($$1) == ' '; ++$$1) {
        }
        return $$1;
    }

    private static int lastNonSpace(String p_311944_) {
        int $$1;
        for ($$1 = p_311944_.length() - 1; $$1 >= 0 && p_311944_.charAt($$1) == ' '; --$$1) {
        }
        return $$1;
    }

    public boolean matches(CraftingContainer p_311919_) {
        for (int $$1 = 0; $$1 <= p_311919_.getWidth() - this.width; ++$$1) {
            for (int $$2 = 0; $$2 <= p_311919_.getHeight() - this.height; ++$$2) {
                if (this.matches(p_311919_, $$1, $$2, true)) {
                    return true;
                }
                if (!this.matches(p_311919_, $$1, $$2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer p_312113_, int p_312598_, int p_312930_, boolean p_312052_) {
        for (int $$4 = 0; $$4 < p_312113_.getWidth(); ++$$4) {
            for (int $$5 = 0; $$5 < p_312113_.getHeight(); ++$$5) {
                int $$6 = $$4 - p_312598_;
                int $$7 = $$5 - p_312930_;
                Ingredient $$8 = Ingredient.EMPTY;
                if ($$6 >= 0 && $$7 >= 0 && $$6 < this.width && $$7 < this.height) {
                    $$8 = p_312052_ ? this.ingredients.get(this.width - $$6 - 1 + $$7 * this.width) : this.ingredients.get($$6 + $$7 * this.width);
                }
                if ($$8.test(p_312113_.getItem($$4 + $$5 * p_312113_.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    private void toNetwork(RegistryFriendlyByteBuf p_320098_) {
        p_320098_.writeVarInt(this.width);
        p_320098_.writeVarInt(this.height);
        for (Ingredient $$1 : this.ingredients) {
            Ingredient.CONTENTS_STREAM_CODEC.encode(p_320098_, $$1);
        }
    }

    private static ShapedRecipePattern fromNetwork(RegistryFriendlyByteBuf p_319788_) {
        int $$1 = p_319788_.readVarInt();
        int $$2 = p_319788_.readVarInt();
        NonNullList<Ingredient> $$3 = NonNullList.withSize($$1 * $$2, Ingredient.EMPTY);
        $$3.replaceAll(p_319733_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_319788_));
        return new ShapedRecipePattern($$1, $$2, $$3, Optional.empty());
    }

    private static /* synthetic */ String lambda$unpack$4(CharSet p_339534_) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(p_339534_);
    }

    public record Data(Map<Character, Ingredient> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(p_312085_ -> {
            if (p_312085_.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (p_312085_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int $$1 = ((String)p_312085_.get(0)).length();
            for (String $$2 : p_312085_) {
                if ($$2.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if ($$1 == $$2.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_312085_);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(p_312250_ -> {
            if (p_312250_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_312250_ + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(p_312250_)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf(p_312250_.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(p_312573_ -> p_312573_.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter(p_312509_ -> p_312509_.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(p_312713_ -> p_312713_.pattern)).apply((Applicative)p_312573_, Data::new));
    }
}

