/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ShapelessRecipe
implements CraftingRecipe {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;

    public ShapelessRecipe(String p_249640_, CraftingBookCategory p_249390_, ItemStack p_252071_, NonNullList<Ingredient> p_250689_) {
        this.group = p_249640_;
        this.category = p_249390_;
        this.result = p_252071_;
        this.ingredients = p_250689_;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider p_335606_) {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(CraftingContainer p_44262_, Level p_44263_) {
        StackedContents $$2 = new StackedContents();
        int $$3 = 0;
        for (int $$4 = 0; $$4 < p_44262_.getContainerSize(); ++$$4) {
            ItemStack $$5 = p_44262_.getItem($$4);
            if ($$5.isEmpty()) continue;
            ++$$3;
            $$2.accountStack($$5, 1);
        }
        return $$3 == this.ingredients.size() && $$2.canCraft(this, null);
    }

    @Override
    public ItemStack assemble(CraftingContainer p_44260_, HolderLookup.Provider p_335725_) {
        return this.result.copy();
    }

    @Override
    public boolean canCraftInDimensions(int p_44252_, int p_44253_) {
        return p_44252_ * p_44253_ >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessRecipe> {
        private static final MapCodec<ShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Ingredient[] $$1 = (Ingredient[])p_301021_.stream().filter(p_300883_ -> !p_300883_.isEmpty()).toArray(Ingredient[]::new);
            if ($$1.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            if ($$1.length > 9) {
                return DataResult.error(() -> "Too many ingredients for shapeless recipe");
            }
            return DataResult.success(NonNullList.of(Ingredient.EMPTY, $$1));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.ingredients)).apply((Applicative)p_340779_, ShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<ShapelessRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessRecipe fromNetwork(RegistryFriendlyByteBuf p_319905_) {
            String $$1 = p_319905_.readUtf();
            CraftingBookCategory $$2 = p_319905_.readEnum(CraftingBookCategory.class);
            int $$3 = p_319905_.readVarInt();
            NonNullList<Ingredient> $$4 = NonNullList.withSize($$3, Ingredient.EMPTY);
            $$4.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_319905_));
            ItemStack $$5 = (ItemStack)ItemStack.STREAM_CODEC.decode(p_319905_);
            return new ShapelessRecipe($$1, $$2, $$5, $$4);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_320371_, ShapelessRecipe p_320323_) {
            p_320371_.writeUtf(p_320323_.group);
            p_320371_.writeEnum(p_320323_.category);
            p_320371_.writeVarInt(p_320323_.ingredients.size());
            for (Ingredient $$2 : p_320323_.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode(p_320371_, $$2);
            }
            ItemStack.STREAM_CODEC.encode(p_320371_, p_320323_.result);
        }
    }
}

