/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;

    public SmithingTrimRecipe(Ingredient p_267298_, Ingredient p_266862_, Ingredient p_267050_) {
        this.template = p_267298_;
        this.base = p_266862_;
        this.addition = p_267050_;
    }

    @Override
    public boolean matches(Container p_267224_, Level p_266798_) {
        return this.template.test(p_267224_.getItem(0)) && this.base.test(p_267224_.getItem(1)) && this.addition.test(p_267224_.getItem(2));
    }

    @Override
    public ItemStack assemble(Container p_267320_, HolderLookup.Provider p_335536_) {
        ItemStack $$2 = p_267320_.getItem(1);
        if (this.base.test($$2)) {
            Optional<Holder.Reference<TrimMaterial>> $$3 = TrimMaterials.getFromIngredient(p_335536_, p_267320_.getItem(2));
            Optional<Holder.Reference<TrimPattern>> $$4 = TrimPatterns.getFromTemplate(p_335536_, p_267320_.getItem(0));
            if ($$3.isPresent() && $$4.isPresent()) {
                ArmorTrim $$5 = $$2.get(DataComponents.TRIM);
                if ($$5 != null && $$5.hasPatternAndMaterial((Holder<TrimPattern>)$$4.get(), (Holder<TrimMaterial>)$$3.get())) {
                    return ItemStack.EMPTY;
                }
                ItemStack $$6 = $$2.copyWithCount(1);
                $$6.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)$$3.get(), (Holder<TrimPattern>)$$4.get()));
                return $$6;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider p_335445_) {
        ItemStack $$1 = new ItemStack(Items.IRON_CHESTPLATE);
        Optional $$2 = p_335445_.lookupOrThrow(Registries.TRIM_PATTERN).listElements().findFirst();
        Optional<Holder.Reference<TrimMaterial>> $$3 = p_335445_.lookupOrThrow(Registries.TRIM_MATERIAL).get(TrimMaterials.REDSTONE);
        if ($$2.isPresent() && $$3.isPresent()) {
            $$1.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)$$3.get(), $$2.get()));
        }
        return $$1;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack p_266762_) {
        return this.template.test(p_266762_);
    }

    @Override
    public boolean isBaseIngredient(ItemStack p_266795_) {
        return this.base.test(p_266795_);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack p_266922_) {
        return this.addition.test(p_266922_);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(Ingredient::isEmpty);
    }

    public static class Serializer
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec(p_301227_ -> p_301227_.group((App)Ingredient.CODEC.fieldOf("template").forGetter(p_301070_ -> p_301070_.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(p_300969_ -> p_300969_.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(p_300977_ -> p_300977_.addition)).apply((Applicative)p_301227_, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingTrimRecipe fromNetwork(RegistryFriendlyByteBuf p_320719_) {
            Ingredient $$1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_320719_);
            Ingredient $$2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_320719_);
            Ingredient $$3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_320719_);
            return new SmithingTrimRecipe($$1, $$2, $$3);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_319922_, SmithingTrimRecipe p_320655_) {
            Ingredient.CONTENTS_STREAM_CODEC.encode(p_319922_, p_320655_.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode(p_319922_, p_320655_.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode(p_319922_, p_320655_.addition);
        }
    }
}

