/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.BreachEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    public static int getItemEnchantmentLevel(Enchantment p_44844_, ItemStack p_44845_) {
        ItemEnchantments $$2 = p_44845_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return $$2.getLevel(p_44844_);
    }

    public static ItemEnchantments updateEnchantments(ItemStack p_331034_, Consumer<ItemEnchantments.Mutable> p_332031_) {
        DataComponentType<ItemEnchantments> $$2 = EnchantmentHelper.getComponentType(p_331034_);
        ItemEnchantments $$3 = p_331034_.get($$2);
        if ($$3 == null) {
            return ItemEnchantments.EMPTY;
        }
        ItemEnchantments.Mutable $$4 = new ItemEnchantments.Mutable($$3);
        p_332031_.accept($$4);
        ItemEnchantments $$5 = $$4.toImmutable();
        p_331034_.set($$2, $$5);
        return $$5;
    }

    public static boolean canStoreEnchantments(ItemStack p_330666_) {
        return p_330666_.has(EnchantmentHelper.getComponentType(p_330666_));
    }

    public static void setEnchantments(ItemStack p_44867_, ItemEnchantments p_332148_) {
        p_44867_.set(EnchantmentHelper.getComponentType(p_44867_), p_332148_);
    }

    public static ItemEnchantments getEnchantmentsForCrafting(ItemStack p_330538_) {
        return p_330538_.getOrDefault(EnchantmentHelper.getComponentType(p_330538_), ItemEnchantments.EMPTY);
    }

    private static DataComponentType<ItemEnchantments> getComponentType(ItemStack p_331909_) {
        return p_331909_.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static boolean hasAnyEnchantments(ItemStack p_332657_) {
        return !p_332657_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !p_332657_.getOrDefault(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public static float getSweepingDamageRatio(int p_335376_) {
        return 1.0f - 1.0f / (float)(p_335376_ + 1);
    }

    private static void runIterationOnItem(EnchantmentVisitor p_44851_, ItemStack p_44852_) {
        ItemEnchantments $$2 = p_44852_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : $$2.entrySet()) {
            p_44851_.accept((Enchantment)((Holder)$$3.getKey()).value(), $$3.getIntValue());
        }
    }

    private static void runIterationOnInventory(EnchantmentVisitor p_44854_, Iterable<ItemStack> p_44855_) {
        for (ItemStack $$2 : p_44855_) {
            EnchantmentHelper.runIterationOnItem(p_44854_, $$2);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> p_44857_, DamageSource p_44858_) {
        MutableInt $$2 = new MutableInt();
        EnchantmentHelper.runIterationOnInventory((p_44892_, p_44893_) -> $$2.add(p_44892_.getDamageProtection(p_44893_, p_44858_)), p_44857_);
        return $$2.intValue();
    }

    public static float getDamageBonus(ItemStack p_44834_, @Nullable EntityType<?> p_320195_) {
        MutableFloat $$2 = new MutableFloat();
        EnchantmentHelper.runIterationOnItem((p_319741_, p_319742_) -> $$2.add(p_319741_.getDamageBonus(p_319742_, p_320195_)), p_44834_);
        return $$2.floatValue();
    }

    public static float getSweepingDamageRatio(LivingEntity p_44822_) {
        int $$1 = EnchantmentHelper.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, p_44822_);
        if ($$1 > 0) {
            return EnchantmentHelper.getSweepingDamageRatio($$1);
        }
        return 0.0f;
    }

    public static float calculateArmorBreach(@Nullable Entity p_338241_, float p_338545_) {
        LivingEntity $$2;
        int $$3;
        if (p_338241_ instanceof LivingEntity && ($$3 = EnchantmentHelper.getEnchantmentLevel(Enchantments.BREACH, $$2 = (LivingEntity)p_338241_)) > 0) {
            return BreachEnchantment.calculateArmorBreach($$3, p_338545_);
        }
        return p_338545_;
    }

    public static void doPostHurtEffects(LivingEntity p_44824_, Entity p_44825_) {
        EnchantmentVisitor $$2 = (p_44902_, p_44903_) -> p_44902_.doPostHurt(p_44824_, p_44825_, p_44903_);
        if (p_44824_ != null) {
            EnchantmentHelper.runIterationOnInventory($$2, p_44824_.getAllSlots());
        }
        if (p_44825_ instanceof Player) {
            EnchantmentHelper.runIterationOnItem($$2, p_44824_.getMainHandItem());
        }
    }

    public static void doPostDamageEffects(LivingEntity p_44897_, Entity p_44898_) {
        EnchantmentVisitor $$2 = (p_44829_, p_44830_) -> p_44829_.doPostAttack(p_44897_, p_44898_, p_44830_);
        if (p_44897_ != null) {
            EnchantmentHelper.runIterationOnInventory($$2, p_44897_.getAllSlots());
        }
        if (p_44897_ instanceof Player) {
            EnchantmentHelper.runIterationOnItem($$2, p_44897_.getMainHandItem());
        }
    }

    public static void doPostItemStackHurtEffects(LivingEntity p_338188_, Entity p_338394_, ItemEnchantments p_338474_) {
        for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : p_338474_.entrySet()) {
            ((Enchantment)((Holder)$$3.getKey()).value()).doPostItemStackHurt(p_338188_, p_338394_, $$3.getIntValue());
        }
    }

    public static int getEnchantmentLevel(Enchantment p_44837_, LivingEntity p_44838_) {
        Collection<ItemStack> $$2 = p_44837_.getSlotItems(p_44838_).values();
        if ($$2 == null) {
            return 0;
        }
        int $$3 = 0;
        for (ItemStack $$4 : $$2) {
            int $$5 = EnchantmentHelper.getItemEnchantmentLevel(p_44837_, $$4);
            if ($$5 <= $$3) continue;
            $$3 = $$5;
        }
        return $$3;
    }

    public static float getSneakingSpeedBonus(LivingEntity p_220303_) {
        return (float)EnchantmentHelper.getEnchantmentLevel(Enchantments.SWIFT_SNEAK, p_220303_) * 0.15f;
    }

    public static int getKnockbackBonus(LivingEntity p_44895_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.KNOCKBACK, p_44895_);
    }

    public static int getFireAspect(LivingEntity p_44915_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_ASPECT, p_44915_);
    }

    public static int getRespiration(LivingEntity p_44919_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.RESPIRATION, p_44919_);
    }

    public static int getDepthStrider(LivingEntity p_44923_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, p_44923_);
    }

    public static int getBlockEfficiency(LivingEntity p_44927_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.EFFICIENCY, p_44927_);
    }

    public static int getFishingLuckBonus(ItemStack p_44905_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LUCK_OF_THE_SEA, p_44905_);
    }

    public static int getFishingSpeedBonus(ItemStack p_44917_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LURE, p_44917_);
    }

    public static int getMobLooting(LivingEntity p_44931_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.LOOTING, p_44931_);
    }

    public static boolean hasAquaAffinity(LivingEntity p_44935_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, p_44935_) > 0;
    }

    public static boolean hasFrostWalker(LivingEntity p_44939_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FROST_WALKER, p_44939_) > 0;
    }

    public static boolean hasSoulSpeed(LivingEntity p_44943_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, p_44943_) > 0;
    }

    public static boolean hasBindingCurse(ItemStack p_44921_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, p_44921_) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack p_44925_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, p_44925_) > 0;
    }

    public static boolean hasSilkTouch(ItemStack p_273444_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, p_273444_) > 0;
    }

    public static int getLoyalty(ItemStack p_44929_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LOYALTY, p_44929_);
    }

    public static int getRiptide(ItemStack p_44933_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.RIPTIDE, p_44933_);
    }

    public static boolean hasChanneling(ItemStack p_44937_) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.CHANNELING, p_44937_) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment p_44907_, LivingEntity p_44908_) {
        return EnchantmentHelper.getRandomItemWith(p_44907_, p_44908_, p_44941_ -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment p_44840_, LivingEntity p_44841_, Predicate<ItemStack> p_44842_) {
        Map<EquipmentSlot, ItemStack> $$3 = p_44840_.getSlotItems(p_44841_);
        if ($$3.isEmpty()) {
            return null;
        }
        ArrayList $$4 = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> $$5 : $$3.entrySet()) {
            ItemStack $$6 = $$5.getValue();
            if ($$6.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel(p_44840_, $$6) <= 0 || !p_44842_.test($$6)) continue;
            $$4.add($$5);
        }
        return $$4.isEmpty() ? null : (Map.Entry)$$4.get(p_44841_.getRandom().nextInt($$4.size()));
    }

    public static int getEnchantmentCost(RandomSource p_220288_, int p_220289_, int p_220290_, ItemStack p_220291_) {
        Item $$4 = p_220291_.getItem();
        int $$5 = $$4.getEnchantmentValue();
        if ($$5 <= 0) {
            return 0;
        }
        if (p_220290_ > 15) {
            p_220290_ = 15;
        }
        int $$6 = p_220288_.nextInt(8) + 1 + (p_220290_ >> 1) + p_220288_.nextInt(p_220290_ + 1);
        if (p_220289_ == 0) {
            return Math.max($$6 / 3, 1);
        }
        if (p_220289_ == 1) {
            return $$6 * 2 / 3 + 1;
        }
        return Math.max($$6, p_220290_ * 2);
    }

    public static ItemStack enchantItem(FeatureFlagSet p_338479_, RandomSource p_220293_, ItemStack p_220294_, int p_220295_, boolean p_220296_) {
        List<EnchantmentInstance> $$5 = EnchantmentHelper.selectEnchantment(p_338479_, p_220293_, p_220294_, p_220295_, p_220296_);
        if (p_220294_.is(Items.BOOK)) {
            p_220294_ = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance $$6 : $$5) {
            p_220294_.enchant($$6.enchantment, $$6.level);
        }
        return p_220294_;
    }

    public static List<EnchantmentInstance> selectEnchantment(FeatureFlagSet p_338533_, RandomSource p_220298_, ItemStack p_220299_, int p_220300_, boolean p_220301_) {
        ArrayList $$5 = Lists.newArrayList();
        Item $$6 = p_220299_.getItem();
        int $$7 = $$6.getEnchantmentValue();
        if ($$7 <= 0) {
            return $$5;
        }
        p_220300_ += 1 + p_220298_.nextInt($$7 / 4 + 1) + p_220298_.nextInt($$7 / 4 + 1);
        float $$8 = (p_220298_.nextFloat() + p_220298_.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> $$9 = EnchantmentHelper.getAvailableEnchantmentResults(p_338533_, p_220300_ = Mth.clamp(Math.round((float)p_220300_ + (float)p_220300_ * $$8), 1, Integer.MAX_VALUE), p_220299_, p_220301_);
        if (!$$9.isEmpty()) {
            WeightedRandom.getRandomItem(p_220298_, $$9).ifPresent($$5::add);
            while (p_220298_.nextInt(50) <= p_220300_) {
                if (!$$5.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments($$9, (EnchantmentInstance)Util.lastOf($$5));
                }
                if ($$9.isEmpty()) break;
                WeightedRandom.getRandomItem(p_220298_, $$9).ifPresent($$5::add);
                p_220300_ /= 2;
            }
        }
        return $$5;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> p_44863_, EnchantmentInstance p_44864_) {
        Iterator<EnchantmentInstance> $$2 = p_44863_.iterator();
        while ($$2.hasNext()) {
            if (p_44864_.enchantment.isCompatibleWith($$2.next().enchantment)) continue;
            $$2.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Holder<Enchantment>> p_44860_, Enchantment p_44861_) {
        for (Holder<Enchantment> $$2 : p_44860_) {
            if ($$2.value().isCompatibleWith(p_44861_)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(FeatureFlagSet p_338712_, int p_44818_, ItemStack p_44819_, boolean p_44820_) {
        ArrayList $$4 = Lists.newArrayList();
        boolean $$5 = p_44819_.is(Items.BOOK);
        block0: for (Enchantment $$6 : BuiltInRegistries.ENCHANTMENT) {
            if (!$$6.isEnabled(p_338712_) || $$6.isTreasureOnly() && !p_44820_ || !$$6.isDiscoverable() || !$$5 && (!$$6.canEnchant(p_44819_) || !$$6.isPrimaryItem(p_44819_))) continue;
            for (int $$7 = $$6.getMaxLevel(); $$7 > $$6.getMinLevel() - 1; --$$7) {
                if (p_44818_ < $$6.getMinCost($$7) || p_44818_ > $$6.getMaxCost($$7)) continue;
                $$4.add(new EnchantmentInstance($$6, $$7));
                continue block0;
            }
        }
        return $$4;
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

