/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class FrostWalkerEnchantment
extends Enchantment {
    public FrostWalkerEnchantment(Enchantment.EnchantmentDefinition p_335719_) {
        super(p_335719_);
    }

    @Override
    public boolean isTreasureOnly() {
        return true;
    }

    public static void onEntityMoved(LivingEntity p_45019_, Level p_45020_, BlockPos p_45021_, int p_45022_) {
        if (!p_45019_.onGround()) {
            return;
        }
        BlockState $$4 = Blocks.FROSTED_ICE.defaultBlockState();
        int $$5 = Math.min(16, 2 + p_45022_);
        BlockPos.MutableBlockPos $$6 = new BlockPos.MutableBlockPos();
        for (BlockPos $$7 : BlockPos.betweenClosed(p_45021_.offset(-$$5, -1, -$$5), p_45021_.offset($$5, -1, $$5))) {
            BlockState $$9;
            if (!$$7.closerToCenterThan(p_45019_.position(), $$5)) continue;
            $$6.set($$7.getX(), $$7.getY() + 1, $$7.getZ());
            BlockState $$8 = p_45020_.getBlockState($$6);
            if (!$$8.isAir() || ($$9 = p_45020_.getBlockState($$7)) != FrostedIceBlock.meltsInto() || !$$4.canSurvive(p_45020_, $$7) || !p_45020_.isUnobstructed($$4, $$7, CollisionContext.empty())) continue;
            p_45020_.setBlockAndUpdate($$7, $$4);
            p_45020_.scheduleTick($$7, Blocks.FROSTED_ICE, Mth.nextInt(p_45019_.getRandom(), 60, 120));
        }
    }

    @Override
    public boolean checkCompatibility(Enchantment p_45024_) {
        return super.checkCompatibility(p_45024_) && p_45024_ != Enchantments.DEPTH_STRIDER;
    }
}

