/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ProtectionEnchantment
extends Enchantment {
    public final Type type;

    public ProtectionEnchantment(Enchantment.EnchantmentDefinition p_335937_, Type p_45127_) {
        super(p_335937_);
        this.type = p_45127_;
    }

    @Override
    public int getDamageProtection(int p_45133_, DamageSource p_45134_) {
        if (p_45134_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return 0;
        }
        if (this.type == Type.ALL) {
            return p_45133_;
        }
        if (this.type == Type.FIRE && p_45134_.is(DamageTypeTags.IS_FIRE)) {
            return p_45133_ * 2;
        }
        if (this.type == Type.FALL && p_45134_.is(DamageTypeTags.IS_FALL)) {
            return p_45133_ * 3;
        }
        if (this.type == Type.EXPLOSION && p_45134_.is(DamageTypeTags.IS_EXPLOSION)) {
            return p_45133_ * 2;
        }
        if (this.type == Type.PROJECTILE && p_45134_.is(DamageTypeTags.IS_PROJECTILE)) {
            return p_45133_ * 2;
        }
        return 0;
    }

    @Override
    public boolean checkCompatibility(Enchantment p_45142_) {
        if (p_45142_ instanceof ProtectionEnchantment) {
            ProtectionEnchantment $$1 = (ProtectionEnchantment)p_45142_;
            if (this.type == $$1.type) {
                return false;
            }
            return this.type == Type.FALL || $$1.type == Type.FALL;
        }
        return super.checkCompatibility(p_45142_);
    }

    public static int getFireAfterDampener(LivingEntity p_45139_, int p_45140_) {
        int $$2 = EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_PROTECTION, p_45139_);
        if ($$2 > 0) {
            p_45140_ -= Mth.floor((float)p_45140_ * ((float)$$2 * 0.15f));
        }
        return p_45140_;
    }

    public static double getExplosionKnockbackAfterDampener(LivingEntity p_45136_, double p_45137_) {
        int $$2 = EnchantmentHelper.getEnchantmentLevel(Enchantments.BLAST_PROTECTION, p_45136_);
        if ($$2 > 0) {
            p_45137_ *= Mth.clamp(1.0 - (double)$$2 * 0.15, 0.0, 1.0);
        }
        return p_45137_;
    }

    public static enum Type {
        ALL,
        FIRE,
        FALL,
        EXPLOSION,
        PROJECTILE;

    }
}

