/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ThornsEnchantment
extends Enchantment {
    private static final float CHANCE_PER_LEVEL = 0.15f;

    public ThornsEnchantment(Enchantment.EnchantmentDefinition p_335617_) {
        super(p_335617_);
    }

    @Override
    public void doPostHurt(LivingEntity p_45215_, Entity p_45216_, int p_45217_) {
        RandomSource $$3 = p_45215_.getRandom();
        Map.Entry<EquipmentSlot, ItemStack> $$4 = EnchantmentHelper.getRandomItemWith(Enchantments.THORNS, p_45215_);
        if (ThornsEnchantment.shouldHit(p_45217_, $$3)) {
            if (p_45216_ != null) {
                p_45216_.hurt(p_45215_.damageSources().thorns(p_45215_), ThornsEnchantment.getDamage(p_45217_, $$3));
            }
            if ($$4 != null) {
                $$4.getValue().hurtAndBreak(2, p_45215_, $$4.getKey());
            }
        }
    }

    public static boolean shouldHit(int p_220317_, RandomSource p_220318_) {
        if (p_220317_ <= 0) {
            return false;
        }
        return p_220318_.nextFloat() < 0.15f * (float)p_220317_;
    }

    public static int getDamage(int p_220320_, RandomSource p_220321_) {
        if (p_220320_ > 10) {
            return p_220320_ - 10;
        }
        return 1 + p_220321_.nextInt(4);
    }
}

