/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChorusFlowerBlock
extends Block {
    public static final MapCodec<ChorusFlowerBlock> CODEC = RecordCodecBuilder.mapCodec(p_308811_ -> p_308811_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("plant").forGetter(p_304498_ -> p_304498_.plant), ChorusFlowerBlock.propertiesCodec()).apply((Applicative)p_308811_, ChorusFlowerBlock::new));
    public static final int DEAD_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    protected static final VoxelShape BLOCK_SUPPORT_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    private final Block plant;

    public MapCodec<ChorusFlowerBlock> codec() {
        return CODEC;
    }

    protected ChorusFlowerBlock(Block p_304388_, BlockBehaviour.Properties p_51652_) {
        super(p_51652_);
        this.plant = p_304388_;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(BlockState p_220975_, ServerLevel p_220976_, BlockPos p_220977_, RandomSource p_220978_) {
        if (!p_220975_.canSurvive(p_220976_, p_220977_)) {
            p_220976_.destroyBlock(p_220977_, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState p_51696_) {
        return p_51696_.getValue(AGE) < 5;
    }

    @Override
    public VoxelShape getBlockSupportShape(BlockState p_294099_, BlockGetter p_294531_, BlockPos p_295431_) {
        return BLOCK_SUPPORT_SHAPE;
    }

    @Override
    protected void randomTick(BlockState p_220980_, ServerLevel p_220981_, BlockPos p_220982_, RandomSource p_220983_) {
        BlockPos $$4 = p_220982_.above();
        if (!p_220981_.isEmptyBlock($$4) || $$4.getY() >= p_220981_.getMaxBuildHeight()) {
            return;
        }
        int $$5 = p_220980_.getValue(AGE);
        if ($$5 >= 5) {
            return;
        }
        boolean $$6 = false;
        boolean $$7 = false;
        BlockState $$8 = p_220981_.getBlockState(p_220982_.below());
        if ($$8.is(Blocks.END_STONE)) {
            $$6 = true;
        } else if ($$8.is(this.plant)) {
            int $$9 = 1;
            for (int $$10 = 0; $$10 < 4; ++$$10) {
                BlockState $$11 = p_220981_.getBlockState(p_220982_.below($$9 + 1));
                if ($$11.is(this.plant)) {
                    ++$$9;
                    continue;
                }
                if (!$$11.is(Blocks.END_STONE)) break;
                $$7 = true;
                break;
            }
            if ($$9 < 2 || $$9 <= p_220983_.nextInt($$7 ? 5 : 4)) {
                $$6 = true;
            }
        } else if ($$8.isAir()) {
            $$6 = true;
        }
        if ($$6 && ChorusFlowerBlock.allNeighborsEmpty(p_220981_, $$4, null) && p_220981_.isEmptyBlock(p_220982_.above(2))) {
            p_220981_.setBlock(p_220982_, ChorusPlantBlock.getStateWithConnections(p_220981_, p_220982_, this.plant.defaultBlockState()), 2);
            this.placeGrownFlower(p_220981_, $$4, $$5);
        } else if ($$5 < 4) {
            int $$12 = p_220983_.nextInt(4);
            if ($$7) {
                ++$$12;
            }
            boolean $$13 = false;
            for (int $$14 = 0; $$14 < $$12; ++$$14) {
                Direction $$15 = Direction.Plane.HORIZONTAL.getRandomDirection(p_220983_);
                BlockPos $$16 = p_220982_.relative($$15);
                if (!p_220981_.isEmptyBlock($$16) || !p_220981_.isEmptyBlock($$16.below()) || !ChorusFlowerBlock.allNeighborsEmpty(p_220981_, $$16, $$15.getOpposite())) continue;
                this.placeGrownFlower(p_220981_, $$16, $$5 + 1);
                $$13 = true;
            }
            if ($$13) {
                p_220981_.setBlock(p_220982_, ChorusPlantBlock.getStateWithConnections(p_220981_, p_220982_, this.plant.defaultBlockState()), 2);
            } else {
                this.placeDeadFlower(p_220981_, p_220982_);
            }
        } else {
            this.placeDeadFlower(p_220981_, p_220982_);
        }
    }

    private void placeGrownFlower(Level p_51662_, BlockPos p_51663_, int p_51664_) {
        p_51662_.setBlock(p_51663_, (BlockState)this.defaultBlockState().setValue(AGE, p_51664_), 2);
        p_51662_.levelEvent(1033, p_51663_, 0);
    }

    private void placeDeadFlower(Level p_51659_, BlockPos p_51660_) {
        p_51659_.setBlock(p_51660_, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2);
        p_51659_.levelEvent(1034, p_51660_, 0);
    }

    private static boolean allNeighborsEmpty(LevelReader p_51698_, BlockPos p_51699_, @Nullable Direction p_51700_) {
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            if ($$3 == p_51700_ || p_51698_.isEmptyBlock(p_51699_.relative($$3))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BlockState updateShape(BlockState p_51687_, Direction p_51688_, BlockState p_51689_, LevelAccessor p_51690_, BlockPos p_51691_, BlockPos p_51692_) {
        if (p_51688_ != Direction.UP && !p_51687_.canSurvive(p_51690_, p_51691_)) {
            p_51690_.scheduleTick(p_51691_, this, 1);
        }
        return super.updateShape(p_51687_, p_51688_, p_51689_, p_51690_, p_51691_, p_51692_);
    }

    @Override
    protected boolean canSurvive(BlockState p_51683_, LevelReader p_51684_, BlockPos p_51685_) {
        BlockState $$3 = p_51684_.getBlockState(p_51685_.below());
        if ($$3.is(this.plant) || $$3.is(Blocks.END_STONE)) {
            return true;
        }
        if (!$$3.isAir()) {
            return false;
        }
        boolean $$4 = false;
        for (Direction $$5 : Direction.Plane.HORIZONTAL) {
            BlockState $$6 = p_51684_.getBlockState(p_51685_.relative($$5));
            if ($$6.is(this.plant)) {
                if ($$4) {
                    return false;
                }
                $$4 = true;
                continue;
            }
            if ($$6.isAir()) continue;
            return false;
        }
        return $$4;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51694_) {
        p_51694_.add(AGE);
    }

    public static void generatePlant(LevelAccessor p_220963_, BlockPos p_220964_, RandomSource p_220965_, int p_220966_) {
        p_220963_.setBlock(p_220964_, ChorusPlantBlock.getStateWithConnections(p_220963_, p_220964_, Blocks.CHORUS_PLANT.defaultBlockState()), 2);
        ChorusFlowerBlock.growTreeRecursive(p_220963_, p_220964_, p_220965_, p_220964_, p_220966_, 0);
    }

    private static void growTreeRecursive(LevelAccessor p_220968_, BlockPos p_220969_, RandomSource p_220970_, BlockPos p_220971_, int p_220972_, int p_220973_) {
        Block $$6 = Blocks.CHORUS_PLANT;
        int $$7 = p_220970_.nextInt(4) + 1;
        if (p_220973_ == 0) {
            ++$$7;
        }
        for (int $$8 = 0; $$8 < $$7; ++$$8) {
            BlockPos $$9 = p_220969_.above($$8 + 1);
            if (!ChorusFlowerBlock.allNeighborsEmpty(p_220968_, $$9, null)) {
                return;
            }
            p_220968_.setBlock($$9, ChorusPlantBlock.getStateWithConnections(p_220968_, $$9, $$6.defaultBlockState()), 2);
            p_220968_.setBlock($$9.below(), ChorusPlantBlock.getStateWithConnections(p_220968_, $$9.below(), $$6.defaultBlockState()), 2);
        }
        boolean $$10 = false;
        if (p_220973_ < 4) {
            int $$11 = p_220970_.nextInt(4);
            if (p_220973_ == 0) {
                ++$$11;
            }
            for (int $$12 = 0; $$12 < $$11; ++$$12) {
                Direction $$13 = Direction.Plane.HORIZONTAL.getRandomDirection(p_220970_);
                BlockPos $$14 = p_220969_.above($$7).relative($$13);
                if (Math.abs($$14.getX() - p_220971_.getX()) >= p_220972_ || Math.abs($$14.getZ() - p_220971_.getZ()) >= p_220972_ || !p_220968_.isEmptyBlock($$14) || !p_220968_.isEmptyBlock($$14.below()) || !ChorusFlowerBlock.allNeighborsEmpty(p_220968_, $$14, $$13.getOpposite())) continue;
                $$10 = true;
                p_220968_.setBlock($$14, ChorusPlantBlock.getStateWithConnections(p_220968_, $$14, $$6.defaultBlockState()), 2);
                p_220968_.setBlock($$14.relative($$13.getOpposite()), ChorusPlantBlock.getStateWithConnections(p_220968_, $$14.relative($$13.getOpposite()), $$6.defaultBlockState()), 2);
                ChorusFlowerBlock.growTreeRecursive(p_220968_, $$14, p_220970_, p_220971_, p_220972_, p_220973_ + 1);
            }
        }
        if (!$$10) {
            p_220968_.setBlock(p_220969_.above($$7), (BlockState)Blocks.CHORUS_FLOWER.defaultBlockState().setValue(AGE, 5), 2);
        }
    }

    @Override
    protected void onProjectileHit(Level p_51654_, BlockState p_51655_, BlockHitResult p_51656_, Projectile p_51657_) {
        BlockPos $$4 = p_51656_.getBlockPos();
        if (!p_51654_.isClientSide && p_51657_.mayInteract(p_51654_, $$4) && p_51657_.mayBreak(p_51654_)) {
            p_51654_.destroyBlock($$4, true, p_51657_);
        }
    }
}

