/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;

public class DoubleBlockCombiner {
    public static <S extends BlockEntity> NeighborCombineResult<S> combineWithNeigbour(BlockEntityType<S> p_52823_, Function<BlockState, BlockType> p_52824_, Function<BlockState, Direction> p_52825_, DirectionProperty p_52826_, BlockState p_52827_, LevelAccessor p_52828_, BlockPos p_52829_, BiPredicate<LevelAccessor, BlockPos> p_52830_) {
        BlockType $$14;
        boolean $$11;
        S $$8 = p_52823_.getBlockEntity(p_52828_, p_52829_);
        if ($$8 == null) {
            return Combiner::acceptNone;
        }
        if (p_52830_.test(p_52828_, p_52829_)) {
            return Combiner::acceptNone;
        }
        BlockType $$9 = p_52824_.apply(p_52827_);
        boolean $$10 = $$9 == BlockType.SINGLE;
        boolean bl = $$11 = $$9 == BlockType.FIRST;
        if ($$10) {
            return new NeighborCombineResult.Single<S>($$8);
        }
        BlockPos $$12 = p_52829_.relative(p_52825_.apply(p_52827_));
        BlockState $$13 = p_52828_.getBlockState($$12);
        if ($$13.is(p_52827_.getBlock()) && ($$14 = p_52824_.apply($$13)) != BlockType.SINGLE && $$9 != $$14 && $$13.getValue(p_52826_) == p_52827_.getValue(p_52826_)) {
            if (p_52830_.test(p_52828_, $$12)) {
                return Combiner::acceptNone;
            }
            S $$15 = p_52823_.getBlockEntity(p_52828_, $$12);
            if ($$15 != null) {
                S $$16 = $$11 ? $$8 : $$15;
                S $$17 = $$11 ? $$15 : $$8;
                return new NeighborCombineResult.Double<S>($$16, $$17);
            }
        }
        return new NeighborCombineResult.Single<S>($$8);
    }

    public static interface NeighborCombineResult<S> {
        public <T> T apply(Combiner<? super S, T> var1);

        public static final class Single<S>
        implements NeighborCombineResult<S> {
            private final S single;

            public Single(S p_52855_) {
                this.single = p_52855_;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> p_52857_) {
                return p_52857_.acceptSingle(this.single);
            }
        }

        public static final class Double<S>
        implements NeighborCombineResult<S> {
            private final S first;
            private final S second;

            public Double(S p_52849_, S p_52850_) {
                this.first = p_52849_;
                this.second = p_52850_;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> p_52852_) {
                return p_52852_.acceptDouble(this.first, this.second);
            }
        }
    }

    public static enum BlockType {
        SINGLE,
        FIRST,
        SECOND;

    }

    public static interface Combiner<S, T> {
        public T acceptDouble(S var1, S var2);

        public T acceptSingle(S var1);

        public T acceptNone();
    }
}

