/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FenceGateBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<FenceGateBlock> CODEC = RecordCodecBuilder.mapCodec(p_308823_ -> p_308823_.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(p_304842_ -> p_304842_.type), FenceGateBlock.propertiesCodec()).apply((Applicative)p_308823_, FenceGateBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty IN_WALL = BlockStateProperties.IN_WALL;
    protected static final VoxelShape Z_SHAPE = Block.box(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape X_SHAPE = Block.box(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);
    protected static final VoxelShape Z_SHAPE_LOW = Block.box(0.0, 0.0, 6.0, 16.0, 13.0, 10.0);
    protected static final VoxelShape X_SHAPE_LOW = Block.box(6.0, 0.0, 0.0, 10.0, 13.0, 16.0);
    protected static final VoxelShape Z_COLLISION_SHAPE = Block.box(0.0, 0.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape X_COLLISION_SHAPE = Block.box(6.0, 0.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape Z_SUPPORT_SHAPE = Block.box(0.0, 5.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape X_SUPPORT_SHAPE = Block.box(6.0, 5.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape Z_OCCLUSION_SHAPE = Shapes.or(Block.box(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), Block.box(14.0, 5.0, 7.0, 16.0, 16.0, 9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE = Shapes.or(Block.box(7.0, 5.0, 0.0, 9.0, 16.0, 2.0), Block.box(7.0, 5.0, 14.0, 9.0, 16.0, 16.0));
    protected static final VoxelShape Z_OCCLUSION_SHAPE_LOW = Shapes.or(Block.box(0.0, 2.0, 7.0, 2.0, 13.0, 9.0), Block.box(14.0, 2.0, 7.0, 16.0, 13.0, 9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE_LOW = Shapes.or(Block.box(7.0, 2.0, 0.0, 9.0, 13.0, 2.0), Block.box(7.0, 2.0, 14.0, 9.0, 13.0, 16.0));
    private final WoodType type;

    public MapCodec<FenceGateBlock> codec() {
        return CODEC;
    }

    public FenceGateBlock(WoodType p_273340_, BlockBehaviour.Properties p_273352_) {
        super(p_273352_.sound(p_273340_.soundType()));
        this.type = p_273340_;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(OPEN, false)).setValue(POWERED, false)).setValue(IN_WALL, false));
    }

    @Override
    protected VoxelShape getShape(BlockState p_53391_, BlockGetter p_53392_, BlockPos p_53393_, CollisionContext p_53394_) {
        if (p_53391_.getValue(IN_WALL).booleanValue()) {
            return p_53391_.getValue(FACING).getAxis() == Direction.Axis.X ? X_SHAPE_LOW : Z_SHAPE_LOW;
        }
        return p_53391_.getValue(FACING).getAxis() == Direction.Axis.X ? X_SHAPE : Z_SHAPE;
    }

    @Override
    protected BlockState updateShape(BlockState p_53382_, Direction p_53383_, BlockState p_53384_, LevelAccessor p_53385_, BlockPos p_53386_, BlockPos p_53387_) {
        Direction.Axis $$6 = p_53383_.getAxis();
        if (p_53382_.getValue(FACING).getClockWise().getAxis() == $$6) {
            boolean $$7 = this.isWall(p_53384_) || this.isWall(p_53385_.getBlockState(p_53386_.relative(p_53383_.getOpposite())));
            return (BlockState)p_53382_.setValue(IN_WALL, $$7);
        }
        return super.updateShape(p_53382_, p_53383_, p_53384_, p_53385_, p_53386_, p_53387_);
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState p_253862_, BlockGetter p_254569_, BlockPos p_254197_) {
        if (p_253862_.getValue(OPEN).booleanValue()) {
            return Shapes.empty();
        }
        return p_253862_.getValue(FACING).getAxis() == Direction.Axis.Z ? Z_SUPPORT_SHAPE : X_SUPPORT_SHAPE;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState p_53396_, BlockGetter p_53397_, BlockPos p_53398_, CollisionContext p_53399_) {
        if (p_53396_.getValue(OPEN).booleanValue()) {
            return Shapes.empty();
        }
        return p_53396_.getValue(FACING).getAxis() == Direction.Axis.Z ? Z_COLLISION_SHAPE : X_COLLISION_SHAPE;
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState p_53401_, BlockGetter p_53402_, BlockPos p_53403_) {
        if (p_53401_.getValue(IN_WALL).booleanValue()) {
            return p_53401_.getValue(FACING).getAxis() == Direction.Axis.X ? X_OCCLUSION_SHAPE_LOW : Z_OCCLUSION_SHAPE_LOW;
        }
        return p_53401_.getValue(FACING).getAxis() == Direction.Axis.X ? X_OCCLUSION_SHAPE : Z_OCCLUSION_SHAPE;
    }

    @Override
    protected boolean isPathfindable(BlockState p_53360_, PathComputationType p_53363_) {
        switch (p_53363_) {
            case LAND: {
                return p_53360_.getValue(OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return p_53360_.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_53358_) {
        Level $$1 = p_53358_.getLevel();
        BlockPos $$2 = p_53358_.getClickedPos();
        boolean $$3 = $$1.hasNeighborSignal($$2);
        Direction $$4 = p_53358_.getHorizontalDirection();
        Direction.Axis $$5 = $$4.getAxis();
        boolean $$6 = $$5 == Direction.Axis.Z && (this.isWall($$1.getBlockState($$2.west())) || this.isWall($$1.getBlockState($$2.east()))) || $$5 == Direction.Axis.X && (this.isWall($$1.getBlockState($$2.north())) || this.isWall($$1.getBlockState($$2.south())));
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, $$4)).setValue(OPEN, $$3)).setValue(POWERED, $$3)).setValue(IN_WALL, $$6);
    }

    private boolean isWall(BlockState p_53405_) {
        return p_53405_.is(BlockTags.WALLS);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_53365_, Level p_53366_, BlockPos p_53367_, Player p_53368_, BlockHitResult p_53370_) {
        if (p_53365_.getValue(OPEN).booleanValue()) {
            p_53365_ = (BlockState)p_53365_.setValue(OPEN, false);
            p_53366_.setBlock(p_53367_, p_53365_, 10);
        } else {
            Direction $$5 = p_53368_.getDirection();
            if (p_53365_.getValue(FACING) == $$5.getOpposite()) {
                p_53365_ = (BlockState)p_53365_.setValue(FACING, $$5);
            }
            p_53365_ = (BlockState)p_53365_.setValue(OPEN, true);
            p_53366_.setBlock(p_53367_, p_53365_, 10);
        }
        boolean $$6 = p_53365_.getValue(OPEN);
        p_53366_.playSound(p_53368_, p_53367_, $$6 ? this.type.fenceGateOpen() : this.type.fenceGateClose(), SoundSource.BLOCKS, 1.0f, p_53366_.getRandom().nextFloat() * 0.1f + 0.9f);
        p_53366_.gameEvent((Entity)p_53368_, $$6 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_53367_);
        return InteractionResult.sidedSuccess(p_53366_.isClientSide);
    }

    @Override
    protected void onExplosionHit(BlockState p_312699_, Level p_311813_, BlockPos p_312680_, Explosion p_312186_, BiConsumer<ItemStack, BlockPos> p_312187_) {
        if (p_312186_.getBlockInteraction() == Explosion.BlockInteraction.TRIGGER_BLOCK && !p_311813_.isClientSide() && !p_312699_.getValue(POWERED).booleanValue()) {
            boolean $$5 = p_312699_.getValue(OPEN);
            p_311813_.setBlockAndUpdate(p_312680_, (BlockState)p_312699_.setValue(OPEN, !$$5));
            p_311813_.playSound(null, p_312680_, $$5 ? this.type.fenceGateClose() : this.type.fenceGateOpen(), SoundSource.BLOCKS, 1.0f, p_311813_.getRandom().nextFloat() * 0.1f + 0.9f);
            p_311813_.gameEvent($$5 ? GameEvent.BLOCK_CLOSE : GameEvent.BLOCK_OPEN, p_312680_, GameEvent.Context.of(p_312699_));
        }
        super.onExplosionHit(p_312699_, p_311813_, p_312680_, p_312186_, p_312187_);
    }

    @Override
    protected void neighborChanged(BlockState p_53372_, Level p_53373_, BlockPos p_53374_, Block p_53375_, BlockPos p_53376_, boolean p_53377_) {
        if (p_53373_.isClientSide) {
            return;
        }
        boolean $$6 = p_53373_.hasNeighborSignal(p_53374_);
        if (p_53372_.getValue(POWERED) != $$6) {
            p_53373_.setBlock(p_53374_, (BlockState)((BlockState)p_53372_.setValue(POWERED, $$6)).setValue(OPEN, $$6), 2);
            if (p_53372_.getValue(OPEN) != $$6) {
                p_53373_.playSound(null, p_53374_, $$6 ? this.type.fenceGateOpen() : this.type.fenceGateClose(), SoundSource.BLOCKS, 1.0f, p_53373_.getRandom().nextFloat() * 0.1f + 0.9f);
                p_53373_.gameEvent(null, $$6 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_53374_);
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53389_) {
        p_53389_.add(FACING, OPEN, POWERED, IN_WALL);
    }

    public static boolean connectsToDirection(BlockState p_53379_, Direction p_53380_) {
        return p_53379_.getValue(FACING).getAxis() == p_53380_.getClockWise().getAxis();
    }
}

