/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    public static final int FUEL_USES = 20;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int NUM_DATA_VALUES = 2;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    int brewTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int p_59038_) {
            return switch (p_59038_) {
                case 0 -> BrewingStandBlockEntity.this.brewTime;
                case 1 -> BrewingStandBlockEntity.this.fuel;
                default -> 0;
            };
        }

        @Override
        public void set(int p_59040_, int p_59041_) {
            switch (p_59040_) {
                case 0: {
                    BrewingStandBlockEntity.this.brewTime = p_59041_;
                    break;
                }
                case 1: {
                    BrewingStandBlockEntity.this.fuel = p_59041_;
                }
            }
        }

        @Override
        public int getCount() {
            return 2;
        }
    };

    public BrewingStandBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        super(BlockEntityType.BREWING_STAND, p_155283_, p_155284_);
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.brewing");
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> p_332710_) {
        this.items = p_332710_;
    }

    public static void serverTick(Level p_155286_, BlockPos p_155287_, BlockState p_155288_, BrewingStandBlockEntity p_155289_) {
        ItemStack $$4 = p_155289_.items.get(4);
        if (p_155289_.fuel <= 0 && $$4.is(Items.BLAZE_POWDER)) {
            p_155289_.fuel = 20;
            $$4.shrink(1);
            BrewingStandBlockEntity.setChanged(p_155286_, p_155287_, p_155288_);
        }
        boolean $$5 = BrewingStandBlockEntity.isBrewable(p_155286_.potionBrewing(), p_155289_.items);
        boolean $$6 = p_155289_.brewTime > 0;
        ItemStack $$7 = p_155289_.items.get(3);
        if ($$6) {
            boolean $$8;
            --p_155289_.brewTime;
            boolean bl = $$8 = p_155289_.brewTime == 0;
            if ($$8 && $$5) {
                BrewingStandBlockEntity.doBrew(p_155286_, p_155287_, p_155289_.items);
                BrewingStandBlockEntity.setChanged(p_155286_, p_155287_, p_155288_);
            } else if (!$$5 || !$$7.is(p_155289_.ingredient)) {
                p_155289_.brewTime = 0;
                BrewingStandBlockEntity.setChanged(p_155286_, p_155287_, p_155288_);
            }
        } else if ($$5 && p_155289_.fuel > 0) {
            --p_155289_.fuel;
            p_155289_.brewTime = 400;
            p_155289_.ingredient = $$7.getItem();
            BrewingStandBlockEntity.setChanged(p_155286_, p_155287_, p_155288_);
        }
        boolean[] $$9 = p_155289_.getPotionBits();
        if (!Arrays.equals($$9, p_155289_.lastPotionCount)) {
            p_155289_.lastPotionCount = $$9;
            BlockState $$10 = p_155288_;
            if (!($$10.getBlock() instanceof BrewingStandBlock)) {
                return;
            }
            for (int $$11 = 0; $$11 < BrewingStandBlock.HAS_BOTTLE.length; ++$$11) {
                $$10 = (BlockState)$$10.setValue(BrewingStandBlock.HAS_BOTTLE[$$11], $$9[$$11]);
            }
            p_155286_.setBlock(p_155287_, $$10, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] $$0 = new boolean[3];
        for (int $$1 = 0; $$1 < 3; ++$$1) {
            if (this.items.get($$1).isEmpty()) continue;
            $$0[$$1] = true;
        }
        return $$0;
    }

    private static boolean isBrewable(PotionBrewing p_341061_, NonNullList<ItemStack> p_155295_) {
        ItemStack $$2 = p_155295_.get(3);
        if ($$2.isEmpty()) {
            return false;
        }
        if (!p_341061_.isIngredient($$2)) {
            return false;
        }
        for (int $$3 = 0; $$3 < 3; ++$$3) {
            ItemStack $$4 = p_155295_.get($$3);
            if ($$4.isEmpty() || !p_341061_.hasMix($$4, $$2)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level p_155291_, BlockPos p_155292_, NonNullList<ItemStack> p_155293_) {
        ItemStack $$3 = p_155293_.get(3);
        PotionBrewing $$4 = p_155291_.potionBrewing();
        for (int $$5 = 0; $$5 < 3; ++$$5) {
            p_155293_.set($$5, $$4.mix($$3, p_155293_.get($$5)));
        }
        $$3.shrink(1);
        if ($$3.getItem().hasCraftingRemainingItem()) {
            ItemStack $$6 = new ItemStack($$3.getItem().getCraftingRemainingItem());
            if ($$3.isEmpty()) {
                $$3 = $$6;
            } else {
                Containers.dropItemStack(p_155291_, p_155292_.getX(), p_155292_.getY(), p_155292_.getZ(), $$6);
            }
        }
        p_155293_.set(3, $$3);
        p_155291_.levelEvent(1035, p_155292_, 0);
    }

    @Override
    protected void loadAdditional(CompoundTag p_338530_, HolderLookup.Provider p_338200_) {
        super.loadAdditional(p_338530_, p_338200_);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerHelper.loadAllItems(p_338530_, this.items, p_338200_);
        this.brewTime = p_338530_.getShort("BrewTime");
        this.fuel = p_338530_.getByte("Fuel");
    }

    @Override
    protected void saveAdditional(CompoundTag p_187484_, HolderLookup.Provider p_324461_) {
        super.saveAdditional(p_187484_, p_324461_);
        p_187484_.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems(p_187484_, this.items, p_324461_);
        p_187484_.putByte("Fuel", (byte)this.fuel);
    }

    @Override
    public boolean canPlaceItem(int p_59017_, ItemStack p_59018_) {
        if (p_59017_ == 3) {
            PotionBrewing $$2 = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
            return $$2.isIngredient(p_59018_);
        }
        if (p_59017_ == 4) {
            return p_59018_.is(Items.BLAZE_POWDER);
        }
        return (p_59018_.is(Items.POTION) || p_59018_.is(Items.SPLASH_POTION) || p_59018_.is(Items.LINGERING_POTION) || p_59018_.is(Items.GLASS_BOTTLE)) && this.getItem(p_59017_).isEmpty();
    }

    @Override
    public int[] getSlotsForFace(Direction p_59010_) {
        if (p_59010_ == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        if (p_59010_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int p_58996_, ItemStack p_58997_, @Nullable Direction p_58998_) {
        return this.canPlaceItem(p_58996_, p_58997_);
    }

    @Override
    public boolean canTakeItemThroughFace(int p_59020_, ItemStack p_59021_, Direction p_59022_) {
        if (p_59020_ == 3) {
            return p_59021_.is(Items.GLASS_BOTTLE);
        }
        return true;
    }

    @Override
    protected AbstractContainerMenu createMenu(int p_58990_, Inventory p_58991_) {
        return new BrewingStandMenu(p_58990_, p_58991_, this, this.dataAccess);
    }
}

