/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import org.slf4j.Logger;

public class ChunkSerializer {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static ProtoChunk read(ServerLevel p_188231_, PoiManager p_188232_, ChunkPos p_188233_, CompoundTag p_188234_) {
        ProtoChunk $$38;
        BlendingData $$31;
        ChunkPos $$4 = new ChunkPos(p_188234_.getInt(X_POS_TAG), p_188234_.getInt(Z_POS_TAG));
        if (!Objects.equals(p_188233_, $$4)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{p_188233_, p_188233_, $$4});
        }
        UpgradeData $$5 = p_188234_.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(p_188234_.getCompound(TAG_UPGRADE_DATA), p_188231_) : UpgradeData.EMPTY;
        boolean $$6 = p_188234_.getBoolean(IS_LIGHT_ON_TAG);
        ListTag $$7 = p_188234_.getList(SECTIONS_TAG, 10);
        int $$8 = p_188231_.getSectionsCount();
        LevelChunkSection[] $$9 = new LevelChunkSection[$$8];
        boolean $$10 = p_188231_.dimensionType().hasSkyLight();
        ServerChunkCache $$11 = p_188231_.getChunkSource();
        LevelLightEngine $$12 = ((ChunkSource)$$11).getLightEngine();
        Registry<Biome> $$13 = p_188231_.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$14 = ChunkSerializer.makeBiomeCodec($$13);
        boolean $$15 = false;
        for (int $$16 = 0; $$16 < $$7.size(); ++$$16) {
            boolean $$27;
            CompoundTag $$17 = $$7.getCompound($$16);
            byte $$18 = $$17.getByte("Y");
            int $$19 = p_188231_.getSectionIndexFromSectionY($$18);
            if ($$19 >= 0 && $$19 < $$9.length) {
                LevelChunkSection $$24;
                PalettedContainer<Holder<Biome>> $$23;
                PalettedContainer<BlockState> $$21;
                if ($$17.contains("block_states", 10)) {
                    PalettedContainer $$20 = (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$17.getCompound("block_states")).promotePartial(p_188283_ -> ChunkSerializer.logErrors(p_188233_, $$18, p_188283_)).getOrThrow(ChunkReadException::new);
                } else {
                    $$21 = new PalettedContainer<BlockState>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                }
                if ($$17.contains("biomes", 10)) {
                    PalettedContainerRO $$22 = (PalettedContainerRO)$$14.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$17.getCompound("biomes")).promotePartial(p_188274_ -> ChunkSerializer.logErrors(p_188233_, $$18, p_188274_)).getOrThrow(ChunkReadException::new);
                } else {
                    $$23 = new PalettedContainer<Holder<Biome>>($$13.asHolderIdMap(), $$13.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                }
                $$9[$$19] = $$24 = new LevelChunkSection($$21, $$23);
                SectionPos $$25 = SectionPos.of(p_188233_, $$18);
                p_188232_.checkConsistencyWithBlocks($$25, $$24);
            }
            boolean $$26 = $$17.contains(BLOCK_LIGHT_TAG, 7);
            boolean bl = $$27 = $$10 && $$17.contains(SKY_LIGHT_TAG, 7);
            if (!$$26 && !$$27) continue;
            if (!$$15) {
                $$12.retainData(p_188233_, true);
                $$15 = true;
            }
            if ($$26) {
                $$12.queueSectionData(LightLayer.BLOCK, SectionPos.of(p_188233_, $$18), new DataLayer($$17.getByteArray(BLOCK_LIGHT_TAG)));
            }
            if (!$$27) continue;
            $$12.queueSectionData(LightLayer.SKY, SectionPos.of(p_188233_, $$18), new DataLayer($$17.getByteArray(SKY_LIGHT_TAG)));
        }
        long $$28 = p_188234_.getLong("InhabitedTime");
        ChunkType $$29 = ChunkSerializer.getChunkTypeFromTag(p_188234_);
        if (p_188234_.contains("blending_data", 10)) {
            BlendingData $$30 = BlendingData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_188234_.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
        } else {
            $$31 = null;
        }
        if ($$29 == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> $$32 = LevelChunkTicks.load(p_188234_.getList(BLOCK_TICKS_TAG, 10), p_258988_ -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(p_258988_)), p_188233_);
            LevelChunkTicks<Fluid> $$33 = LevelChunkTicks.load(p_188234_.getList(FLUID_TICKS_TAG, 10), p_258990_ -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(p_258990_)), p_188233_);
            LevelChunk $$34 = new LevelChunk(p_188231_.getLevel(), p_188233_, $$5, $$32, $$33, $$28, $$9, ChunkSerializer.postLoadChunk(p_188231_, p_188234_), $$31);
        } else {
            ProtoChunkTicks<Block> $$35 = ProtoChunkTicks.load(p_188234_.getList(BLOCK_TICKS_TAG, 10), p_258992_ -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(p_258992_)), p_188233_);
            ProtoChunkTicks<Fluid> $$36 = ProtoChunkTicks.load(p_188234_.getList(FLUID_TICKS_TAG, 10), p_258991_ -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(p_258991_)), p_188233_);
            ProtoChunk $$37 = new ProtoChunk(p_188233_, $$5, $$9, $$35, $$36, p_188231_, $$13, $$31);
            $$38 = $$37;
            $$38.setInhabitedTime($$28);
            if (p_188234_.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_188234_.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$37::setBelowZeroRetrogen);
            }
            ChunkStatus $$39 = ChunkStatus.byName(p_188234_.getString("Status"));
            $$37.setStatus($$39);
            if ($$39.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                $$37.setLightEngine($$12);
            }
        }
        $$38.setLightCorrect($$6);
        CompoundTag $$40 = p_188234_.getCompound(HEIGHTMAPS_TAG);
        EnumSet<Heightmap.Types> $$41 = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types $$42 : ((ChunkAccess)$$38).getStatus().heightmapsAfter()) {
            String $$43 = $$42.getSerializationKey();
            if ($$40.contains($$43, 12)) {
                $$38.setHeightmap($$42, $$40.getLongArray($$43));
                continue;
            }
            $$41.add($$42);
        }
        Heightmap.primeHeightmaps($$38, $$41);
        CompoundTag $$44 = p_188234_.getCompound("structures");
        $$38.setAllStarts(ChunkSerializer.unpackStructureStart(StructurePieceSerializationContext.fromLevel(p_188231_), $$44, p_188231_.getSeed()));
        $$38.setAllReferences(ChunkSerializer.unpackStructureReferences(p_188231_.registryAccess(), p_188233_, $$44));
        if (p_188234_.getBoolean("shouldSave")) {
            $$38.setUnsaved(true);
        }
        ListTag $$45 = p_188234_.getList("PostProcessing", 9);
        for (int $$46 = 0; $$46 < $$45.size(); ++$$46) {
            ListTag $$47 = $$45.getList($$46);
            for (int $$48 = 0; $$48 < $$47.size(); ++$$48) {
                ((ChunkAccess)$$38).addPackedPostProcess($$47.getShort($$48), $$46);
            }
        }
        if ($$29 == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)((Object)$$38), false);
        }
        ProtoChunk $$49 = $$38;
        ListTag $$50 = p_188234_.getList("entities", 10);
        for (int $$51 = 0; $$51 < $$50.size(); ++$$51) {
            $$49.addEntity($$50.getCompound($$51));
        }
        ListTag $$52 = p_188234_.getList("block_entities", 10);
        for (int $$53 = 0; $$53 < $$52.size(); ++$$53) {
            CompoundTag $$54 = $$52.getCompound($$53);
            $$38.setBlockEntityNbt($$54);
        }
        CompoundTag $$55 = p_188234_.getCompound("CarvingMasks");
        for (String $$56 : $$55.getAllKeys()) {
            GenerationStep.Carving $$57 = GenerationStep.Carving.valueOf($$56);
            $$49.setCarvingMask($$57, new CarvingMask($$55.getLongArray($$56), $$38.getMinBuildHeight()));
        }
        return $$49;
    }

    private static void logErrors(ChunkPos p_188240_, int p_188241_, String p_188242_) {
        LOGGER.error("Recoverable errors when loading section [" + p_188240_.x + ", " + p_188241_ + ", " + p_188240_.z + "]: " + p_188242_);
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> p_188261_) {
        return PalettedContainer.codecRO(p_188261_.asHolderIdMap(), p_188261_.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, p_188261_.getHolderOrThrow(Biomes.PLAINS));
    }

    public static CompoundTag write(ServerLevel p_63455_, ChunkAccess p_63456_) {
        UpgradeData $$6;
        BelowZeroRetrogen $$5;
        ChunkPos $$2 = p_63456_.getPos();
        CompoundTag $$3 = NbtUtils.addCurrentDataVersion(new CompoundTag());
        $$3.putInt(X_POS_TAG, $$2.x);
        $$3.putInt("yPos", p_63456_.getMinSection());
        $$3.putInt(Z_POS_TAG, $$2.z);
        $$3.putLong("LastUpdate", p_63455_.getGameTime());
        $$3.putLong("InhabitedTime", p_63456_.getInhabitedTime());
        $$3.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(p_63456_.getStatus()).toString());
        BlendingData $$4 = p_63456_.getBlendingData();
        if ($$4 != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$4).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_196909_ -> $$3.put("blending_data", (Tag)p_196909_));
        }
        if (($$5 = p_63456_.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$5).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_188279_ -> $$3.put("below_zero_retrogen", (Tag)p_188279_));
        }
        if (!($$6 = p_63456_.getUpgradeData()).isEmpty()) {
            $$3.put(TAG_UPGRADE_DATA, $$6.write());
        }
        LevelChunkSection[] $$7 = p_63456_.getSections();
        ListTag $$8 = new ListTag();
        ThreadedLevelLightEngine $$9 = p_63455_.getChunkSource().getLightEngine();
        Registry<Biome> $$10 = p_63455_.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$11 = ChunkSerializer.makeBiomeCodec($$10);
        boolean $$12 = p_63456_.isLightCorrect();
        for (int $$13 = $$9.getMinLightSection(); $$13 < $$9.getMaxLightSection(); ++$$13) {
            int $$14 = p_63456_.getSectionIndexFromSectionY($$13);
            boolean $$15 = $$14 >= 0 && $$14 < $$7.length;
            DataLayer $$16 = $$9.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of($$2, $$13));
            DataLayer $$17 = $$9.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of($$2, $$13));
            if (!$$15 && $$16 == null && $$17 == null) continue;
            CompoundTag $$18 = new CompoundTag();
            if ($$15) {
                LevelChunkSection $$19 = $$7[$$14];
                $$18.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, $$19.getStates()).getOrThrow());
                $$18.put("biomes", (Tag)$$11.encodeStart((DynamicOps)NbtOps.INSTANCE, $$19.getBiomes()).getOrThrow());
            }
            if ($$16 != null && !$$16.isEmpty()) {
                $$18.putByteArray(BLOCK_LIGHT_TAG, $$16.getData());
            }
            if ($$17 != null && !$$17.isEmpty()) {
                $$18.putByteArray(SKY_LIGHT_TAG, $$17.getData());
            }
            if ($$18.isEmpty()) continue;
            $$18.putByte("Y", (byte)$$13);
            $$8.add($$18);
        }
        $$3.put(SECTIONS_TAG, $$8);
        if ($$12) {
            $$3.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag $$20 = new ListTag();
        for (BlockPos $$21 : p_63456_.getBlockEntitiesPos()) {
            CompoundTag $$22 = p_63456_.getBlockEntityNbtForSaving($$21, p_63455_.registryAccess());
            if ($$22 == null) continue;
            $$20.add($$22);
        }
        $$3.put("block_entities", $$20);
        if (p_63456_.getStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk $$23 = (ProtoChunk)p_63456_;
            ListTag $$24 = new ListTag();
            $$24.addAll($$23.getEntities());
            $$3.put("entities", $$24);
            CompoundTag $$25 = new CompoundTag();
            for (GenerationStep.Carving $$26 : GenerationStep.Carving.values()) {
                CarvingMask $$27 = $$23.getCarvingMask($$26);
                if ($$27 == null) continue;
                $$25.putLongArray($$26.toString(), $$27.toArray());
            }
            $$3.put("CarvingMasks", $$25);
        }
        ChunkSerializer.saveTicks(p_63455_, $$3, p_63456_.getTicksForSerialization());
        $$3.put("PostProcessing", ChunkSerializer.packOffsets(p_63456_.getPostProcessing()));
        CompoundTag $$28 = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> $$29 : p_63456_.getHeightmaps()) {
            if (!p_63456_.getStatus().heightmapsAfter().contains($$29.getKey())) continue;
            $$28.put($$29.getKey().getSerializationKey(), new LongArrayTag($$29.getValue().getRawData()));
        }
        $$3.put(HEIGHTMAPS_TAG, $$28);
        $$3.put("structures", ChunkSerializer.packStructureData(StructurePieceSerializationContext.fromLevel(p_63455_), $$2, p_63456_.getAllStarts(), p_63456_.getAllReferences()));
        return $$3;
    }

    private static void saveTicks(ServerLevel p_188236_, CompoundTag p_188237_, ChunkAccess.TicksToSave p_188238_) {
        long $$3 = p_188236_.getLevelData().getGameTime();
        p_188237_.put(BLOCK_TICKS_TAG, p_188238_.blocks().save($$3, p_258987_ -> BuiltInRegistries.BLOCK.getKey((Block)p_258987_).toString()));
        p_188237_.put(FLUID_TICKS_TAG, p_188238_.fluids().save($$3, p_258989_ -> BuiltInRegistries.FLUID.getKey((Fluid)p_258989_).toString()));
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag p_63486_) {
        if (p_63486_ != null) {
            return ChunkStatus.byName(p_63486_.getString("Status")).getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel p_196891_, CompoundTag p_196892_) {
        ListTag $$2 = ChunkSerializer.getListOfCompoundsOrNull(p_196892_, "entities");
        ListTag $$3 = ChunkSerializer.getListOfCompoundsOrNull(p_196892_, "block_entities");
        if ($$2 == null && $$3 == null) {
            return null;
        }
        return p_196904_ -> {
            if ($$2 != null) {
                p_196891_.addLegacyChunkEntities(EntityType.loadEntitiesRecursive($$2, p_196891_));
            }
            if ($$3 != null) {
                for (int $$4 = 0; $$4 < $$3.size(); ++$$4) {
                    CompoundTag $$5 = $$3.getCompound($$4);
                    boolean $$6 = $$5.getBoolean("keepPacked");
                    if ($$6) {
                        p_196904_.setBlockEntityNbt($$5);
                        continue;
                    }
                    BlockPos $$7 = BlockEntity.getPosFromTag($$5);
                    BlockEntity $$8 = BlockEntity.loadStatic($$7, p_196904_.getBlockState($$7), $$5, p_196891_.registryAccess());
                    if ($$8 == null) continue;
                    p_196904_.setBlockEntity($$8);
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag p_196898_, String p_196899_) {
        ListTag $$2 = p_196898_.getList(p_196899_, 10);
        return $$2.isEmpty() ? null : $$2;
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext p_188250_, ChunkPos p_188251_, Map<Structure, StructureStart> p_188252_, Map<Structure, LongSet> p_188253_) {
        CompoundTag $$4 = new CompoundTag();
        CompoundTag $$5 = new CompoundTag();
        Registry<Structure> $$6 = p_188250_.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> $$7 : p_188252_.entrySet()) {
            ResourceLocation $$8 = $$6.getKey($$7.getKey());
            $$5.put($$8.toString(), $$7.getValue().createTag(p_188250_, p_188251_));
        }
        $$4.put("starts", $$5);
        CompoundTag $$9 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> $$10 : p_188253_.entrySet()) {
            if ($$10.getValue().isEmpty()) continue;
            ResourceLocation $$11 = $$6.getKey($$10.getKey());
            $$9.put($$11.toString(), new LongArrayTag($$10.getValue()));
        }
        $$4.put("References", $$9);
        return $$4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext p_188255_, CompoundTag p_188256_, long p_188257_) {
        HashMap $$3 = Maps.newHashMap();
        Registry<Structure> $$4 = p_188255_.registryAccess().registryOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = p_188256_.getCompound("starts");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = $$4.get($$7);
            if ($$8 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)$$7);
                continue;
            }
            StructureStart $$9 = StructureStart.loadStaticStart(p_188255_, $$5.getCompound($$6), p_188257_);
            if ($$9 == null) continue;
            $$3.put($$8, $$9);
        }
        return $$3;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess p_208155_, ChunkPos p_208156_, CompoundTag p_208157_) {
        HashMap $$3 = Maps.newHashMap();
        Registry<Structure> $$4 = p_208155_.registryOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = p_208157_.getCompound("References");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = $$4.get($$7);
            if ($$8 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)$$7, (Object)p_208156_);
                continue;
            }
            long[] $$9 = $$5.getLongArray($$6);
            if ($$9.length == 0) continue;
            $$3.put($$8, new LongOpenHashSet(Arrays.stream($$9).filter(p_208153_ -> {
                ChunkPos $$3 = new ChunkPos(p_208153_);
                if ($$3.getChessboardDistance(p_208156_) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{$$7, $$3, p_208156_});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return $$3;
    }

    public static ListTag packOffsets(ShortList[] p_63491_) {
        ListTag $$1 = new ListTag();
        for (ShortList $$2 : p_63491_) {
            ListTag $$3 = new ListTag();
            if ($$2 != null) {
                for (Short $$4 : $$2) {
                    $$3.add(ShortTag.valueOf($$4));
                }
            }
            $$1.add($$3);
        }
        return $$1;
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String p_331759_) {
            super(p_331759_);
        }
    }
}

