/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class Structure {
    public static final Codec<Structure> DIRECT_CODEC = BuiltInRegistries.STRUCTURE_TYPE.byNameCodec().dispatch(Structure::type, StructureType::codec);
    public static final Codec<Holder<Structure>> CODEC = RegistryFileCodec.create(Registries.STRUCTURE, DIRECT_CODEC);
    protected final StructureSettings settings;

    public static <S extends Structure> RecordCodecBuilder<S, StructureSettings> settingsCodec(RecordCodecBuilder.Instance<S> p_226568_) {
        return StructureSettings.CODEC.forGetter(p_226595_ -> p_226595_.settings);
    }

    public static <S extends Structure> MapCodec<S> simpleCodec(Function<StructureSettings, S> p_226608_) {
        return RecordCodecBuilder.mapCodec(p_226611_ -> p_226611_.group(Structure.settingsCodec(p_226611_)).apply((Applicative)p_226611_, p_226608_));
    }

    protected Structure(StructureSettings p_226558_) {
        this.settings = p_226558_;
    }

    public HolderSet<Biome> biomes() {
        return this.settings.biomes;
    }

    public Map<MobCategory, StructureSpawnOverride> spawnOverrides() {
        return this.settings.spawnOverrides;
    }

    public GenerationStep.Decoration step() {
        return this.settings.step;
    }

    public TerrainAdjustment terrainAdaptation() {
        return this.settings.terrainAdaptation;
    }

    public BoundingBox adjustBoundingBox(BoundingBox p_226570_) {
        if (this.terrainAdaptation() != TerrainAdjustment.NONE) {
            return p_226570_.inflatedBy(12);
        }
        return p_226570_;
    }

    public StructureStart generate(RegistryAccess p_226597_, ChunkGenerator p_226598_, BiomeSource p_226599_, RandomState p_226600_, StructureTemplateManager p_226601_, long p_226602_, ChunkPos p_226603_, int p_226604_, LevelHeightAccessor p_226605_, Predicate<Holder<Biome>> p_226606_) {
        StructurePiecesBuilder $$12;
        StructureStart $$13;
        GenerationContext $$10 = new GenerationContext(p_226597_, p_226598_, p_226599_, p_226600_, p_226601_, p_226602_, p_226603_, p_226605_, p_226606_);
        Optional<GenerationStub> $$11 = this.findValidGenerationPoint($$10);
        if ($$11.isPresent() && ($$13 = new StructureStart(this, p_226603_, p_226604_, ($$12 = $$11.get().getPiecesBuilder()).build())).isValid()) {
            return $$13;
        }
        return StructureStart.INVALID_START;
    }

    protected static Optional<GenerationStub> onTopOfChunkCenter(GenerationContext p_226586_, Heightmap.Types p_226587_, Consumer<StructurePiecesBuilder> p_226588_) {
        ChunkPos $$3 = p_226586_.chunkPos();
        int $$4 = $$3.getMiddleBlockX();
        int $$5 = $$3.getMiddleBlockZ();
        int $$6 = p_226586_.chunkGenerator().getFirstOccupiedHeight($$4, $$5, p_226587_, p_226586_.heightAccessor(), p_226586_.randomState());
        return Optional.of(new GenerationStub(new BlockPos($$4, $$6, $$5), p_226588_));
    }

    private static boolean isValidBiome(GenerationStub p_263042_, GenerationContext p_263005_) {
        BlockPos $$2 = p_263042_.position();
        return p_263005_.validBiome.test(p_263005_.chunkGenerator.getBiomeSource().getNoiseBiome(QuartPos.fromBlock($$2.getX()), QuartPos.fromBlock($$2.getY()), QuartPos.fromBlock($$2.getZ()), p_263005_.randomState.sampler()));
    }

    public void afterPlace(WorldGenLevel p_226560_, StructureManager p_226561_, ChunkGenerator p_226562_, RandomSource p_226563_, BoundingBox p_226564_, ChunkPos p_226565_, PiecesContainer p_226566_) {
    }

    private static int[] getCornerHeights(GenerationContext p_226614_, int p_226615_, int p_226616_, int p_226617_, int p_226618_) {
        ChunkGenerator $$5 = p_226614_.chunkGenerator();
        LevelHeightAccessor $$6 = p_226614_.heightAccessor();
        RandomState $$7 = p_226614_.randomState();
        return new int[]{$$5.getFirstOccupiedHeight(p_226615_, p_226617_, Heightmap.Types.WORLD_SURFACE_WG, $$6, $$7), $$5.getFirstOccupiedHeight(p_226615_, p_226617_ + p_226618_, Heightmap.Types.WORLD_SURFACE_WG, $$6, $$7), $$5.getFirstOccupiedHeight(p_226615_ + p_226616_, p_226617_, Heightmap.Types.WORLD_SURFACE_WG, $$6, $$7), $$5.getFirstOccupiedHeight(p_226615_ + p_226616_, p_226617_ + p_226618_, Heightmap.Types.WORLD_SURFACE_WG, $$6, $$7)};
    }

    public static int getMeanFirstOccupiedHeight(GenerationContext p_341942_, int p_341930_, int p_341935_, int p_341884_, int p_341943_) {
        int[] $$5 = Structure.getCornerHeights(p_341942_, p_341930_, p_341935_, p_341884_, p_341943_);
        return ($$5[0] + $$5[1] + $$5[2] + $$5[3]) / 4;
    }

    protected static int getLowestY(GenerationContext p_226573_, int p_226574_, int p_226575_) {
        ChunkPos $$3 = p_226573_.chunkPos();
        int $$4 = $$3.getMinBlockX();
        int $$5 = $$3.getMinBlockZ();
        return Structure.getLowestY(p_226573_, $$4, $$5, p_226574_, p_226575_);
    }

    protected static int getLowestY(GenerationContext p_226577_, int p_226578_, int p_226579_, int p_226580_, int p_226581_) {
        int[] $$5 = Structure.getCornerHeights(p_226577_, p_226578_, p_226580_, p_226579_, p_226581_);
        return Math.min(Math.min($$5[0], $$5[1]), Math.min($$5[2], $$5[3]));
    }

    @Deprecated
    protected BlockPos getLowestYIn5by5BoxOffset7Blocks(GenerationContext p_226583_, Rotation p_226584_) {
        int $$2 = 5;
        int $$3 = 5;
        if (p_226584_ == Rotation.CLOCKWISE_90) {
            $$2 = -5;
        } else if (p_226584_ == Rotation.CLOCKWISE_180) {
            $$2 = -5;
            $$3 = -5;
        } else if (p_226584_ == Rotation.COUNTERCLOCKWISE_90) {
            $$3 = -5;
        }
        ChunkPos $$4 = p_226583_.chunkPos();
        int $$5 = $$4.getBlockX(7);
        int $$6 = $$4.getBlockZ(7);
        return new BlockPos($$5, Structure.getLowestY(p_226583_, $$5, $$6, $$2, $$3), $$6);
    }

    protected abstract Optional<GenerationStub> findGenerationPoint(GenerationContext var1);

    public Optional<GenerationStub> findValidGenerationPoint(GenerationContext p_263060_) {
        return this.findGenerationPoint(p_263060_).filter(p_262911_ -> Structure.isValidBiome(p_262911_, p_263060_));
    }

    public abstract StructureType<?> type();

    public record StructureSettings(HolderSet<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawnOverrides, GenerationStep.Decoration step, TerrainAdjustment terrainAdaptation) {
        public static final MapCodec<StructureSettings> CODEC = RecordCodecBuilder.mapCodec(p_259014_ -> p_259014_.group((App)RegistryCodecs.homogeneousList(Registries.BIOME).fieldOf("biomes").forGetter(StructureSettings::biomes), (App)Codec.simpleMap(MobCategory.CODEC, StructureSpawnOverride.CODEC, (Keyable)StringRepresentable.keys(MobCategory.values())).fieldOf("spawn_overrides").forGetter(StructureSettings::spawnOverrides), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(StructureSettings::step), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.NONE).forGetter(StructureSettings::terrainAdaptation)).apply((Applicative)p_259014_, StructureSettings::new));
    }

    public record GenerationContext(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, WorldgenRandom random, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome) {
        public GenerationContext(RegistryAccess p_226632_, ChunkGenerator p_226633_, BiomeSource p_226634_, RandomState p_226635_, StructureTemplateManager p_226636_, long p_226637_, ChunkPos p_226638_, LevelHeightAccessor p_226639_, Predicate<Holder<Biome>> p_226640_) {
            this(p_226632_, p_226633_, p_226634_, p_226635_, p_226636_, GenerationContext.makeRandom(p_226637_, p_226638_), p_226637_, p_226638_, p_226639_, p_226640_);
        }

        private static WorldgenRandom makeRandom(long p_226654_, ChunkPos p_226655_) {
            WorldgenRandom $$2 = new WorldgenRandom(new LegacyRandomSource(0L));
            $$2.setLargeFeatureSeed(p_226654_, p_226655_.x, p_226655_.z);
            return $$2;
        }
    }

    public record GenerationStub(BlockPos position, Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> generator) {
        public GenerationStub(BlockPos p_226675_, Consumer<StructurePiecesBuilder> p_226676_) {
            this(p_226675_, (Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder>)Either.left(p_226676_));
        }

        public StructurePiecesBuilder getPiecesBuilder() {
            return (StructurePiecesBuilder)this.generator.map(p_226681_ -> {
                StructurePiecesBuilder $$1 = new StructurePiecesBuilder();
                p_226681_.accept($$1);
                return $$1;
            }, p_226679_ -> p_226679_);
        }
    }
}

