/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext p_227239_, Holder<StructureTemplatePool> p_227240_, Optional<ResourceLocation> p_227241_, int p_227242_, BlockPos p_227243_, boolean p_227244_, Optional<Heightmap.Types> p_227245_, int p_227246_, PoolAliasLookup p_307522_) {
        int $$29;
        BlockPos $$21;
        RegistryAccess $$9 = p_227239_.registryAccess();
        ChunkGenerator $$10 = p_227239_.chunkGenerator();
        StructureTemplateManager $$11 = p_227239_.structureTemplateManager();
        LevelHeightAccessor $$12 = p_227239_.heightAccessor();
        WorldgenRandom $$13 = p_227239_.random();
        Registry<StructureTemplatePool> $$14 = $$9.registryOrThrow(Registries.TEMPLATE_POOL);
        Rotation $$15 = Rotation.getRandom($$13);
        StructureTemplatePool $$16 = p_227240_.unwrapKey().flatMap(p_314915_ -> $$14.getOptional(p_307522_.lookup((ResourceKey<StructureTemplatePool>)p_314915_))).orElse(p_227240_.value());
        StructurePoolElement $$17 = $$16.getRandomTemplate($$13);
        if ($$17 == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (p_227241_.isPresent()) {
            ResourceLocation $$18 = p_227241_.get();
            Optional<BlockPos> $$19 = JigsawPlacement.getRandomNamedJigsaw($$17, $$18, p_227243_, $$15, $$11, $$13);
            if ($$19.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)$$18, (Object)p_227240_.unwrapKey().map(p_248484_ -> p_248484_.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPos $$20 = $$19.get();
        } else {
            $$21 = p_227243_;
        }
        BlockPos $$22 = $$21.subtract(p_227243_);
        BlockPos $$23 = p_227243_.subtract($$22);
        PoolElementStructurePiece $$24 = new PoolElementStructurePiece($$11, $$17, $$23, $$17.getGroundLevelDelta(), $$15, $$17.getBoundingBox($$11, $$23, $$15));
        BoundingBox $$25 = $$24.getBoundingBox();
        int $$26 = ($$25.maxX() + $$25.minX()) / 2;
        int $$27 = ($$25.maxZ() + $$25.minZ()) / 2;
        if (p_227245_.isPresent()) {
            int $$28 = p_227243_.getY() + $$10.getFirstFreeHeight($$26, $$27, p_227245_.get(), $$12, p_227239_.randomState());
        } else {
            $$29 = $$23.getY();
        }
        int $$30 = $$25.minY() + $$24.getGroundLevelDelta();
        $$24.move(0, $$29 - $$30, 0);
        int $$31 = $$29 + $$22.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos($$26, $$31, $$27), p_307184_ -> {
            ArrayList $$16 = Lists.newArrayList();
            $$16.add($$24);
            if (p_227242_ <= 0) {
                return;
            }
            AABB $$17 = new AABB($$26 - p_227246_, $$31 - p_227246_, $$27 - p_227246_, $$26 + p_227246_ + 1, $$31 + p_227246_ + 1, $$27 + p_227246_ + 1);
            VoxelShape $$18 = Shapes.join(Shapes.create($$17), Shapes.create(AABB.of($$25)), BooleanOp.ONLY_FIRST);
            JigsawPlacement.addPieces(p_227239_.randomState(), p_227242_, p_227244_, $$10, $$11, $$12, $$13, $$14, $$24, $$16, $$18, p_307522_);
            $$16.forEach(p_307184_::addPiece);
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement p_227248_, ResourceLocation p_227249_, BlockPos p_227250_, Rotation p_227251_, StructureTemplateManager p_227252_, WorldgenRandom p_227253_) {
        List<StructureTemplate.StructureBlockInfo> $$6 = p_227248_.getShuffledJigsawBlocks(p_227252_, p_227250_, p_227251_, p_227253_);
        Optional<BlockPos> $$7 = Optional.empty();
        for (StructureTemplate.StructureBlockInfo $$8 : $$6) {
            ResourceLocation $$9 = ResourceLocation.tryParse(Objects.requireNonNull($$8.nbt(), () -> String.valueOf($$8) + " nbt was null").getString("name"));
            if (!p_227249_.equals($$9)) continue;
            $$7 = Optional.of($$8.pos());
            break;
        }
        return $$7;
    }

    private static void addPieces(RandomState p_227211_, int p_227212_, boolean p_227213_, ChunkGenerator p_227214_, StructureTemplateManager p_227215_, LevelHeightAccessor p_227216_, RandomSource p_227217_, Registry<StructureTemplatePool> p_227218_, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> p_227220_, VoxelShape p_227221_, PoolAliasLookup p_307210_) {
        Placer $$12 = new Placer(p_227218_, p_227212_, p_227214_, p_227215_, p_227220_, p_227217_);
        $$12.tryPlacingChildren(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0, p_227213_, p_227216_, p_227211_, p_307210_);
        while ($$12.placing.hasNext()) {
            PieceState $$13 = (PieceState)$$12.placing.next();
            $$12.tryPlacingChildren($$13.piece, $$13.free, $$13.depth, p_227213_, p_227216_, p_227211_, p_307210_);
        }
    }

    public static boolean generateJigsaw(ServerLevel p_227204_, Holder<StructureTemplatePool> p_227205_, ResourceLocation p_227206_, int p_227207_, BlockPos p_227208_, boolean p_227209_) {
        ChunkGenerator $$6 = p_227204_.getChunkSource().getGenerator();
        StructureTemplateManager $$7 = p_227204_.getStructureManager();
        StructureManager $$8 = p_227204_.structureManager();
        RandomSource $$9 = p_227204_.getRandom();
        Structure.GenerationContext $$10 = new Structure.GenerationContext(p_227204_.registryAccess(), $$6, $$6.getBiomeSource(), p_227204_.getChunkSource().randomState(), $$7, p_227204_.getSeed(), new ChunkPos(p_227208_), p_227204_, p_227255_ -> true);
        Optional<Structure.GenerationStub> $$11 = JigsawPlacement.addPieces($$10, p_227205_, Optional.of(p_227206_), p_227207_, p_227208_, false, Optional.empty(), 128, PoolAliasLookup.EMPTY);
        if ($$11.isPresent()) {
            StructurePiecesBuilder $$12 = $$11.get().getPiecesBuilder();
            for (StructurePiece $$13 : $$12.build().pieces()) {
                if (!($$13 instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece $$14 = (PoolElementStructurePiece)$$13;
                $$14.place(p_227204_, $$8, $$6, $$9, BoundingBox.infinite(), p_227208_, p_227209_);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> p_227258_, int p_227259_, ChunkGenerator p_227260_, StructureTemplateManager p_227261_, List<? super PoolElementStructurePiece> p_227262_, RandomSource p_227263_) {
            this.pools = p_227258_;
            this.maxDepth = p_227259_;
            this.chunkGenerator = p_227260_;
            this.structureTemplateManager = p_227261_;
            this.pieces = p_227262_;
            this.random = p_227263_;
        }

        void tryPlacingChildren(PoolElementStructurePiece p_227265_, MutableObject<VoxelShape> p_227266_, int p_227267_, boolean p_227268_, LevelHeightAccessor p_227269_, RandomState p_227270_, PoolAliasLookup p_307643_) {
            StructurePoolElement $$7 = p_227265_.getElement();
            BlockPos $$8 = p_227265_.getPosition();
            Rotation $$9 = p_227265_.getRotation();
            StructureTemplatePool.Projection $$10 = $$7.getProjection();
            boolean $$11 = $$10 == StructureTemplatePool.Projection.RIGID;
            MutableObject $$12 = new MutableObject();
            BoundingBox $$13 = p_227265_.getBoundingBox();
            int $$14 = $$13.minY();
            block0: for (StructureTemplate.StructureBlockInfo $$15 : $$7.getShuffledJigsawBlocks(this.structureTemplateManager, $$8, $$9, this.random)) {
                StructurePoolElement $$30;
                MutableObject<VoxelShape> $$27;
                Direction $$16 = JigsawBlock.getFrontFacing($$15.state());
                BlockPos $$17 = $$15.pos();
                BlockPos $$18 = $$17.relative($$16);
                int $$19 = $$17.getY() - $$14;
                int $$20 = -1;
                ResourceKey<StructureTemplatePool> $$21 = Placer.readPoolKey($$15, p_307643_);
                Optional<Holder.Reference<StructureTemplatePool>> $$22 = this.pools.getHolder($$21);
                if ($$22.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$21.location());
                    continue;
                }
                Holder $$23 = $$22.get();
                if (((StructureTemplatePool)$$23.value()).size() == 0 && !$$23.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$21.location());
                    continue;
                }
                Holder<StructureTemplatePool> $$24 = ((StructureTemplatePool)$$23.value()).getFallback();
                if ($$24.value().size() == 0 && !$$24.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)$$24.unwrapKey().map(p_255599_ -> p_255599_.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean $$25 = $$13.isInside($$18);
                if ($$25) {
                    MutableObject $$26 = $$12;
                    if ($$12.getValue() == null) {
                        $$12.setValue((Object)Shapes.create(AABB.of($$13)));
                    }
                } else {
                    $$27 = p_227266_;
                }
                ArrayList $$28 = Lists.newArrayList();
                if (p_227267_ != this.maxDepth) {
                    $$28.addAll(((StructureTemplatePool)$$23.value()).getShuffledTemplates(this.random));
                }
                $$28.addAll($$24.value().getShuffledTemplates(this.random));
                int $$29 = $$15.nbt() != null ? $$15.nbt().getInt("placement_priority") : 0;
                Iterator iterator = $$28.iterator();
                while (iterator.hasNext() && ($$30 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation $$31 : Rotation.getShuffled(this.random)) {
                        int $$35;
                        List<StructureTemplate.StructureBlockInfo> $$32 = $$30.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, $$31, this.random);
                        BoundingBox $$33 = $$30.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, $$31);
                        if (!p_227268_ || $$33.getYSpan() > 16) {
                            boolean $$34 = false;
                        } else {
                            $$35 = $$32.stream().mapToInt(p_255598_ -> {
                                if (!$$33.isInside(p_255598_.pos().relative(JigsawBlock.getFrontFacing(p_255598_.state())))) {
                                    return 0;
                                }
                                ResourceKey<StructureTemplatePool> $$3 = Placer.readPoolKey(p_255598_, p_307643_);
                                Optional<Holder.Reference<StructureTemplatePool>> $$4 = this.pools.getHolder($$3);
                                Optional<Holder> $$5 = $$4.map(p_255600_ -> ((StructureTemplatePool)p_255600_.value()).getFallback());
                                int $$6 = $$4.map(p_255596_ -> ((StructureTemplatePool)p_255596_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                int $$7 = $$5.map(p_255601_ -> ((StructureTemplatePool)p_255601_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                return Math.max($$6, $$7);
                            }).max().orElse(0);
                        }
                        for (StructureTemplate.StructureBlockInfo $$36 : $$32) {
                            int $$57;
                            int $$53;
                            int $$46;
                            if (!JigsawBlock.canAttach($$15, $$36)) continue;
                            BlockPos $$37 = $$36.pos();
                            BlockPos $$38 = $$18.subtract($$37);
                            BoundingBox $$39 = $$30.getBoundingBox(this.structureTemplateManager, $$38, $$31);
                            int $$40 = $$39.minY();
                            StructureTemplatePool.Projection $$41 = $$30.getProjection();
                            boolean $$42 = $$41 == StructureTemplatePool.Projection.RIGID;
                            int $$43 = $$37.getY();
                            int $$44 = $$19 - $$43 + JigsawBlock.getFrontFacing($$15.state()).getStepY();
                            if ($$11 && $$42) {
                                int $$45 = $$14 + $$44;
                            } else {
                                if ($$20 == -1) {
                                    $$20 = this.chunkGenerator.getFirstFreeHeight($$17.getX(), $$17.getZ(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                $$46 = $$20 - $$43;
                            }
                            int $$47 = $$46 - $$40;
                            BoundingBox $$48 = $$39.moved(0, $$47, 0);
                            BlockPos $$49 = $$38.offset(0, $$47, 0);
                            if ($$35 > 0) {
                                int $$50 = Math.max($$35 + 1, $$48.maxY() - $$48.minY());
                                $$48.encapsulate(new BlockPos($$48.minX(), $$48.minY() + $$50, $$48.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)$$27.getValue(), Shapes.create(AABB.of($$48).deflate(0.25)), BooleanOp.ONLY_SECOND)) continue;
                            $$27.setValue((Object)Shapes.joinUnoptimized((VoxelShape)$$27.getValue(), Shapes.create(AABB.of($$48)), BooleanOp.ONLY_FIRST));
                            int $$51 = p_227265_.getGroundLevelDelta();
                            if ($$42) {
                                int $$52 = $$51 - $$44;
                            } else {
                                $$53 = $$30.getGroundLevelDelta();
                            }
                            PoolElementStructurePiece $$54 = new PoolElementStructurePiece(this.structureTemplateManager, $$30, $$49, $$53, $$31, $$48);
                            if ($$11) {
                                int $$55 = $$14 + $$19;
                            } else if ($$42) {
                                int $$56 = $$46 + $$43;
                            } else {
                                if ($$20 == -1) {
                                    $$20 = this.chunkGenerator.getFirstFreeHeight($$17.getX(), $$17.getZ(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                $$57 = $$20 + $$44 / 2;
                            }
                            p_227265_.addJunction(new JigsawJunction($$18.getX(), (int)($$57 - $$19 + $$51), $$18.getZ(), $$44, $$41));
                            $$54.addJunction(new JigsawJunction($$17.getX(), $$57 - $$43 + $$53, $$17.getZ(), -$$44, $$10));
                            this.pieces.add($$54);
                            if (p_227267_ + 1 > this.maxDepth) continue block0;
                            PieceState $$58 = new PieceState($$54, $$27, p_227267_ + 1);
                            this.placing.add($$58, $$29);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolKey(StructureTemplate.StructureBlockInfo p_307327_, PoolAliasLookup p_307490_) {
            CompoundTag $$2 = Objects.requireNonNull(p_307327_.nbt(), () -> String.valueOf(p_307327_) + " nbt was null");
            ResourceKey<StructureTemplatePool> $$3 = Pools.createKey($$2.getString("pool"));
            return p_307490_.lookup($$3);
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

