/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class StructureTemplate {
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    private final List<Palette> palettes = Lists.newArrayList();
    private final List<StructureEntityInfo> entityInfoList = Lists.newArrayList();
    private Vec3i size = Vec3i.ZERO;
    private String author = "?";

    public Vec3i getSize() {
        return this.size;
    }

    public void setAuthor(String p_74613_) {
        this.author = p_74613_;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(Level p_163803_, BlockPos p_163804_, Vec3i p_163805_, boolean p_163806_, @Nullable Block p_163807_) {
        if (p_163805_.getX() < 1 || p_163805_.getY() < 1 || p_163805_.getZ() < 1) {
            return;
        }
        BlockPos $$5 = p_163804_.offset(p_163805_).offset(-1, -1, -1);
        ArrayList $$6 = Lists.newArrayList();
        ArrayList $$7 = Lists.newArrayList();
        ArrayList $$8 = Lists.newArrayList();
        BlockPos $$9 = new BlockPos(Math.min(p_163804_.getX(), $$5.getX()), Math.min(p_163804_.getY(), $$5.getY()), Math.min(p_163804_.getZ(), $$5.getZ()));
        BlockPos $$10 = new BlockPos(Math.max(p_163804_.getX(), $$5.getX()), Math.max(p_163804_.getY(), $$5.getY()), Math.max(p_163804_.getZ(), $$5.getZ()));
        this.size = p_163805_;
        for (BlockPos $$11 : BlockPos.betweenClosed($$9, $$10)) {
            StructureBlockInfo $$16;
            BlockPos $$12 = $$11.subtract($$9);
            BlockState $$13 = p_163803_.getBlockState($$11);
            if (p_163807_ != null && $$13.is(p_163807_)) continue;
            BlockEntity $$14 = p_163803_.getBlockEntity($$11);
            if ($$14 != null) {
                StructureBlockInfo $$15 = new StructureBlockInfo($$12, $$13, $$14.saveWithId(p_163803_.registryAccess()));
            } else {
                $$16 = new StructureBlockInfo($$12, $$13, null);
            }
            StructureTemplate.addToLists($$16, $$6, $$7, $$8);
        }
        List<StructureBlockInfo> $$17 = StructureTemplate.buildInfoList($$6, $$7, $$8);
        this.palettes.clear();
        this.palettes.add(new Palette($$17));
        if (p_163806_) {
            this.fillEntityList(p_163803_, $$9, $$10);
        } else {
            this.entityInfoList.clear();
        }
    }

    private static void addToLists(StructureBlockInfo p_74574_, List<StructureBlockInfo> p_74575_, List<StructureBlockInfo> p_74576_, List<StructureBlockInfo> p_74577_) {
        if (p_74574_.nbt != null) {
            p_74576_.add(p_74574_);
        } else if (!p_74574_.state.getBlock().hasDynamicShape() && p_74574_.state.isCollisionShapeFullBlock(EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            p_74575_.add(p_74574_);
        } else {
            p_74577_.add(p_74574_);
        }
    }

    private static List<StructureBlockInfo> buildInfoList(List<StructureBlockInfo> p_74615_, List<StructureBlockInfo> p_74616_, List<StructureBlockInfo> p_74617_) {
        Comparator<StructureBlockInfo> $$3 = Comparator.comparingInt(p_74641_ -> p_74641_.pos.getY()).thenComparingInt(p_74637_ -> p_74637_.pos.getX()).thenComparingInt(p_74572_ -> p_74572_.pos.getZ());
        p_74615_.sort($$3);
        p_74617_.sort($$3);
        p_74616_.sort($$3);
        ArrayList $$4 = Lists.newArrayList();
        $$4.addAll(p_74615_);
        $$4.addAll(p_74617_);
        $$4.addAll(p_74616_);
        return $$4;
    }

    private void fillEntityList(Level p_74501_, BlockPos p_74502_, BlockPos p_74503_) {
        List<Entity> $$3 = p_74501_.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks(p_74502_, p_74503_), p_74499_ -> !(p_74499_ instanceof Player));
        this.entityInfoList.clear();
        for (Entity $$4 : $$3) {
            BlockPos $$8;
            Vec3 $$5 = new Vec3($$4.getX() - (double)p_74502_.getX(), $$4.getY() - (double)p_74502_.getY(), $$4.getZ() - (double)p_74502_.getZ());
            CompoundTag $$6 = new CompoundTag();
            $$4.save($$6);
            if ($$4 instanceof Painting) {
                BlockPos $$7 = ((Painting)$$4).getPos().subtract(p_74502_);
            } else {
                $$8 = BlockPos.containing($$5);
            }
            this.entityInfoList.add(new StructureEntityInfo($$5, $$8, $$6.copy()));
        }
    }

    public List<StructureBlockInfo> filterBlocks(BlockPos p_74604_, StructurePlaceSettings p_74605_, Block p_74606_) {
        return this.filterBlocks(p_74604_, p_74605_, p_74606_, true);
    }

    public ObjectArrayList<StructureBlockInfo> filterBlocks(BlockPos p_230336_, StructurePlaceSettings p_230337_, Block p_230338_, boolean p_230339_) {
        ObjectArrayList $$4 = new ObjectArrayList();
        BoundingBox $$5 = p_230337_.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return $$4;
        }
        for (StructureBlockInfo $$6 : p_230337_.getRandomPalette(this.palettes, p_230336_).blocks(p_230338_)) {
            BlockPos $$7;
            BlockPos blockPos = $$7 = p_230339_ ? StructureTemplate.calculateRelativePosition(p_230337_, $$6.pos).offset(p_230336_) : $$6.pos;
            if ($$5 != null && !$$5.isInside($$7)) continue;
            $$4.add((Object)new StructureBlockInfo($$7, $$6.state.rotate(p_230337_.getRotation()), $$6.nbt));
        }
        return $$4;
    }

    public BlockPos calculateConnectedPosition(StructurePlaceSettings p_74567_, BlockPos p_74568_, StructurePlaceSettings p_74569_, BlockPos p_74570_) {
        BlockPos $$4 = StructureTemplate.calculateRelativePosition(p_74567_, p_74568_);
        BlockPos $$5 = StructureTemplate.calculateRelativePosition(p_74569_, p_74570_);
        return $$4.subtract($$5);
    }

    public static BlockPos calculateRelativePosition(StructurePlaceSettings p_74564_, BlockPos p_74565_) {
        return StructureTemplate.transform(p_74565_, p_74564_.getMirror(), p_74564_.getRotation(), p_74564_.getRotationPivot());
    }

    public boolean placeInWorld(ServerLevelAccessor p_230329_, BlockPos p_230330_, BlockPos p_230331_, StructurePlaceSettings p_230332_, RandomSource p_230333_, int p_230334_) {
        if (this.palettes.isEmpty()) {
            return false;
        }
        List<StructureBlockInfo> $$6 = p_230332_.getRandomPalette(this.palettes, p_230330_).blocks();
        if ($$6.isEmpty() && (p_230332_.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1) {
            return false;
        }
        BoundingBox $$7 = p_230332_.getBoundingBox();
        ArrayList $$8 = Lists.newArrayListWithCapacity((int)(p_230332_.shouldKeepLiquids() ? $$6.size() : 0));
        ArrayList $$9 = Lists.newArrayListWithCapacity((int)(p_230332_.shouldKeepLiquids() ? $$6.size() : 0));
        ArrayList $$10 = Lists.newArrayListWithCapacity((int)$$6.size());
        int $$11 = Integer.MAX_VALUE;
        int $$12 = Integer.MAX_VALUE;
        int $$13 = Integer.MAX_VALUE;
        int $$14 = Integer.MIN_VALUE;
        int $$15 = Integer.MIN_VALUE;
        int $$16 = Integer.MIN_VALUE;
        List<StructureBlockInfo> $$17 = StructureTemplate.processBlockInfos(p_230329_, p_230330_, p_230331_, p_230332_, $$6);
        for (StructureBlockInfo $$18 : $$17) {
            BlockEntity $$23;
            BlockPos $$19 = $$18.pos;
            if ($$7 != null && !$$7.isInside($$19)) continue;
            FluidState $$20 = p_230332_.shouldKeepLiquids() ? p_230329_.getFluidState($$19) : null;
            BlockState $$21 = $$18.state.mirror(p_230332_.getMirror()).rotate(p_230332_.getRotation());
            if ($$18.nbt != null) {
                BlockEntity $$22 = p_230329_.getBlockEntity($$19);
                Clearable.tryClear($$22);
                p_230329_.setBlock($$19, Blocks.BARRIER.defaultBlockState(), 20);
            }
            if (!p_230329_.setBlock($$19, $$21, p_230334_)) continue;
            $$11 = Math.min($$11, $$19.getX());
            $$12 = Math.min($$12, $$19.getY());
            $$13 = Math.min($$13, $$19.getZ());
            $$14 = Math.max($$14, $$19.getX());
            $$15 = Math.max($$15, $$19.getY());
            $$16 = Math.max($$16, $$19.getZ());
            $$10.add(Pair.of((Object)$$19, (Object)$$18.nbt));
            if ($$18.nbt != null && ($$23 = p_230329_.getBlockEntity($$19)) != null) {
                if ($$23 instanceof RandomizableContainer) {
                    $$18.nbt.putLong("LootTableSeed", p_230333_.nextLong());
                }
                $$23.loadWithComponents($$18.nbt, p_230329_.registryAccess());
            }
            if ($$20 == null) continue;
            if ($$21.getFluidState().isSource()) {
                $$9.add($$19);
                continue;
            }
            if (!($$21.getBlock() instanceof LiquidBlockContainer)) continue;
            ((LiquidBlockContainer)((Object)$$21.getBlock())).placeLiquid(p_230329_, $$19, $$21, $$20);
            if ($$20.isSource()) continue;
            $$8.add($$19);
        }
        boolean $$24 = true;
        Direction[] $$25 = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while ($$24 && !$$8.isEmpty()) {
            $$24 = false;
            Iterator $$26 = $$8.iterator();
            while ($$26.hasNext()) {
                BlockState $$32;
                Object $$33;
                BlockPos $$27 = (BlockPos)$$26.next();
                FluidState $$28 = p_230329_.getFluidState($$27);
                for (int $$29 = 0; $$29 < $$25.length && !$$28.isSource(); ++$$29) {
                    BlockPos $$30 = $$27.relative($$25[$$29]);
                    FluidState $$31 = p_230329_.getFluidState($$30);
                    if (!$$31.isSource() || $$9.contains($$30)) continue;
                    $$28 = $$31;
                }
                if (!$$28.isSource() || !(($$33 = ($$32 = p_230329_.getBlockState($$27)).getBlock()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)$$33).placeLiquid(p_230329_, $$27, $$32, $$28);
                $$24 = true;
                $$26.remove();
            }
        }
        if ($$11 <= $$14) {
            if (!p_230332_.getKnownShape()) {
                BitSetDiscreteVoxelShape $$34 = new BitSetDiscreteVoxelShape($$14 - $$11 + 1, $$15 - $$12 + 1, $$16 - $$13 + 1);
                int $$35 = $$11;
                int $$36 = $$12;
                int $$37 = $$13;
                for (Pair $$38 : $$10) {
                    BlockPos $$39 = (BlockPos)$$38.getFirst();
                    ((DiscreteVoxelShape)$$34).fill($$39.getX() - $$35, $$39.getY() - $$36, $$39.getZ() - $$37);
                }
                StructureTemplate.updateShapeAtEdge(p_230329_, p_230334_, $$34, $$35, $$36, $$37);
            }
            for (Pair $$40 : $$10) {
                BlockEntity $$44;
                BlockPos $$41 = (BlockPos)$$40.getFirst();
                if (!p_230332_.getKnownShape()) {
                    BlockState $$43;
                    BlockState $$42 = p_230329_.getBlockState($$41);
                    if ($$42 != ($$43 = Block.updateFromNeighbourShapes($$42, p_230329_, $$41))) {
                        p_230329_.setBlock($$41, $$43, p_230334_ & 0xFFFFFFFE | 0x10);
                    }
                    p_230329_.blockUpdated($$41, $$43.getBlock());
                }
                if ($$40.getSecond() == null || ($$44 = p_230329_.getBlockEntity($$41)) == null) continue;
                $$44.setChanged();
            }
        }
        if (!p_230332_.isIgnoreEntities()) {
            this.placeEntities(p_230329_, p_230330_, p_230332_.getMirror(), p_230332_.getRotation(), p_230332_.getRotationPivot(), $$7, p_230332_.shouldFinalizeEntities());
        }
        return true;
    }

    public static void updateShapeAtEdge(LevelAccessor p_333926_, int p_333789_, DiscreteVoxelShape p_333845_, BlockPos p_333731_) {
        StructureTemplate.updateShapeAtEdge(p_333926_, p_333789_, p_333845_, p_333731_.getX(), p_333731_.getY(), p_333731_.getZ());
    }

    public static void updateShapeAtEdge(LevelAccessor p_74511_, int p_74512_, DiscreteVoxelShape p_74513_, int p_74514_, int p_74515_, int p_74516_) {
        BlockPos.MutableBlockPos $$6 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos $$7 = new BlockPos.MutableBlockPos();
        p_74513_.forAllFaces((p_333699_, p_333700_, p_333701_, p_333702_) -> {
            BlockState $$14;
            $$6.set(p_74514_ + p_333700_, p_74515_ + p_333701_, p_74516_ + p_333702_);
            $$7.setWithOffset((Vec3i)$$6, p_333699_);
            BlockState $$11 = p_74511_.getBlockState($$6);
            BlockState $$12 = p_74511_.getBlockState($$7);
            BlockState $$13 = $$11.updateShape(p_333699_, $$12, p_74511_, $$6, $$7);
            if ($$11 != $$13) {
                p_74511_.setBlock($$6, $$13, p_74512_ & 0xFFFFFFFE);
            }
            if ($$12 != ($$14 = $$12.updateShape(p_333699_.getOpposite(), $$13, p_74511_, $$7, $$6))) {
                p_74511_.setBlock($$7, $$14, p_74512_ & 0xFFFFFFFE);
            }
        });
    }

    public static List<StructureBlockInfo> processBlockInfos(ServerLevelAccessor p_278297_, BlockPos p_74519_, BlockPos p_74520_, StructurePlaceSettings p_74521_, List<StructureBlockInfo> p_74522_) {
        ArrayList<StructureBlockInfo> $$5 = new ArrayList<StructureBlockInfo>();
        List<StructureBlockInfo> $$6 = new ArrayList<StructureBlockInfo>();
        for (StructureBlockInfo $$7 : p_74522_) {
            BlockPos $$8 = StructureTemplate.calculateRelativePosition(p_74521_, $$7.pos).offset(p_74519_);
            StructureBlockInfo $$9 = new StructureBlockInfo($$8, $$7.state, $$7.nbt != null ? $$7.nbt.copy() : null);
            Iterator<StructureProcessor> $$10 = p_74521_.getProcessors().iterator();
            while ($$9 != null && $$10.hasNext()) {
                $$9 = $$10.next().processBlock(p_278297_, p_74519_, p_74520_, $$7, $$9, p_74521_);
            }
            if ($$9 == null) continue;
            $$6.add($$9);
            $$5.add($$7);
        }
        for (StructureProcessor $$11 : p_74521_.getProcessors()) {
            $$6 = $$11.finalizeProcessing(p_278297_, p_74519_, p_74520_, $$5, $$6, p_74521_);
        }
        return $$6;
    }

    private void placeEntities(ServerLevelAccessor p_74524_, BlockPos p_74525_, Mirror p_74526_, Rotation p_74527_, BlockPos p_74528_, @Nullable BoundingBox p_74529_, boolean p_74530_) {
        for (StructureEntityInfo $$7 : this.entityInfoList) {
            BlockPos $$8 = StructureTemplate.transform($$7.blockPos, p_74526_, p_74527_, p_74528_).offset(p_74525_);
            if (p_74529_ != null && !p_74529_.isInside($$8)) continue;
            CompoundTag $$9 = $$7.nbt.copy();
            Vec3 $$10 = StructureTemplate.transform($$7.pos, p_74526_, p_74527_, p_74528_);
            Vec3 $$11 = $$10.add(p_74525_.getX(), p_74525_.getY(), p_74525_.getZ());
            ListTag $$12 = new ListTag();
            $$12.add(DoubleTag.valueOf($$11.x));
            $$12.add(DoubleTag.valueOf($$11.y));
            $$12.add(DoubleTag.valueOf($$11.z));
            $$9.put("Pos", $$12);
            $$9.remove("UUID");
            StructureTemplate.createEntityIgnoreException(p_74524_, $$9).ifPresent(p_275190_ -> {
                float $$6 = p_275190_.rotate(p_74527_);
                p_275190_.moveTo(p_275186_.x, p_275186_.y, p_275186_.z, $$6 += p_275190_.mirror(p_74526_) - p_275190_.getYRot(), p_275190_.getXRot());
                if (p_74530_ && p_275190_ instanceof Mob) {
                    ((Mob)p_275190_).finalizeSpawn(p_74524_, p_74524_.getCurrentDifficultyAt(BlockPos.containing($$11)), MobSpawnType.STRUCTURE, null);
                }
                p_74524_.addFreshEntityWithPassengers((Entity)p_275190_);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ServerLevelAccessor p_74544_, CompoundTag p_74545_) {
        try {
            return EntityType.create(p_74545_, p_74544_.getLevel());
        }
        catch (Exception $$2) {
            return Optional.empty();
        }
    }

    public Vec3i getSize(Rotation p_163809_) {
        switch (p_163809_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new Vec3i(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPos transform(BlockPos p_74594_, Mirror p_74595_, Rotation p_74596_, BlockPos p_74597_) {
        int $$4 = p_74594_.getX();
        int $$5 = p_74594_.getY();
        int $$6 = p_74594_.getZ();
        boolean $$7 = true;
        switch (p_74595_) {
            case LEFT_RIGHT: {
                $$6 = -$$6;
                break;
            }
            case FRONT_BACK: {
                $$4 = -$$4;
                break;
            }
            default: {
                $$7 = false;
            }
        }
        int $$8 = p_74597_.getX();
        int $$9 = p_74597_.getZ();
        switch (p_74596_) {
            case CLOCKWISE_180: {
                return new BlockPos($$8 + $$8 - $$4, $$5, $$9 + $$9 - $$6);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos($$8 - $$9 + $$6, $$5, $$8 + $$9 - $$4);
            }
            case CLOCKWISE_90: {
                return new BlockPos($$8 + $$9 - $$6, $$5, $$9 - $$8 + $$4);
            }
        }
        return $$7 ? new BlockPos($$4, $$5, $$6) : p_74594_;
    }

    public static Vec3 transform(Vec3 p_74579_, Mirror p_74580_, Rotation p_74581_, BlockPos p_74582_) {
        double $$4 = p_74579_.x;
        double $$5 = p_74579_.y;
        double $$6 = p_74579_.z;
        boolean $$7 = true;
        switch (p_74580_) {
            case LEFT_RIGHT: {
                $$6 = 1.0 - $$6;
                break;
            }
            case FRONT_BACK: {
                $$4 = 1.0 - $$4;
                break;
            }
            default: {
                $$7 = false;
            }
        }
        int $$8 = p_74582_.getX();
        int $$9 = p_74582_.getZ();
        switch (p_74581_) {
            case CLOCKWISE_180: {
                return new Vec3((double)($$8 + $$8 + 1) - $$4, $$5, (double)($$9 + $$9 + 1) - $$6);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vec3((double)($$8 - $$9) + $$6, $$5, (double)($$8 + $$9 + 1) - $$4);
            }
            case CLOCKWISE_90: {
                return new Vec3((double)($$8 + $$9 + 1) - $$6, $$5, (double)($$9 - $$8) + $$4);
            }
        }
        return $$7 ? new Vec3($$4, $$5, $$6) : p_74579_;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos p_74584_, Mirror p_74585_, Rotation p_74586_) {
        return StructureTemplate.getZeroPositionWithTransform(p_74584_, p_74585_, p_74586_, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos p_74588_, Mirror p_74589_, Rotation p_74590_, int p_74591_, int p_74592_) {
        int $$5 = p_74589_ == Mirror.FRONT_BACK ? --p_74591_ : 0;
        int $$6 = p_74589_ == Mirror.LEFT_RIGHT ? --p_74592_ : 0;
        BlockPos $$7 = p_74588_;
        switch (p_74590_) {
            case NONE: {
                $$7 = p_74588_.offset($$5, 0, $$6);
                break;
            }
            case CLOCKWISE_90: {
                $$7 = p_74588_.offset(p_74592_ - $$6, 0, $$5);
                break;
            }
            case CLOCKWISE_180: {
                $$7 = p_74588_.offset(p_74591_ - $$5, 0, p_74592_ - $$6);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                $$7 = p_74588_.offset($$6, 0, p_74591_ - $$5);
            }
        }
        return $$7;
    }

    public BoundingBox getBoundingBox(StructurePlaceSettings p_74634_, BlockPos p_74635_) {
        return this.getBoundingBox(p_74635_, p_74634_.getRotation(), p_74634_.getRotationPivot(), p_74634_.getMirror());
    }

    public BoundingBox getBoundingBox(BlockPos p_74599_, Rotation p_74600_, BlockPos p_74601_, Mirror p_74602_) {
        return StructureTemplate.getBoundingBox(p_74599_, p_74600_, p_74601_, p_74602_, this.size);
    }

    @VisibleForTesting
    protected static BoundingBox getBoundingBox(BlockPos p_163811_, Rotation p_163812_, BlockPos p_163813_, Mirror p_163814_, Vec3i p_163815_) {
        Vec3i $$5 = p_163815_.offset(-1, -1, -1);
        BlockPos $$6 = StructureTemplate.transform(BlockPos.ZERO, p_163814_, p_163812_, p_163813_);
        BlockPos $$7 = StructureTemplate.transform(BlockPos.ZERO.offset($$5), p_163814_, p_163812_, p_163813_);
        return BoundingBox.fromCorners($$6, $$7).move(p_163811_);
    }

    public CompoundTag save(CompoundTag p_74619_) {
        if (this.palettes.isEmpty()) {
            p_74619_.put(BLOCKS_TAG, new ListTag());
            p_74619_.put(PALETTE_TAG, new ListTag());
        } else {
            ArrayList $$1 = Lists.newArrayList();
            SimplePalette $$2 = new SimplePalette();
            $$1.add($$2);
            for (int $$3 = 1; $$3 < this.palettes.size(); ++$$3) {
                $$1.add(new SimplePalette());
            }
            ListTag $$4 = new ListTag();
            List<StructureBlockInfo> $$5 = this.palettes.get(0).blocks();
            for (int $$6 = 0; $$6 < $$5.size(); ++$$6) {
                StructureBlockInfo $$7 = $$5.get($$6);
                CompoundTag $$8 = new CompoundTag();
                $$8.put("pos", this.newIntegerList($$7.pos.getX(), $$7.pos.getY(), $$7.pos.getZ()));
                int $$9 = $$2.idFor($$7.state);
                $$8.putInt(BLOCK_TAG_STATE, $$9);
                if ($$7.nbt != null) {
                    $$8.put("nbt", $$7.nbt);
                }
                $$4.add($$8);
                for (int $$10 = 1; $$10 < this.palettes.size(); ++$$10) {
                    SimplePalette $$11 = (SimplePalette)$$1.get($$10);
                    $$11.addMapping(this.palettes.get((int)$$10).blocks().get((int)$$6).state, $$9);
                }
            }
            p_74619_.put(BLOCKS_TAG, $$4);
            if ($$1.size() == 1) {
                ListTag $$12 = new ListTag();
                for (BlockState $$13 : $$2) {
                    $$12.add(NbtUtils.writeBlockState($$13));
                }
                p_74619_.put(PALETTE_TAG, $$12);
            } else {
                ListTag $$14 = new ListTag();
                for (SimplePalette $$15 : $$1) {
                    ListTag $$16 = new ListTag();
                    for (BlockState $$17 : $$15) {
                        $$16.add(NbtUtils.writeBlockState($$17));
                    }
                    $$14.add($$16);
                }
                p_74619_.put(PALETTE_LIST_TAG, $$14);
            }
        }
        ListTag $$18 = new ListTag();
        for (StructureEntityInfo $$19 : this.entityInfoList) {
            CompoundTag $$20 = new CompoundTag();
            $$20.put("pos", this.newDoubleList($$19.pos.x, $$19.pos.y, $$19.pos.z));
            $$20.put(ENTITY_TAG_BLOCKPOS, this.newIntegerList($$19.blockPos.getX(), $$19.blockPos.getY(), $$19.blockPos.getZ()));
            if ($$19.nbt != null) {
                $$20.put("nbt", $$19.nbt);
            }
            $$18.add($$20);
        }
        p_74619_.put(ENTITIES_TAG, $$18);
        p_74619_.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        return NbtUtils.addCurrentDataVersion(p_74619_);
    }

    public void load(HolderGetter<Block> p_255773_, CompoundTag p_248574_) {
        this.palettes.clear();
        this.entityInfoList.clear();
        ListTag $$2 = p_248574_.getList(SIZE_TAG, 3);
        this.size = new Vec3i($$2.getInt(0), $$2.getInt(1), $$2.getInt(2));
        ListTag $$3 = p_248574_.getList(BLOCKS_TAG, 10);
        if (p_248574_.contains(PALETTE_LIST_TAG, 9)) {
            ListTag $$4 = p_248574_.getList(PALETTE_LIST_TAG, 9);
            for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
                this.loadPalette(p_255773_, $$4.getList($$5), $$3);
            }
        } else {
            this.loadPalette(p_255773_, p_248574_.getList(PALETTE_TAG, 10), $$3);
        }
        ListTag $$6 = p_248574_.getList(ENTITIES_TAG, 10);
        for (int $$7 = 0; $$7 < $$6.size(); ++$$7) {
            CompoundTag $$8 = $$6.getCompound($$7);
            ListTag $$9 = $$8.getList("pos", 6);
            Vec3 $$10 = new Vec3($$9.getDouble(0), $$9.getDouble(1), $$9.getDouble(2));
            ListTag $$11 = $$8.getList(ENTITY_TAG_BLOCKPOS, 3);
            BlockPos $$12 = new BlockPos($$11.getInt(0), $$11.getInt(1), $$11.getInt(2));
            if (!$$8.contains("nbt")) continue;
            CompoundTag $$13 = $$8.getCompound("nbt");
            this.entityInfoList.add(new StructureEntityInfo($$10, $$12, $$13));
        }
    }

    private void loadPalette(HolderGetter<Block> p_256546_, ListTag p_251056_, ListTag p_251493_) {
        SimplePalette $$3 = new SimplePalette();
        for (int $$4 = 0; $$4 < p_251056_.size(); ++$$4) {
            $$3.addMapping(NbtUtils.readBlockState(p_256546_, p_251056_.getCompound($$4)), $$4);
        }
        ArrayList $$5 = Lists.newArrayList();
        ArrayList $$6 = Lists.newArrayList();
        ArrayList $$7 = Lists.newArrayList();
        for (int $$8 = 0; $$8 < p_251493_.size(); ++$$8) {
            CompoundTag $$14;
            CompoundTag $$9 = p_251493_.getCompound($$8);
            ListTag $$10 = $$9.getList("pos", 3);
            BlockPos $$11 = new BlockPos($$10.getInt(0), $$10.getInt(1), $$10.getInt(2));
            BlockState $$12 = $$3.stateFor($$9.getInt(BLOCK_TAG_STATE));
            if ($$9.contains("nbt")) {
                CompoundTag $$13 = $$9.getCompound("nbt");
            } else {
                $$14 = null;
            }
            StructureBlockInfo $$15 = new StructureBlockInfo($$11, $$12, $$14);
            StructureTemplate.addToLists($$15, $$5, $$6, $$7);
        }
        List<StructureBlockInfo> $$16 = StructureTemplate.buildInfoList($$5, $$6, $$7);
        this.palettes.add(new Palette($$16));
    }

    private ListTag newIntegerList(int ... p_74626_) {
        ListTag $$1 = new ListTag();
        for (int $$2 : p_74626_) {
            $$1.add(IntTag.valueOf($$2));
        }
        return $$1;
    }

    private ListTag newDoubleList(double ... p_74624_) {
        ListTag $$1 = new ListTag();
        for (double $$2 : p_74624_) {
            $$1.add(DoubleTag.valueOf($$2));
        }
        return $$1;
    }

    public record StructureBlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag nbt) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class Palette {
        private final List<StructureBlockInfo> blocks;
        private final Map<Block, List<StructureBlockInfo>> cache = Maps.newHashMap();

        Palette(List<StructureBlockInfo> p_74648_) {
            this.blocks = p_74648_;
        }

        public List<StructureBlockInfo> blocks() {
            return this.blocks;
        }

        public List<StructureBlockInfo> blocks(Block p_74654_) {
            return this.cache.computeIfAbsent(p_74654_, p_74659_ -> this.blocks.stream().filter(p_163818_ -> p_163818_.state.is((Block)p_74659_)).collect(Collectors.toList()));
        }
    }

    public static class StructureEntityInfo {
        public final Vec3 pos;
        public final BlockPos blockPos;
        public final CompoundTag nbt;

        public StructureEntityInfo(Vec3 p_74687_, BlockPos p_74688_, CompoundTag p_74689_) {
            this.pos = p_74687_;
            this.blockPos = p_74688_;
            this.nbt = p_74689_;
        }
    }

    static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        SimplePalette() {
        }

        public int idFor(BlockState p_74670_) {
            int $$1 = this.ids.getId(p_74670_);
            if ($$1 == -1) {
                $$1 = this.lastId++;
                this.ids.addMapping(p_74670_, $$1);
            }
            return $$1;
        }

        @Nullable
        public BlockState stateFor(int p_74668_) {
            BlockState $$1 = this.ids.byId(p_74668_);
            return $$1 == null ? DEFAULT_BLOCK_STATE : $$1;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState p_74672_, int p_74673_) {
            this.ids.addMapping(p_74672_, p_74673_);
        }
    }
}

