/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootContext {
    private final LootParams params;
    private final RandomSource random;
    private final HolderGetter.Provider lootDataResolver;
    private final Set<VisitedEntry<?>> visitedElements = Sets.newLinkedHashSet();

    LootContext(LootParams p_287722_, RandomSource p_287702_, HolderGetter.Provider p_335850_) {
        this.params = p_287722_;
        this.random = p_287702_;
        this.lootDataResolver = p_335850_;
    }

    public boolean hasParam(LootContextParam<?> p_78937_) {
        return this.params.hasParam(p_78937_);
    }

    public <T> T getParam(LootContextParam<T> p_165125_) {
        return this.params.getParameter(p_165125_);
    }

    public void addDynamicDrops(ResourceLocation p_78943_, Consumer<ItemStack> p_78944_) {
        this.params.addDynamicDrops(p_78943_, p_78944_);
    }

    @Nullable
    public <T> T getParamOrNull(LootContextParam<T> p_78954_) {
        return this.params.getParamOrNull(p_78954_);
    }

    public boolean hasVisitedElement(VisitedEntry<?> p_279182_) {
        return this.visitedElements.contains(p_279182_);
    }

    public boolean pushVisitedElement(VisitedEntry<?> p_279152_) {
        return this.visitedElements.add(p_279152_);
    }

    public void popVisitedElement(VisitedEntry<?> p_279198_) {
        this.visitedElements.remove(p_279198_);
    }

    public HolderGetter.Provider getResolver() {
        return this.lootDataResolver;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public float getLuck() {
        return this.params.getLuck();
    }

    public ServerLevel getLevel() {
        return this.params.getLevel();
    }

    public static VisitedEntry<LootTable> createVisitedEntry(LootTable p_279327_) {
        return new VisitedEntry<LootTable>(LootDataType.TABLE, p_279327_);
    }

    public static VisitedEntry<LootItemCondition> createVisitedEntry(LootItemCondition p_279250_) {
        return new VisitedEntry<LootItemCondition>(LootDataType.PREDICATE, p_279250_);
    }

    public static VisitedEntry<LootItemFunction> createVisitedEntry(LootItemFunction p_279163_) {
        return new VisitedEntry<LootItemFunction>(LootDataType.MODIFIER, p_279163_);
    }

    public record VisitedEntry<T>(LootDataType<T> type, T value) {
    }

    public static enum EntityTarget implements StringRepresentable
    {
        THIS("this", LootContextParams.THIS_ENTITY),
        KILLER("killer", LootContextParams.KILLER_ENTITY),
        DIRECT_KILLER("direct_killer", LootContextParams.DIRECT_KILLER_ENTITY),
        KILLER_PLAYER("killer_player", LootContextParams.LAST_DAMAGE_PLAYER);

        public static final StringRepresentable.EnumCodec<EntityTarget> CODEC;
        private final String name;
        private final LootContextParam<? extends Entity> param;

        private EntityTarget(String p_79001_, LootContextParam<? extends Entity> p_79002_) {
            this.name = p_79001_;
            this.param = p_79002_;
        }

        public LootContextParam<? extends Entity> getParam() {
            return this.param;
        }

        public static EntityTarget getByName(String p_79007_) {
            EntityTarget $$1 = CODEC.byName(p_79007_);
            if ($$1 != null) {
                return $$1;
            }
            throw new IllegalArgumentException("Invalid entity target " + p_79007_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(EntityTarget::values);
        }
    }

    public static class Builder {
        private final LootParams params;
        @Nullable
        private RandomSource random;

        public Builder(LootParams p_287628_) {
            this.params = p_287628_;
        }

        public Builder withOptionalRandomSeed(long p_78966_) {
            if (p_78966_ != 0L) {
                this.random = RandomSource.create(p_78966_);
            }
            return this;
        }

        public ServerLevel getLevel() {
            return this.params.getLevel();
        }

        public LootContext create(Optional<ResourceLocation> p_298622_) {
            ServerLevel $$1 = this.getLevel();
            MinecraftServer $$2 = $$1.getServer();
            RandomSource $$3 = Optional.ofNullable(this.random).or(() -> p_298622_.map($$1::getRandomSequence)).orElseGet($$1::getRandom);
            return new LootContext(this.params, $$3, $$2.reloadableRegistries().lookup());
        }
    }
}

