/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class LootParams {
    private final ServerLevel level;
    private final Map<LootContextParam<?>, Object> params;
    private final Map<ResourceLocation, DynamicDrop> dynamicDrops;
    private final float luck;

    public LootParams(ServerLevel p_287766_, Map<LootContextParam<?>, Object> p_287705_, Map<ResourceLocation, DynamicDrop> p_287642_, float p_287671_) {
        this.level = p_287766_;
        this.params = p_287705_;
        this.dynamicDrops = p_287642_;
        this.luck = p_287671_;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean hasParam(LootContextParam<?> p_287749_) {
        return this.params.containsKey(p_287749_);
    }

    public <T> T getParameter(LootContextParam<T> p_287670_) {
        Object $$1 = this.params.get(p_287670_);
        if ($$1 == null) {
            throw new NoSuchElementException(p_287670_.getName().toString());
        }
        return (T)$$1;
    }

    @Nullable
    public <T> T getOptionalParameter(LootContextParam<T> p_287644_) {
        return (T)this.params.get(p_287644_);
    }

    @Nullable
    public <T> T getParamOrNull(LootContextParam<T> p_287769_) {
        return (T)this.params.get(p_287769_);
    }

    public void addDynamicDrops(ResourceLocation p_287768_, Consumer<ItemStack> p_287711_) {
        DynamicDrop $$2 = this.dynamicDrops.get(p_287768_);
        if ($$2 != null) {
            $$2.add(p_287711_);
        }
    }

    public float getLuck() {
        return this.luck;
    }

    @FunctionalInterface
    public static interface DynamicDrop {
        public void add(Consumer<ItemStack> var1);
    }

    public static class Builder {
        private final ServerLevel level;
        private final Map<LootContextParam<?>, Object> params = Maps.newIdentityHashMap();
        private final Map<ResourceLocation, DynamicDrop> dynamicDrops = Maps.newHashMap();
        private float luck;

        public Builder(ServerLevel p_287594_) {
            this.level = p_287594_;
        }

        public ServerLevel getLevel() {
            return this.level;
        }

        public <T> Builder withParameter(LootContextParam<T> p_287706_, T p_287606_) {
            this.params.put(p_287706_, p_287606_);
            return this;
        }

        public <T> Builder withOptionalParameter(LootContextParam<T> p_287680_, @Nullable T p_287630_) {
            if (p_287630_ == null) {
                this.params.remove(p_287680_);
            } else {
                this.params.put(p_287680_, p_287630_);
            }
            return this;
        }

        public <T> T getParameter(LootContextParam<T> p_287646_) {
            Object $$1 = this.params.get(p_287646_);
            if ($$1 == null) {
                throw new NoSuchElementException(p_287646_.getName().toString());
            }
            return (T)$$1;
        }

        @Nullable
        public <T> T getOptionalParameter(LootContextParam<T> p_287759_) {
            return (T)this.params.get(p_287759_);
        }

        public Builder withDynamicDrop(ResourceLocation p_287734_, DynamicDrop p_287724_) {
            DynamicDrop $$2 = this.dynamicDrops.put(p_287734_, p_287724_);
            if ($$2 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + String.valueOf(this.dynamicDrops) + "'");
            }
            return this;
        }

        public Builder withLuck(float p_287703_) {
            this.luck = p_287703_;
            return this;
        }

        public LootParams create(LootContextParamSet p_287701_) {
            Sets.SetView $$1 = Sets.difference(this.params.keySet(), p_287701_.getAllowed());
            if (!$$1.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf($$1));
            }
            Sets.SetView $$2 = Sets.difference(p_287701_.getRequired(), this.params.keySet());
            if (!$$2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf($$2));
            }
            return new LootParams(this.level, this.params, this.dynamicDrops, this.luck);
        }
    }
}

