/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyNameFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyNameFunction> CODEC = RecordCodecBuilder.mapCodec(p_298065_ -> CopyNameFunction.commonFields(p_298065_).and((App)NameSource.CODEC.fieldOf("source").forGetter(p_298068_ -> p_298068_.source)).apply((Applicative)p_298065_, CopyNameFunction::new));
    private final NameSource source;

    private CopyNameFunction(List<LootItemCondition> p_298700_, NameSource p_80178_) {
        super(p_298700_);
        this.source = p_80178_;
    }

    public LootItemFunctionType<CopyNameFunction> getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack p_80185_, LootContext p_80186_) {
        Object $$2 = p_80186_.getParamOrNull(this.source.param);
        if ($$2 instanceof Nameable) {
            Nameable $$3 = (Nameable)$$2;
            p_80185_.set(DataComponents.CUSTOM_NAME, $$3.getCustomName());
        }
        return p_80185_;
    }

    public static LootItemConditionalFunction.Builder<?> copyName(NameSource p_80188_) {
        return CopyNameFunction.simpleBuilder(p_298067_ -> new CopyNameFunction((List<LootItemCondition>)p_298067_, p_80188_));
    }

    public static enum NameSource implements StringRepresentable
    {
        THIS("this", LootContextParams.THIS_ENTITY),
        KILLER("killer", LootContextParams.KILLER_ENTITY),
        KILLER_PLAYER("killer_player", LootContextParams.LAST_DAMAGE_PLAYER),
        BLOCK_ENTITY("block_entity", LootContextParams.BLOCK_ENTITY);

        public static final Codec<NameSource> CODEC;
        private final String name;
        final LootContextParam<?> param;

        private NameSource(String p_80206_, LootContextParam<?> p_80207_) {
            this.name = p_80206_;
            this.param = p_80207_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(NameSource::values);
        }
    }
}

