/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class EnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<HolderSet<Enchantment>> ENCHANTMENT_SET_CODEC = BuiltInRegistries.ENCHANTMENT.holderByNameCodec().listOf().xmap(HolderSet::direct, p_298082_ -> p_298082_.stream().toList());
    public static final MapCodec<EnchantRandomlyFunction> CODEC = RecordCodecBuilder.mapCodec(p_338140_ -> EnchantRandomlyFunction.commonFields(p_338140_).and((App)ENCHANTMENT_SET_CODEC.optionalFieldOf("enchantments").forGetter(p_298083_ -> p_298083_.enchantments)).apply((Applicative)p_338140_, EnchantRandomlyFunction::new));
    private final Optional<HolderSet<Enchantment>> enchantments;

    EnchantRandomlyFunction(List<LootItemCondition> p_299014_, Optional<HolderSet<Enchantment>> p_298965_) {
        super(p_299014_);
        this.enchantments = p_298965_;
    }

    public LootItemFunctionType<EnchantRandomlyFunction> getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack p_80429_, LootContext p_80430_) {
        RandomSource $$2 = p_80430_.getRandom();
        Optional $$3 = this.enchantments.flatMap(p_298077_ -> p_298077_.getRandomElement($$2)).or(() -> {
            boolean $$3 = p_80429_.is(Items.BOOK);
            List<Holder.Reference> $$4 = BuiltInRegistries.ENCHANTMENT.holders().filter(p_338136_ -> ((Enchantment)p_338136_.value()).isEnabled(p_80430_.getLevel().enabledFeatures())).filter(p_298078_ -> ((Enchantment)p_298078_.value()).isDiscoverable()).filter(p_298075_ -> $$3 || ((Enchantment)p_298075_.value()).canEnchant(p_80429_)).toList();
            return Util.getRandomSafe($$4, $$2);
        });
        if ($$3.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)p_80429_);
            return p_80429_;
        }
        return EnchantRandomlyFunction.enchantItem(p_80429_, (Enchantment)((Holder)$$3.get()).value(), $$2);
    }

    private static ItemStack enchantItem(ItemStack p_230980_, Enchantment p_230981_, RandomSource p_230982_) {
        int $$3 = Mth.nextInt(p_230982_, p_230981_.getMinLevel(), p_230981_.getMaxLevel());
        if (p_230980_.is(Items.BOOK)) {
            p_230980_ = new ItemStack(Items.ENCHANTED_BOOK);
        }
        p_230980_.enchant(p_230981_, $$3);
        return p_230980_;
    }

    public static Builder randomEnchantment() {
        return new Builder();
    }

    public static LootItemConditionalFunction.Builder<?> randomApplicableEnchantment() {
        return EnchantRandomlyFunction.simpleBuilder(p_298079_ -> new EnchantRandomlyFunction((List<LootItemCondition>)p_298079_, Optional.empty()));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<Holder<Enchantment>> enchantments = new ArrayList<Holder<Enchantment>>();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Enchantment p_80445_) {
            this.enchantments.add(p_80445_.builtInRegistryHolder());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new EnchantRandomlyFunction(this.getConditions(), this.enchantments.isEmpty() ? Optional.empty() : Optional.of(HolderSet.direct(this.enchantments)));
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

