/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.jetbrains.annotations.ApiStatus;

public abstract class ModelEvent
extends Event {
    @ApiStatus.Internal
    protected ModelEvent() {
    }

    public static class RegisterGeometryLoaders
    extends ModelEvent
    implements IModBusEvent {
        private final Map<ResourceLocation, IGeometryLoader<?>> loaders;

        @ApiStatus.Internal
        public RegisterGeometryLoaders(Map<ResourceLocation, IGeometryLoader<?>> loaders) {
            this.loaders = loaders;
        }

        public void register(ResourceLocation key, IGeometryLoader<?> loader) {
            Preconditions.checkArgument((!this.loaders.containsKey(key) ? 1 : 0) != 0, (Object)("Geometry loader already registered: " + String.valueOf(key)));
            this.loaders.put(key, loader);
        }
    }

    public static class RegisterAdditional
    extends ModelEvent
    implements IModBusEvent {
        private final Set<ResourceLocation> models;

        @ApiStatus.Internal
        public RegisterAdditional(Set<ResourceLocation> models) {
            this.models = models;
        }

        public void register(ResourceLocation model) {
            this.models.add(model);
        }
    }

    public static class BakingCompleted
    extends ModelEvent
    implements IModBusEvent {
        private final ModelManager modelManager;
        private final Map<ResourceLocation, BakedModel> models;
        private final ModelBakery modelBakery;

        @ApiStatus.Internal
        public BakingCompleted(ModelManager modelManager, Map<ResourceLocation, BakedModel> models, ModelBakery modelBakery) {
            this.modelManager = modelManager;
            this.models = models;
            this.modelBakery = modelBakery;
        }

        public ModelManager getModelManager() {
            return this.modelManager;
        }

        public Map<ResourceLocation, BakedModel> getModels() {
            return this.models;
        }

        public ModelBakery getModelBakery() {
            return this.modelBakery;
        }
    }

    public static class ModifyBakingResult
    extends ModelEvent
    implements IModBusEvent {
        private final Map<ResourceLocation, BakedModel> models;
        private final Function<Material, TextureAtlasSprite> textureGetter;
        private final ModelBakery modelBakery;

        @ApiStatus.Internal
        public ModifyBakingResult(Map<ResourceLocation, BakedModel> models, Function<Material, TextureAtlasSprite> textureGetter, ModelBakery modelBakery) {
            this.models = models;
            this.textureGetter = textureGetter;
            this.modelBakery = modelBakery;
        }

        public Map<ResourceLocation, BakedModel> getModels() {
            return this.models;
        }

        public Function<Material, TextureAtlasSprite> getTextureGetter() {
            return this.textureGetter;
        }

        public ModelBakery getModelBakery() {
            return this.modelBakery;
        }
    }
}

