/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public interface IAbstractMinecartExtension {
    public static final float DEFAULT_MAX_SPEED_AIR_LATERAL = 0.4f;
    public static final float DEFAULT_MAX_SPEED_AIR_VERTICAL = -1.0f;
    public static final double DEFAULT_AIR_DRAG = (double)0.95f;

    private AbstractMinecart self() {
        return (AbstractMinecart)this;
    }

    default public BlockPos getCurrentRailPosition() {
        int x = Mth.floor((double)this.self().getX());
        int y = Mth.floor((double)this.self().getY());
        int z = Mth.floor((double)this.self().getZ());
        BlockPos pos = new BlockPos(x, y, z);
        if (this.self().level().getBlockState(pos.below()).is(BlockTags.RAILS)) {
            pos = pos.below();
        }
        return pos;
    }

    public double getMaxSpeedWithRail();

    public void moveMinecartOnRail(BlockPos var1);

    public boolean canUseRail();

    public void setCanUseRail(boolean var1);

    default public boolean shouldDoRailFunctions() {
        return true;
    }

    default public boolean isPoweredCart() {
        return this.self().getMinecartType() == AbstractMinecart.Type.FURNACE;
    }

    default public boolean canBeRidden() {
        return this.self().getMinecartType() == AbstractMinecart.Type.RIDEABLE;
    }

    default public float getMaxCartSpeedOnRail() {
        return 1.2f;
    }

    public float getCurrentCartSpeedCapOnRail();

    public void setCurrentCartSpeedCapOnRail(float var1);

    public float getMaxSpeedAirLateral();

    public void setMaxSpeedAirLateral(float var1);

    public float getMaxSpeedAirVertical();

    public void setMaxSpeedAirVertical(float var1);

    public double getDragAir();

    public void setDragAir(double var1);

    default public double getSlopeAdjustment() {
        return 0.0078125;
    }

    default public int getComparatorLevel() {
        return -1;
    }
}

