/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items.wrapper;

import java.util.function.IntUnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SidedInvWrapper
implements IItemHandlerModifiable {
    protected final WorldlyContainer inv;
    @Nullable
    protected final Direction side;
    private final IntUnaryOperator slotLimit;
    private final InsertLimit newStackInsertLimit;

    public SidedInvWrapper(WorldlyContainer inv, @Nullable Direction side) {
        this.inv = inv;
        this.side = side;
        this.slotLimit = inv instanceof BrewingStandBlockEntity ? wrapperSlot -> SidedInvWrapper.getSlot(inv, wrapperSlot, side) < 3 ? 1 : inv.getMaxStackSize() : wrapperSlot -> inv.getMaxStackSize();
        this.newStackInsertLimit = inv instanceof AbstractFurnaceBlockEntity ? (wrapperSlot, invSlot, stack) -> invSlot == 1 && stack.is(Items.BUCKET) ? 1 : Math.min(stack.getMaxStackSize(), this.getSlotLimit(wrapperSlot)) : (wrapperSlot, invSlot, stack) -> Math.min(stack.getMaxStackSize(), this.getSlotLimit(wrapperSlot));
    }

    public static int getSlot(WorldlyContainer inv, int slot, @Nullable Direction side) {
        int[] slots = inv.getSlotsForFace(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedInvWrapper that = (SidedInvWrapper)o;
        return this.inv.equals((Object)that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
        return result;
    }

    @Override
    public int getSlots() {
        return this.inv.getSlotsForFace(this.side).length;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        int i = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? ItemStack.EMPTY : this.inv.getItem(i);
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.getItem(slot1);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.inv.canPlaceItemThroughFace(slot1, stack, this.side) || !this.inv.canPlaceItem(slot1, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.inv.canPlaceItemThroughFace(slot1, stack, this.side) || !this.inv.canPlaceItem(slot1, stack)) {
            return stack;
        }
        int m = this.newStackInsertLimit.limitInsert(slot, slot1, stack);
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.split(m));
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 != -1) {
            this.setInventorySlotContents(slot1, stack);
        }
    }

    private void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setChanged();
        this.inv.setItem(slot, stack);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.inv.getItem(slot1);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.inv.canTakeItemThroughFace(slot1, stackInSlot, this.side)) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack ret = this.inv.removeItem(slot1, m);
        this.inv.setChanged();
        return ret;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.slotLimit.applyAsInt(slot);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return slot1 == -1 ? false : this.inv.canPlaceItem(slot1, stack);
    }

    private static interface InsertLimit {
        public int limitInsert(int var1, int var2, ItemStack var3);
    }
}

