/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.moddiscovery.ModListHandler;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class MavenDirectoryLocator
implements IModFileCandidateLocator {
    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        List<String> mavenRoots = context.mavenRoots();
        List<Path> mavenRootPaths = mavenRoots.stream().map(n -> FMLPaths.GAMEDIR.get().resolve((String)n)).collect(Collectors.toList());
        List<String> mods = context.mods();
        List<String> listedMods = ModListHandler.processModLists(context.modLists(), mavenRootPaths);
        List modCoordinates = Stream.concat(mods.stream(), listedMods.stream()).toList();
        for (String modCoordinate : modCoordinates) {
            Path relativePath;
            try {
                relativePath = MavenCoordinate.parse(modCoordinate).toRelativeRepositoryPath();
            }
            catch (Exception e) {
                pipeline.addIssue(ModLoadingIssue.error("fml.modloading.invalid_maven_coordinate", modCoordinate).withCause(e));
                continue;
            }
            Optional<Path> path = mavenRootPaths.stream().map(root -> root.resolve(relativePath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
            if (path.isPresent()) {
                pipeline.addPath(path.get(), ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.ERROR);
                continue;
            }
            pipeline.addIssue(ModLoadingIssue.error("fml.modloading.maven_coordinate_not_found", modCoordinate, mavenRootPaths));
        }
    }

    public String toString() {
        return "maven libs";
    }
}

