/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.Target;
import net.neoforged.accesstransformer.TargetType;
import net.neoforged.accesstransformer.generated.AtLexer;
import net.neoforged.accesstransformer.generated.AtParser;
import net.neoforged.accesstransformer.parser.AccessTransformVisitor;
import net.neoforged.accesstransformer.parser.AtParserErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AccessTransformerList {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AXFORM");
    private static final Marker AXFORM_MARKER = MarkerFactory.getMarker((String)"AXFORM");
    private final Map<Target<?>, AccessTransformer> accessTransformers = new HashMap();
    private Set<Type> targetedClassCache = Collections.emptySet();

    public void loadFromResource(String resourceName) throws URISyntaxException, IOException {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(resourceName).toURI());
        this.loadFromPath(path);
    }

    public void loadFromPath(Path path) throws IOException {
        long size = Files.size(path);
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
            this.loadAT((CharStream)CharStreams.fromChannel((ReadableByteChannel)channel, (Charset)StandardCharsets.UTF_8, (int)4096, (CodingErrorAction)CodingErrorAction.REPLACE, (String)path.getFileName().toString(), (long)size));
        }
    }

    public void loadAT(CharStream stream) {
        LOGGER.debug(AXFORM_MARKER, "Loading access transformer {}", (Object)stream.getSourceName());
        AtLexer lexer = new AtLexer(stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        AtParser parser = new AtParser((TokenStream)tokenStream);
        parser.addErrorListener((ANTLRErrorListener)new AtParserErrorListener());
        AtParser.FileContext file = parser.file();
        AccessTransformVisitor accessTransformVisitor = new AccessTransformVisitor(stream.getSourceName());
        file.accept(accessTransformVisitor);
        HashMap localATCopy = new HashMap(this.accessTransformers);
        this.mergeAccessTransformers(accessTransformVisitor.getAccessTransformers(), localATCopy, stream.getSourceName());
        List<AccessTransformer> invalidTransformers = this.invalidTransformers(localATCopy);
        if (!invalidTransformers.isEmpty()) {
            invalidTransformers.forEach(at -> LOGGER.error(AXFORM_MARKER, "Invalid access transform final state for target {}. Referred in resources {}.", at.getTarget(), at.getOrigins()));
            throw new IllegalArgumentException("Invalid AT final conflicts");
        }
        this.accessTransformers.clear();
        this.accessTransformers.putAll(localATCopy);
        this.targetedClassCache = this.accessTransformers.keySet().stream().map(Target::getASMType).collect(Collectors.toSet());
        LOGGER.debug(AXFORM_MARKER, "Loaded access transformer {}", (Object)stream.getSourceName());
    }

    private void mergeAccessTransformers(List<AccessTransformer> atList, Map<Target<?>, AccessTransformer> accessTransformers, String resourceName) {
        atList.forEach(at -> accessTransformers.merge(at.getTarget(), (AccessTransformer)at, (accessTransformer, at2) -> accessTransformer.mergeStates((AccessTransformer)at2, resourceName)));
    }

    private List<AccessTransformer> invalidTransformers(HashMap<Target<?>, AccessTransformer> accessTransformers) {
        return accessTransformers.values().stream().filter(e -> !e.isValid()).collect(Collectors.toList());
    }

    public Map<String, List<AccessTransformer>> getAccessTransformers() {
        return this.accessTransformers.entrySet().stream().collect(Collectors.groupingBy(e -> ((AccessTransformer)e.getValue()).getTarget().getClassName(), HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public boolean containsClassTarget(Type type) {
        return this.getTargets().contains(type);
    }

    public Set<Type> getTargets() {
        return this.targetedClassCache;
    }

    public Map<TargetType, Map<String, AccessTransformer>> getTransformersForTarget(Type type) {
        return this.accessTransformers.entrySet().stream().filter(e -> type.equals((Object)((Target)e.getKey()).getASMType())).map(Map.Entry::getValue).collect(Collectors.groupingBy(o -> o.getTarget().getType(), HashMap::new, Collectors.toMap(at -> at.getTarget().targetName(), Function.identity())));
    }
}

