/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modId;
    protected final String namespace;
    protected final IModInfo modInfo;
    protected final Map<Class<? extends IExtensionPoint>, Supplier<?>> extensionPoints = new IdentityHashMap();
    protected final EnumMap<ModConfig.Type, ModConfig> configs = new EnumMap(ModConfig.Type.class);

    public ModContainer(IModInfo info) {
        this.namespace = this.modId = info.getModId();
        this.modInfo = info;
    }

    public final String getModId() {
        return this.modId;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public IModInfo getModInfo() {
        return this.modInfo;
    }

    public <T extends IExtensionPoint> Optional<T> getCustomExtension(Class<T> point) {
        return Optional.ofNullable((IExtensionPoint)this.extensionPoints.getOrDefault(point, () -> null).get());
    }

    public <T extends IExtensionPoint> void registerExtensionPoint(Class<T> point, T extension) {
        this.extensionPoints.put(point, () -> extension);
    }

    public <T extends IExtensionPoint> void registerExtensionPoint(Class<T> point, Supplier<T> extension) {
        this.extensionPoints.put(point, extension);
    }

    public void addConfig(ModConfig modConfig) {
        this.configs.put(modConfig.getType(), modConfig);
        if (modConfig.getType() == ModConfig.Type.STARTUP) {
            ConfigTracker.INSTANCE.openConfig(modConfig, FMLPaths.CONFIGDIR.get(), null);
        }
    }

    public void registerConfig(ModConfig.Type type, IConfigSpec<?> configSpec) {
        if (configSpec.isEmpty()) {
            LOGGER.debug("Attempted to register an empty config for type {} on mod {}", (Object)type, (Object)this.modId);
            return;
        }
        this.addConfig(new ModConfig(type, configSpec, this));
    }

    public void registerConfig(ModConfig.Type type, IConfigSpec<?> configSpec, String fileName) {
        if (configSpec.isEmpty()) {
            LOGGER.debug("Attempted to register an empty config for type {} on mod {} using file name {}", (Object)type, (Object)this.modId, (Object)fileName);
            return;
        }
        this.addConfig(new ModConfig(type, configSpec, this, fileName));
    }

    @ApiStatus.OverrideOnly
    protected void constructMod() {
    }

    @Nullable
    public abstract IEventBus getEventBus();

    public final <T extends Event> void acceptEvent(T e) {
        IEventBus bus = this.getEventBus();
        if (bus == null) {
            return;
        }
        try {
            LOGGER.trace(Logging.LOADING, "Firing event for modid {} : {}", (Object)this.getModId(), e);
            bus.post(e);
            LOGGER.trace(Logging.LOADING, "Fired event for modid {} : {}", (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.errorduringevent", e.getClass().getName()).withAffectedMod(this.modInfo).withCause(t));
        }
    }

    public final <T extends Event> void acceptEvent(EventPriority phase, T e) {
        IEventBus bus = this.getEventBus();
        if (bus == null) {
            return;
        }
        try {
            LOGGER.trace(Logging.LOADING, "Firing event for phase {} for modid {} : {}", (Object)phase, (Object)this.getModId(), e);
            bus.post(phase, e);
            LOGGER.trace(Logging.LOADING, "Fired event for phase {} for modid {} : {}", (Object)phase, (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.errorduringevent", e.getClass().getName()).withAffectedMod(this.modInfo).withCause(t));
        }
    }
}

