/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.DeferredWorkQueue;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.ForgeFeature;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

public final class ModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ModLoadingIssue> loadingIssues = new ArrayList<ModLoadingIssue>();
    private static ModList modList;

    private ModLoader() {
    }

    private static String computeLanguageList() {
        return "\n" + FMLLoader.getLanguageLoadingProvider().applyForEach(lp -> lp.name() + "@" + lp.getClass().getPackage().getImplementationVersion()).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    private static String computeModLauncherServiceList() {
        List<Map<String, String>> mods = FMLLoader.modLauncherModList();
        return "\n" + mods.stream().map(mod -> mod.getOrDefault("file", "nofile") + " " + mod.getOrDefault("name", "missing") + " " + mod.getOrDefault("type", "NOTYPE") + " " + mod.getOrDefault("description", "")).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    public static void gatherAndInitializeMods(Executor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        LoadingModList loadingModList = FMLLoader.getLoadingModList();
        loadingIssues.addAll(loadingModList.getModLoadingIssues());
        ForgeFeature.registerFeature("javaVersion", ForgeFeature.VersionFeatureTest.forVersionString(IModInfo.DependencySide.BOTH, System.getProperty("java.version")));
        ForgeFeature.registerFeature("openGLVersion", ForgeFeature.VersionFeatureTest.forVersionString(IModInfo.DependencySide.CLIENT, ImmediateWindowHandler.getGLVersion()));
        FMLLoader.backgroundScanHandler.waitForScanToComplete(periodicTask);
        ModList modList = ModList.of(loadingModList.getModFiles().stream().map(ModFileInfo::getFile).toList(), loadingModList.getMods());
        if (ModLoader.hasErrors()) {
            List<ModLoadingIssue> loadingErrors = ModLoader.getLoadingErrors();
            for (ModLoadingIssue loadingError : loadingErrors) {
                LOGGER.fatal(Logging.CORE, "Error during pre-loading phase: {}", (Object)loadingError, (Object)loadingError.cause());
            }
            ModLoader.cancelLoading(modList);
            throw new ModLoadingException(loadingIssues);
        }
        List<ForgeFeature.Bound> failedBounds = loadingModList.getMods().stream().map(ModInfo::getForgeFeatures).flatMap(Collection::stream).filter(bound -> !ForgeFeature.testFeature(FMLEnvironment.dist, bound)).toList();
        if (!failedBounds.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to validate feature bounds for mods: {}", failedBounds);
            for (ForgeFeature.Bound fb : failedBounds) {
                loadingIssues.add(ModLoadingIssue.error("fml.modloading.feature.missing", fb, ForgeFeature.featureValue(fb)).withAffectedMod(fb.modInfo()));
            }
            ModLoader.cancelLoading(modList);
            throw new ModLoadingException(loadingIssues);
        }
        List<ModContainer> modContainers = loadingModList.getModFiles().stream().map(ModFileInfo::getFile).map(ModLoader::buildMods).mapMulti(Iterable::forEach).toList();
        if (ModLoader.hasErrors()) {
            for (ModLoadingIssue loadingError : ModLoader.getLoadingErrors()) {
                LOGGER.fatal(Logging.CORE, "Failed to initialize mod containers: {}", (Object)loadingError, (Object)loadingError.cause());
            }
            ModLoader.cancelLoading(modList);
            throw new ModLoadingException(loadingIssues);
        }
        modList.setLoadedMods(modContainers);
        ModLoader.modList = modList;
        ModLoader.constructMods(syncExecutor, parallelExecutor, periodicTask);
    }

    private static void cancelLoading(ModList modList) {
        StartupNotificationManager.modLoaderMessage("ERROR DURING MOD LOADING");
        modList.setLoadedMods(Collections.emptyList());
    }

    private static void constructMods(Executor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        DeferredWorkQueue workQueue = new DeferredWorkQueue("Mod Construction");
        ModLoader.dispatchParallelTask("Mod Construction", parallelExecutor, periodicTask, modContainer -> {
            modContainer.constructMod();
            modContainer.acceptEvent(new FMLConstructModEvent((ModContainer)modContainer, workQueue));
        });
        ModLoader.waitForTask("Mod Construction: Deferred Queue", periodicTask, CompletableFuture.runAsync(workQueue::runTasks, syncExecutor));
    }

    public static void runInitTask(String name, Executor syncExecutor, Runnable periodicTask, Runnable initTask) {
        ModLoader.waitForTask(name, periodicTask, CompletableFuture.runAsync(initTask, syncExecutor));
    }

    public static void dispatchParallelEvent(String name, Executor syncExecutor, Executor parallelExecutor, Runnable periodicTask, BiFunction<ModContainer, DeferredWorkQueue, ParallelDispatchEvent> eventConstructor) {
        DeferredWorkQueue workQueue = new DeferredWorkQueue(name);
        ModLoader.dispatchParallelTask(name, parallelExecutor, periodicTask, modContainer -> modContainer.acceptEvent((ParallelDispatchEvent)eventConstructor.apply((ModContainer)modContainer, workQueue)));
        ModLoader.runInitTask(name + ": Deferred Queue", syncExecutor, periodicTask, workQueue::runTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForTask(String name, Runnable periodicTask, CompletableFuture<?> future) {
        ProgressMeter progress = StartupNotificationManager.addProgressBar(name, 0);
        try {
            ModLoader.waitForFuture(name, periodicTask, future);
        }
        finally {
            progress.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatchParallelTask(String name, Executor parallelExecutor, Runnable periodicTask, Consumer<ModContainer> task) {
        ProgressMeter progress = StartupNotificationManager.addProgressBar(name, modList.size());
        try {
            periodicTask.run();
            IdentityHashMap modFutures = new IdentityHashMap(modList.size());
            List<CompletableFuture> futureList = modList.getSortedMods().stream().map(modContainer -> {
                CompletableFuture[] depFutures = (CompletableFuture[])LoadingModList.get().getDependencies(modContainer.getModInfo()).stream().map(modInfo -> {
                    CompletableFuture future = (CompletableFuture)modFutures.get(modInfo);
                    if (future == null) {
                        throw new IllegalStateException("Dependency future for mod %s which is a dependency of %s not found!".formatted(modInfo.getModId(), modContainer.getModId()));
                    }
                    return future;
                }).toArray(CompletableFuture[]::new);
                CompletionStage future = CompletableFuture.allOf(depFutures).handleAsync((void_, exception) -> {
                    if (exception != null) {
                        LOGGER.debug("Skipping {} task for mod {} because a dependency threw an exception.", (Object)name, (Object)modContainer.getModId());
                        progress.increment();
                        throw new DependentFutureFailedException();
                    }
                    try {
                        ModLoadingContext.get().setActiveContainer((ModContainer)modContainer);
                        task.accept((ModContainer)modContainer);
                    }
                    finally {
                        progress.increment();
                        ModLoadingContext.get().setActiveContainer(null);
                    }
                    return null;
                }, parallelExecutor);
                modFutures.put(modContainer.getModInfo(), future);
                return future;
            }).toList();
            CompletionStage singleFuture = ModList.gather(futureList).thenCompose(ModList::completableFutureFromExceptionList);
            ModLoader.waitForFuture(name, periodicTask, singleFuture);
        }
        finally {
            progress.complete();
        }
    }

    private static void waitForFuture(String name, Runnable periodicTask, CompletableFuture<?> future) {
        while (true) {
            periodicTask.run();
            try {
                future.get(50L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (ExecutionException e) {
                int issueCountBefore = loadingIssues.size();
                if (ModLoader.isMeaningfulException(e.getCause())) {
                    ModLoader.addLoadingIssuesFromException(name, e.getCause());
                }
                for (Throwable error : e.getCause().getSuppressed()) {
                    if (error instanceof DependentFutureFailedException) continue;
                    ModLoader.addLoadingIssuesFromException(name, error);
                }
                if (loadingIssues.isEmpty()) {
                    ModLoader.addLoadingIssuesFromException(name, e.getCause());
                }
                int errorCount = loadingIssues.size() - issueCountBefore;
                LOGGER.fatal(Logging.LOADING, "Failed to wait for future {}, {} errors found", (Object)name, (Object)errorCount);
                ModLoader.cancelLoading(modList);
                throw new ModLoadingException(loadingIssues);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static boolean isMeaningfulException(Throwable error) {
        String message = error.getLocalizedMessage();
        if (message != null && !message.isBlank()) {
            return true;
        }
        return !error.getClass().isAssignableFrom(RuntimeException.class) && !error.getClass().isAssignableFrom(IllegalStateException.class) && !error.getClass().isAssignableFrom(IllegalArgumentException.class);
    }

    private static void addLoadingIssuesFromException(String context, Throwable error) {
        if (error instanceof ModLoadingException) {
            ModLoadingException modLoadingException = (ModLoadingException)error;
            loadingIssues.addAll(modLoadingException.getIssues());
        } else {
            loadingIssues.add(ModLoadingIssue.error("fml.modloading.uncaughterror", context).withCause(error));
        }
    }

    private static List<ModContainer> buildMods(IModFile modFile) {
        IdentityHashMap<IModLanguageLoader, Set> byLoader = new IdentityHashMap<IModLanguageLoader, Set>();
        List<ModContainer> containers = modFile.getModFileInfo().getMods().stream().map(info -> {
            ModContainer container = ModLoader.buildModContainerFromTOML(info, modFile.getScanResult());
            Set cont = byLoader.computeIfAbsent(info.getLoader(), k -> new HashSet());
            if (container != null) {
                cont.add(container);
            }
            return container;
        }).filter(Objects::nonNull).toList();
        byLoader.forEach((loader, loaded) -> loader.validate(modFile, (Collection<ModContainer>)loaded, ModLoader::addLoadingIssue));
        return containers;
    }

    private static ModContainer buildModContainerFromTOML(IModInfo modInfo, ModFileScanData scanData) {
        try {
            return modInfo.getLoader().loadMod(modInfo, scanData, FMLLoader.getGameLayer());
        }
        catch (ModLoadingException mle) {
            loadingIssues.addAll(mle.getIssues());
            return null;
        }
    }

    public static <T extends Event> void runEventGenerator(Function<ModContainer, T> generator) {
        if (ModLoader.hasErrors()) {
            LOGGER.error("Cowardly refusing to send event generator to a broken mod state");
            return;
        }
        List<ModContainer> modContainers = ModList.get().getSortedMods();
        ArrayList events = new ArrayList(modContainers.size());
        ModList.get().forEachModInOrder(mc -> events.add((Event)generator.apply((ModContainer)mc)));
        for (EventPriority phase : EventPriority.values()) {
            for (int i = 0; i < modContainers.size(); ++i) {
                modContainers.get(i).acceptEvent(phase, (Event)events.get(i));
            }
        }
    }

    public static <T extends Event> void postEvent(T e) {
        if (ModLoader.hasErrors()) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        for (EventPriority phase : EventPriority.values()) {
            ModList.get().forEachModInOrder(mc -> mc.acceptEvent(phase, e));
        }
    }

    public static <T extends Event> T postEventWithReturn(T e) {
        ModLoader.postEvent(e);
        return e;
    }

    public static <T extends Event> void postEventWrapContainerInModOrder(T event) {
        ModLoader.postEventWithWrapInModOrder(event, (mc, e) -> ModLoadingContext.get().setActiveContainer((ModContainer)mc), (mc, e) -> ModLoadingContext.get().setActiveContainer(null));
    }

    public static <T extends Event> void postEventWithWrapInModOrder(T e, BiConsumer<ModContainer, T> pre, BiConsumer<ModContainer, T> post) {
        if (ModLoader.hasErrors()) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        for (EventPriority phase : EventPriority.values()) {
            ModList.get().forEachModInOrder(mc -> {
                pre.accept((ModContainer)mc, e);
                mc.acceptEvent(phase, e);
                post.accept((ModContainer)mc, e);
            });
        }
    }

    public static boolean hasErrors() {
        return !loadingIssues.isEmpty() && loadingIssues.stream().anyMatch(issue -> issue.severity() == ModLoadingIssue.Severity.ERROR);
    }

    @ApiStatus.Internal
    public static List<ModLoadingIssue> getLoadingErrors() {
        return loadingIssues.stream().filter(issue -> issue.severity() == ModLoadingIssue.Severity.ERROR).toList();
    }

    @ApiStatus.Internal
    public static List<ModLoadingIssue> getLoadingWarnings() {
        return loadingIssues.stream().filter(issue -> issue.severity() == ModLoadingIssue.Severity.WARNING).toList();
    }

    @ApiStatus.Internal
    public static List<ModLoadingIssue> getLoadingIssues() {
        return List.copyOf(loadingIssues);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static void clearLoadingIssues() {
        LOGGER.info("Clearing {} loading issues", (Object)loadingIssues.size());
        loadingIssues.clear();
    }

    @ApiStatus.Internal
    public static void addLoadingIssue(ModLoadingIssue issue) {
        loadingIssues.add(issue);
    }

    static {
        CrashReportCallables.registerCrashCallable("ModLauncher", FMLLoader::getLauncherInfo);
        CrashReportCallables.registerCrashCallable("ModLauncher launch target", FMLLoader::launcherHandlerName);
        CrashReportCallables.registerCrashCallable("ModLauncher services", ModLoader::computeModLauncherServiceList);
        CrashReportCallables.registerCrashCallable("FML Language Providers", ModLoader::computeLanguageList);
    }

    private static class DependentFutureFailedException
    extends RuntimeException {
        private DependentFutureFailedException() {
        }
    }
}

