/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.jarjar.selection.JarSelector;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import net.neoforged.neoforgespi.locating.ModFileLoadingException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class JarInJarDependencyLocator
implements IDependencyLocator {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public void scanMods(List<IModFile> loadedMods, IDiscoveryPipeline pipeline) {
        List dependenciesToLoad = JarSelector.detectAndSelect(loadedMods, this::loadResourceFromModFile, (file, path) -> this.loadModFileFrom((IModFile)file, (Path)path, pipeline), this::identifyMod, this::exception);
        if (dependenciesToLoad.isEmpty()) {
            LOGGER.info("No dependencies to load found. Skipping!");
        } else {
            LOGGER.info("Found {} dependencies adding them to mods collection", (Object)dependenciesToLoad.size());
            for (IModFile modFile : dependenciesToLoad) {
                pipeline.addModFile(modFile);
            }
        }
    }

    protected Optional<IModFile> loadModFileFrom(IModFile file, Path path, IDiscoveryPipeline pipeline) {
        try {
            Path pathInModFile = file.findResource(path.toString());
            URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
            ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
            FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
            JarContents jar = JarContents.of((Path)zipFS.getPath("/", new String[0]));
            IModFile providerResult = pipeline.readModFile(jar, ModFileDiscoveryAttributes.DEFAULT.withParent(file));
            return Optional.ofNullable(providerResult);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mod file {} from {}", (Object)path, (Object)file.getFileName());
            ModFileLoadingException exception = new ModFileLoadingException("Failed to load mod file " + file.getFileName());
            exception.initCause(e);
            throw exception;
        }
    }

    protected ModLoadingException exception(Collection<JarSelector.ResolutionFailureInformation<IModFile>> failedDependencies) {
        List<ModLoadingIssue> errors = failedDependencies.stream().filter(entry -> !entry.sources().isEmpty()).map(this::buildExceptionData).toList();
        return new ModLoadingException(errors);
    }

    private ModLoadingIssue buildExceptionData(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        String artifact = entry.identifier().group() + ":" + entry.identifier().artifact();
        String requestedBy = entry.sources().stream().flatMap(this::getModWithVersionRangeStream).map(this::formatError).collect(Collectors.joining(", "));
        return ModLoadingIssue.error(this.getErrorTranslationKey(entry), artifact, requestedBy);
    }

    private String getErrorTranslationKey(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return entry.failureReason() == JarSelector.FailureReason.VERSION_RESOLUTION_FAILED ? "fml.dependencyloading.conflictingdependencies" : "fml.dependencyloading.mismatchedcontaineddependencies";
    }

    private Stream<ModWithVersionRange> getModWithVersionRangeStream(JarSelector.SourceWithRequestedVersionRange<IModFile> file) {
        return file.sources().stream().map(IModFile::getModFileInfo).flatMap(modFileInfo -> modFileInfo.getMods().stream()).map(modInfo -> new ModWithVersionRange((IModInfo)modInfo, file.requestedVersionRange(), file.includedVersion()));
    }

    private String formatError(ModWithVersionRange modWithVersionRange) {
        return "\u00a7e" + modWithVersionRange.modInfo().getModId() + "\u00a7r - \u00a74" + modWithVersionRange.versionRange().toString() + "\u00a74 - \u00a72" + modWithVersionRange.artifactVersion().toString() + "\u00a72";
    }

    protected String identifyMod(IModFile modFile) {
        if (modFile.getModFileInfo() == null || modFile.getModInfos().isEmpty()) {
            return modFile.getFileName();
        }
        return modFile.getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining());
    }

    protected Optional<InputStream> loadResourceFromModFile(IModFile modFile, Path path) {
        try {
            return Optional.of(Files.newInputStream(modFile.findResource(path.toString()), new OpenOption[0]));
        }
        catch (NoSuchFileException e) {
            LOGGER.trace("Failed to load resource {} from {}, it does not contain dependency information.", (Object)path, (Object)modFile.getFileName());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load resource {} from mod {}, cause {}", new Object[]{path, modFile.getFileName(), e});
            return Optional.empty();
        }
    }

    public String toString() {
        return "jarinjar";
    }

    private record ModWithVersionRange(IModInfo modInfo, VersionRange versionRange, ArtifactVersion artifactVersion) {
    }
}

