/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.locators.MinecraftModInfo;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;

public class ProductionClientProvider
implements IModFileCandidateLocator {
    private final List<MavenCoordinate> additionalContent;

    public ProductionClientProvider(List<MavenCoordinate> additionalContent) {
        this.additionalContent = additionalContent;
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        VersionInfo vers = FMLLoader.versionInfo();
        ArrayList<Path> content = new ArrayList<Path>();
        ProductionClientProvider.addRequiredLibrary(new MavenCoordinate("net.minecraft", "client", "", "srg", vers.mcAndNeoFormVersion()), content);
        ProductionClientProvider.addRequiredLibrary(new MavenCoordinate("net.minecraft", "client", "", "extra", vers.mcAndNeoFormVersion()), content);
        for (MavenCoordinate artifact : this.additionalContent) {
            ProductionClientProvider.addRequiredLibrary(artifact, content);
        }
        try {
            JarContents mcJarContents = JarContents.of(content);
            ModJarMetadata mcJarMetadata = new ModJarMetadata(mcJarContents);
            SecureJar mcSecureJar = SecureJar.from((JarContents)mcJarContents, (JarMetadata)mcJarMetadata);
            IModFile mcjar = IModFile.create(mcSecureJar, MinecraftModInfo::buildMinecraftModInfo);
            mcJarMetadata.setModFile(mcjar);
            pipeline.addModFile(mcjar);
        }
        catch (Exception e) {
            pipeline.addIssue(ModLoadingIssue.error("fml.modloading.corrupted_installation", new Object[0]).withCause(e));
        }
    }

    private static void addRequiredLibrary(MavenCoordinate coordinate, List<Path> content) {
        Path path = LibraryFinder.findPathForMaven(coordinate);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.corrupted_installation", new Object[0]).withAffectedPath(path));
        }
        content.add(path);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("production client provider");
        for (MavenCoordinate mavenCoordinate : this.additionalContent) {
            result.append(" +").append(mavenCoordinate);
        }
        return result.toString();
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

