/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.fml.earlydisplay.ColourScheme;
import net.neoforged.fml.earlydisplay.EarlyFramebuffer;
import net.neoforged.fml.earlydisplay.ElementShader;
import net.neoforged.fml.earlydisplay.PerformanceInfo;
import net.neoforged.fml.earlydisplay.RenderElement;
import net.neoforged.fml.earlydisplay.STBHelper;
import net.neoforged.fml.earlydisplay.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.SimpleFont;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayWindow
implements ImmediateWindowProvider {
    private static final int[][] GL_VERSIONS = new int[][]{{4, 6}, {4, 5}, {4, 4}, {4, 3}, {4, 2}, {4, 1}, {4, 0}, {3, 3}, {3, 2}};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EARLYDISPLAY");
    private final AtomicBoolean animationTimerTrigger = new AtomicBoolean(true);
    private ColourScheme colourScheme;
    private ElementShader elementShader;
    private RenderElement.DisplayContext context;
    private List<RenderElement> elements;
    private int framecount;
    private EarlyFramebuffer framebuffer;
    private ScheduledFuture<?> windowTick;
    private ScheduledFuture<?> initializationFuture;
    private PerformanceInfo performanceInfo;
    private ScheduledFuture<?> performanceTick;
    private long window;
    private ScheduledExecutorService renderScheduler;
    private int fbWidth;
    private int fbHeight;
    private int fbScale;
    private int winWidth;
    private int winHeight;
    private int winX;
    private int winY;
    private final Semaphore renderLock = new Semaphore(1);
    private boolean maximized;
    private String glVersion;
    private SimpleFont font;
    private Runnable repaintTick = () -> {};
    private static final long MINFRAMETIME = TimeUnit.MILLISECONDS.toNanos(10L);
    private long nextFrameTime = 0L;
    private static final String ERROR_URL = "https://links.neoforged.net/early-display-errors";
    private Method loadingOverlay;

    public String name() {
        return "fmlearlywindow";
    }

    public Runnable initialize(String[] arguments) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec mcversionopt = parser.accepts("fml.mcVersion").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec forgeversionopt = parser.accepts("fml.neoForgeVersion").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec widthopt = parser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec heightopt = parser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT), (Object[])new Integer[0]);
        OptionSpecBuilder maximizedopt = parser.accepts("earlywindow.maximized");
        parser.allowsUnrecognizedOptions();
        OptionSet parsed = parser.parse(arguments);
        this.winWidth = (Integer)parsed.valueOf((OptionSpec)widthopt);
        this.winHeight = (Integer)parsed.valueOf((OptionSpec)heightopt);
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH, (Object)this.winWidth);
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT, (Object)this.winHeight);
        this.fbScale = FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_FBSCALE);
        if (System.getenv("FML_EARLY_WINDOW_DARK") != null) {
            this.colourScheme = ColourScheme.BLACK;
        } else {
            try {
                List<String> optionLines = Files.readAllLines(FMLPaths.GAMEDIR.get().resolve(Paths.get("options.txt", new String[0])));
                Map<String, String> options = optionLines.stream().map(l -> l.split(":")).filter(a -> ((String[])a).length == 2).collect(Collectors.toMap(a -> a[0], a -> a[1]));
                boolean colourScheme = Boolean.parseBoolean(options.getOrDefault("darkMojangStudiosBackground", "false"));
                this.colourScheme = colourScheme ? ColourScheme.BLACK : ColourScheme.RED;
            }
            catch (IOException ioe) {
                this.colourScheme = ColourScheme.RED;
            }
        }
        this.maximized = parsed.has((OptionSpec)maximizedopt) || FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_MAXIMIZED);
        String forgeVersion = (String)parsed.valueOf((OptionSpec)forgeversionopt);
        StartupNotificationManager.modLoaderConsumer().ifPresent(c -> c.accept("NeoForge loading " + forgeVersion));
        this.performanceInfo = new PerformanceInfo();
        return this.start((String)parsed.valueOf((OptionSpec)mcversionopt), forgeVersion);
    }

    private void renderThreadFunc() {
        if (!this.renderLock.tryAcquire()) {
            return;
        }
        try {
            long nt = System.nanoTime();
            if (nt < this.nextFrameTime) {
                return;
            }
            this.nextFrameTime = nt + MINFRAMETIME;
            GLFW.glfwMakeContextCurrent((long)this.window);
            this.framebuffer.activate();
            GL32C.glViewport((int)0, (int)0, (int)this.context.scaledWidth(), (int)this.context.scaledHeight());
            this.context.elementShader().activate();
            this.context.elementShader().updateScreenSizeUniform(this.context.scaledWidth(), this.context.scaledHeight());
            GL32C.glClearColor((float)this.colourScheme.background().redf(), (float)this.colourScheme.background().greenf(), (float)this.colourScheme.background().bluef(), (float)1.0f);
            this.paintFramebuffer();
            this.context.elementShader().clear();
            this.framebuffer.deactivate();
            GL32C.glViewport((int)0, (int)0, (int)this.fbWidth, (int)this.fbHeight);
            this.framebuffer.draw(this.fbWidth, this.fbHeight);
            GLFW.glfwSwapBuffers((long)this.window);
        }
        catch (Throwable t) {
            LOGGER.error("BARF", t);
        }
        finally {
            if (this.windowTick != null) {
                GLFW.glfwMakeContextCurrent((long)0L);
            }
            this.renderLock.release();
        }
    }

    private void initRender(@Nullable String mcVersion, String forgeVersion) {
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GL.createCapabilities();
        LOGGER.info("GL info: " + GL32C.glGetString((int)7937) + " GL version " + GL32C.glGetString((int)7938) + ", " + GL32C.glGetString((int)7936));
        this.elementShader = new ElementShader();
        try {
            this.elementShader.init();
        }
        catch (Throwable t) {
            LOGGER.error("Crash during shader initialization", t);
            this.crashElegantly("An error occurred initializing shaders.");
        }
        GL32C.glClearColor((float)this.colourScheme.background().redf(), (float)this.colourScheme.background().greenf(), (float)this.colourScheme.background().bluef(), (float)1.0f);
        this.context = new RenderElement.DisplayContext(854, 480, this.fbScale, this.elementShader, this.colourScheme, this.performanceInfo);
        this.framebuffer = new EarlyFramebuffer(this.context);
        try {
            this.font = new SimpleFont("Monocraft.ttf", this.fbScale, 200000, 6);
        }
        catch (Throwable t) {
            LOGGER.error("Crash during font initialization", t);
            this.crashElegantly("An error occurred initializing a font for rendering. " + t.getMessage());
        }
        this.elements = new ArrayList<RenderElement>(Arrays.asList(RenderElement.fox(this.font), RenderElement.logMessageOverlay(this.font), RenderElement.forgeVersionOverlay(this.font, mcVersion + "-" + forgeVersion.split("-")[0]), RenderElement.performanceBar(this.font), RenderElement.progressBars(this.font)));
        Calendar date = Calendar.getInstance();
        if (FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_SQUIR) || date.get(2) == 3 && date.get(5) == 1) {
            this.elements.add(0, RenderElement.squir());
        }
        GL32C.glEnable((int)3042);
        GL32C.glBlendFunc((int)770, (int)771);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.windowTick = this.renderScheduler.scheduleAtFixedRate(this::renderThreadFunc, 50L, 50L, TimeUnit.MILLISECONDS);
        this.performanceTick = this.renderScheduler.scheduleAtFixedRate(this.performanceInfo::update, 0L, 500L, TimeUnit.MILLISECONDS);
        this.renderScheduler.scheduleAtFixedRate(() -> this.animationTimerTrigger.set(true), 1L, 50L, TimeUnit.MILLISECONDS);
    }

    void paintFramebuffer() {
        GL32C.glClear((int)16640);
        GL32C.glEnable((int)3042);
        GL32C.glBlendFunc((int)770, (int)771);
        this.elements.removeIf(element -> !element.render(this.context, this.framecount));
        if (this.animationTimerTrigger.compareAndSet(true, false)) {
            ++this.framecount;
        }
    }

    public void render(int alpha) {
        int currentVAO = GL32C.glGetInteger((int)34229);
        int currentFB = GL32C.glGetInteger((int)36010);
        GL32C.glViewport((int)0, (int)0, (int)this.context.scaledWidth(), (int)this.context.scaledHeight());
        RenderElement.globalAlpha = alpha;
        this.framebuffer.activate();
        GL32C.glClearColor((float)this.colourScheme.background().redf(), (float)this.colourScheme.background().greenf(), (float)this.colourScheme.background().bluef(), (float)((float)alpha / 255.0f));
        this.elementShader.activate();
        this.elementShader.updateScreenSizeUniform(this.context.scaledWidth(), this.context.scaledHeight());
        this.paintFramebuffer();
        this.elementShader.clear();
        this.framebuffer.deactivate();
        GL32C.glBindVertexArray((int)currentVAO);
        GL32C.glBindFramebuffer((int)36160, (int)currentFB);
    }

    public Runnable start(@Nullable String mcVersion, String forgeVersion) {
        this.renderScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.initWindow(mcVersion);
        this.initializationFuture = this.renderScheduler.schedule(() -> this.initRender(mcVersion, forgeVersion), 1L, TimeUnit.MILLISECONDS);
        return this::periodicTick;
    }

    public String getGLVersion() {
        return this.glVersion;
    }

    private void crashElegantly(String errorDetails) {
        try (BufferedReader is = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/glfailure.txt")));){
            String qrText = is.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException ioe) {
            String qrText = "";
        }
        StringBuilder msgBuilder = new StringBuilder(2000);
        msgBuilder.append("Failed to initialize the mod loading system and display.\n");
        msgBuilder.append("\n\n");
        msgBuilder.append("Failure details:\n");
        msgBuilder.append(errorDetails);
        msgBuilder.append("\n\n");
        msgBuilder.append("If you click yes, we will try and open https://links.neoforged.net/early-display-errors in your default browser");
        LOGGER.error("ERROR DISPLAY\n" + String.valueOf(msgBuilder));
        Executors.newSingleThreadExecutor().submit(() -> {
            boolean res = TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft: NeoForge", (CharSequence)msgBuilder.toString(), (CharSequence)"yesno", (CharSequence)"error", (boolean)false);
            if (res) {
                try {
                    Desktop.getDesktop().browse(URI.create(ERROR_URL));
                }
                catch (IOException ioe) {
                    TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft: NeoForge", (CharSequence)"Sadly, we couldn't open your browser.\nVisit https://links.neoforged.net/early-display-errors", (CharSequence)"ok", (CharSequence)"error", (boolean)false);
                }
            }
            System.exit(1);
        });
    }

    public void initWindow(@Nullable String mcVersion) {
        long primaryMonitor;
        long glfwInitBegin = System.nanoTime();
        if (!GLFW.glfwInit()) {
            this.crashElegantly("We are unable to initialize the graphics system.\nglfwInit failed.\n");
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long glfwInitEnd = System.nanoTime();
        if ((double)(glfwInitEnd - glfwInitBegin) > 1.0E9) {
            LOGGER.error("WARNING : glfwInit took {} seconds to start.", (Object)((double)(glfwInitEnd - glfwInitBegin) / 1.0E9));
        }
        this.handleLastGLFWError((error, description) -> LOGGER.error(String.format("Suppressing Last GLFW error: [0x%X]%s", error, description)));
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        if (mcVersion != null) {
            String vanillaWindowTitle = "Minecraft* " + mcVersion;
            GLFW.glfwWindowHintString((int)147457, (CharSequence)vanillaWindowTitle);
            GLFW.glfwWindowHintString((int)147458, (CharSequence)vanillaWindowTitle);
        }
        if ((primaryMonitor = GLFW.glfwGetPrimaryMonitor()) == 0L) {
            LOGGER.error("Failed to find a primary monitor - this means LWJGL isn't working properly");
            this.crashElegantly("Failed to locate a primary monitor.\nglfwGetPrimaryMonitor failed.\n");
            throw new IllegalStateException("Can't find a primary monitor");
        }
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)primaryMonitor);
        if (vidmode == null) {
            LOGGER.error("Failed to get the current display video mode.");
            this.crashElegantly("Failed to get current display resolution.\nglfwGetVideoMode failed.\n");
            throw new IllegalStateException("Can't get a resolution");
        }
        long window = 0L;
        AtomicBoolean successfulWindow = new AtomicBoolean(false);
        ScheduledFuture<?> windowFailFuture = this.renderScheduler.schedule(() -> {
            if (!successfulWindow.get()) {
                this.crashElegantly("Timed out trying to setup the Game Window.");
            }
        }, 10L, TimeUnit.SECONDS);
        int versidx = 0;
        List skipVersions = FMLConfig.getListConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_SKIP_GL_VERSIONS);
        String[] lastGLError = new String[GL_VERSIONS.length];
        do {
            String glVersionToTry;
            if (skipVersions.contains(glVersionToTry = GL_VERSIONS[versidx][0] + "." + GL_VERSIONS[versidx][1])) {
                LOGGER.info("Skipping GL version " + glVersionToTry + " because of configuration");
                ++versidx;
                continue;
            }
            LOGGER.info("Trying GL version " + glVersionToTry);
            GLFW.glfwWindowHint((int)139266, (int)GL_VERSIONS[versidx][0]);
            GLFW.glfwWindowHint((int)139267, (int)GL_VERSIONS[versidx][1]);
            GLFW.glfwWindowHint((int)139272, (int)204801);
            GLFW.glfwWindowHint((int)139270, (int)1);
            window = GLFW.glfwCreateWindow((int)this.winWidth, (int)this.winHeight, (CharSequence)"Minecraft: NeoForge Loading...", (long)0L, (long)0L);
            int erridx = versidx;
            this.handleLastGLFWError((error, description) -> {
                lastGLError[erridx] = String.format("Trying %d.%d: GLFW error: [0x%X]%s", GL_VERSIONS[erridx][0], GL_VERSIONS[erridx][1], error, description);
            });
            if (lastGLError[versidx] != null) {
                LOGGER.trace(lastGLError[versidx]);
            }
            ++versidx;
        } while (window == 0L && versidx < GL_VERSIONS.length);
        if (versidx == GL_VERSIONS.length && window == 0L) {
            LOGGER.error("Failed to find any valid GLFW profile. " + lastGLError[0]);
            this.crashElegantly("Failed to find a valid GLFW profile.\nWe tried " + Arrays.stream(GL_VERSIONS).map(p -> p[0] + "." + p[1]).filter(o -> !skipVersions.contains(o)).collect(Collector.of(() -> new StringJoiner(", ").setEmptyValue("no versions"), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0])) + " but none of them worked.\n" + Arrays.stream(lastGLError).filter(Objects::nonNull).collect(Collectors.joining("\n")));
            throw new IllegalStateException("Failed to create a GLFW window with any profile");
        }
        successfulWindow.set(true);
        if (!windowFailFuture.cancel(true)) {
            throw new IllegalStateException("We died but didn't somehow?");
        }
        String requestedVersion = GL_VERSIONS[versidx - 1][0] + "." + GL_VERSIONS[versidx - 1][1];
        int maj = GLFW.glfwGetWindowAttrib((long)window, (int)139266);
        int min = GLFW.glfwGetWindowAttrib((long)window, (int)139267);
        String gotVersion = maj + "." + min;
        LOGGER.info("Requested GL version " + requestedVersion + " got version " + gotVersion);
        this.glVersion = gotVersion;
        this.window = window;
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetMonitorPos((long)primaryMonitor, (int[])x, (int[])y);
        int monitorX = x[0];
        int monitorY = y[0];
        if (this.maximized) {
            GLFW.glfwMaximizeWindow((long)window);
        }
        GLFW.glfwGetWindowSize((long)window, (int[])x, (int[])y);
        this.winWidth = x[0];
        this.winHeight = y[0];
        GLFW.glfwSetWindowPos((long)window, (int)((vidmode.width() - this.winWidth) / 2 + monitorX), (int)((vidmode.height() - this.winHeight) / 2 + monitorY));
        int[] channels = new int[1];
        try (GLFWImage.Buffer glfwImgBuffer = GLFWImage.create((long)MemoryUtil.getAllocator().malloc((long)GLFWImage.SIZEOF), (int)1);
             GLFWImage glfwImages = GLFWImage.malloc();){
            ByteBuffer imgBuffer = STBHelper.loadImageFromClasspath("neoforged_icon.png", 20000, x, y, channels);
            glfwImgBuffer.put((Struct)glfwImages.set(x[0], y[0], imgBuffer));
            GLFW.glfwSetWindowIcon((long)window, (GLFWImage.Buffer)glfwImgBuffer);
            STBImage.stbi_image_free((ByteBuffer)imgBuffer);
        }
        catch (NullPointerException e) {
            System.err.println("Failed to load NeoForged icon");
        }
        this.handleLastGLFWError((error, description) -> LOGGER.debug(String.format("Suppressing GLFW icon error: [0x%X]%s", error, description)));
        GLFW.glfwSetFramebufferSizeCallback((long)window, this::fbResize);
        GLFW.glfwSetWindowPosCallback((long)window, this::winMove);
        GLFW.glfwSetWindowSizeCallback((long)window, this::winResize);
        GLFW.glfwShowWindow((long)window);
        GLFW.glfwGetWindowPos((long)window, (int[])x, (int[])y);
        this.handleLastGLFWError((error, description) -> LOGGER.debug(String.format("Suppressing GLFW get window position error: [0x%X]%s", error, description)));
        this.winX = x[0];
        this.winY = y[0];
        GLFW.glfwGetFramebufferSize((long)window, (int[])x, (int[])y);
        this.fbWidth = x[0];
        this.fbHeight = y[0];
        GLFW.glfwPollEvents();
    }

    private void badWindowHandler(int code, long desc) {
        LOGGER.error("Got error from GLFW window init: " + code + " " + MemoryUtil.memUTF8((long)desc));
    }

    private void winResize(long window, int width, int height) {
        if (window == this.window && width != 0 && height != 0) {
            this.winWidth = width;
            this.winHeight = height;
        }
    }

    private void fbResize(long window, int width, int height) {
        if (window == this.window && width != 0 && height != 0) {
            this.fbWidth = width;
            this.fbHeight = height;
        }
    }

    private void winMove(long window, int x, int y) {
        if (window == this.window) {
            this.winX = x;
            this.winY = y;
        }
    }

    private void handleLastGLFWError(BiConsumer<Integer, String> handler) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int error = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (error != 0) {
                long pDescription = pointerbuffer.get();
                String description = pDescription == 0L ? "" : MemoryUtil.memUTF8((long)pDescription);
                handler.accept(error, description);
            }
        }
    }

    public long setupMinecraftWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitorSupplier) {
        try {
            this.initializationFuture.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            Thread.dumpStack();
            this.crashElegantly("We seem to be having trouble initializing the window, waited for 30 seconds");
        }
        ImmediateWindowHandler.updateProgress((String)"Initializing Game Graphics");
        while (!this.windowTick.isDone()) {
            this.windowTick.cancel(false);
        }
        int tries = 0;
        boolean renderlockticket = false;
        do {
            try {
                renderlockticket = this.renderLock.tryAcquire(100L, TimeUnit.MILLISECONDS);
                if (++tries <= 9) continue;
                Thread.dumpStack();
                this.crashElegantly("We seem to be having trouble handing off the window, tried for 1 second");
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        } while (!renderlockticket);
        this.renderLock.release();
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)title.get());
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, null).free();
        GLFW.glfwSetWindowPosCallback((long)this.window, null).free();
        GLFW.glfwSetWindowSizeCallback((long)this.window, null).free();
        this.repaintTick = this::renderThreadFunc;
        this.windowTick = null;
        return this.window;
    }

    public boolean positionWindow(Optional<Object> monitor, IntConsumer widthSetter, IntConsumer heightSetter, IntConsumer xSetter, IntConsumer ySetter) {
        widthSetter.accept(this.winWidth);
        heightSetter.accept(this.winHeight);
        xSetter.accept(this.winX);
        ySetter.accept(this.winY);
        return true;
    }

    public void updateFramebufferSize(IntConsumer width, IntConsumer height) {
        width.accept(this.fbWidth);
        height.accept(this.fbHeight);
    }

    public <T> Supplier<T> loadingOverlay(Supplier<?> mc, Supplier<?> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
        try {
            return (Supplier)this.loadingOverlay.invoke(null, mc, ri, ex, this);
        }
        catch (Throwable e) {
            throw new IllegalStateException("How did you get here?", e);
        }
    }

    public void updateModuleReads(ModuleLayer layer) {
        Module fm = layer.findModule("neoforge").orElseThrow();
        this.getClass().getModule().addReads(fm);
        Class<?> clz = Class.forName(fm, "net.neoforged.neoforge.client.loading.NeoForgeLoadingOverlay");
        Map methods = Arrays.stream(clz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toMap(Method::getName, Function.identity()));
        this.loadingOverlay = (Method)methods.get("newInstance");
    }

    public int getFramebufferTextureId() {
        return this.framebuffer.getTexture();
    }

    public RenderElement.DisplayContext context() {
        return this.context;
    }

    public void periodicTick() {
        GLFW.glfwPollEvents();
        this.repaintTick.run();
    }

    public void addMojangTexture(int textureId) {
        this.elements.add(0, RenderElement.mojang(textureId, this.framecount));
    }

    public void close() {
        this.renderScheduler.shutdown();
        this.framebuffer.close();
        this.context.elementShader().close();
        SimpleBufferBuilder.destroy();
    }

    public void crash(String message) {
        this.crashElegantly(message);
    }
}

