/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.ColorResolver;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.jetbrains.annotations.ApiStatus;

public final class ColorResolverManager {
    private static ImmutableList<ColorResolver> colorResolvers;

    @ApiStatus.Internal
    public static void init() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ModLoader.postEvent((Event)new RegisterColorHandlersEvent.ColorResolvers((ImmutableList.Builder<ColorResolver>)builder));
        colorResolvers = builder.build();
    }

    public static ImmutableList<ColorResolver> getRegisteredResolvers() {
        return colorResolvers;
    }

    public static void registerBlockTintCaches(ClientLevel level, Map<ColorResolver, BlockTintCache> target) {
        for (ColorResolver resolver : colorResolvers) {
            target.put(resolver, new BlockTintCache(pos -> level.calculateBlockTint(pos, resolver)));
        }
    }

    private ColorResolverManager() {
    }
}

