/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public interface ICondition {
    public static final Codec<ICondition> CODEC = NeoForgeRegistries.CONDITION_SERIALIZERS.byNameCodec().dispatch(ICondition::codec, Function.identity());
    public static final Codec<List<ICondition>> LIST_CODEC = CODEC.listOf();

    public static <V, T> Optional<T> getConditionally(Codec<T> codec, DynamicOps<V> ops, V element) {
        return ICondition.getWithConditionalCodec(ConditionalOps.createConditionalCodec(codec), ops, element);
    }

    public static <V, T> Optional<T> getWithConditionalCodec(Codec<Optional<T>> codec, DynamicOps<V> ops, V element) {
        return (Optional)codec.parse(ops, element).getOrThrow(JsonParseException::new);
    }

    public static <V, T> Optional<T> getWithWithConditionsCodec(Codec<Optional<WithConditions<T>>> codec, DynamicOps<V> ops, V elements) {
        return ((Optional)codec.parse(ops, elements).promotePartial(m -> {}).getOrThrow(JsonParseException::new)).map(WithConditions::carrier);
    }

    public static <V> boolean conditionsMatched(DynamicOps<V> ops, V element) {
        Codec codec = Codec.unit((Object)Unit.INSTANCE);
        return ICondition.getConditionally(codec, ops, element).isPresent();
    }

    public static void writeConditions(HolderLookup.Provider registries, JsonObject jsonObject, ICondition ... conditions) {
        ICondition.writeConditions(registries, jsonObject, List.of(conditions));
    }

    public static void writeConditions(HolderLookup.Provider registries, JsonObject jsonObject, List<ICondition> conditions) {
        ICondition.writeConditions((DynamicOps<JsonElement>)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries), jsonObject, conditions);
    }

    public static void writeConditions(DynamicOps<JsonElement> jsonOps, JsonObject jsonObject, List<ICondition> conditions) {
        if (!conditions.isEmpty()) {
            DataResult result = LIST_CODEC.encodeStart(jsonOps, conditions);
            JsonElement serializedConditions = (JsonElement)result.result().orElseThrow(() -> new RuntimeException("Failed to serialize conditions"));
            jsonObject.add("neoforge:conditions", serializedConditions);
        }
    }

    public boolean test(IContext var1);

    public MapCodec<? extends ICondition> codec();

    public static interface IContext {
        public static final IContext EMPTY = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                return Collections.emptyMap();
            }
        };
        public static final IContext TAGS_INVALID = new IContext(){

            @Override
            public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
                throw new UnsupportedOperationException("Usage of tag-based conditions is not permitted in this context!");
            }
        };

        default public <T> Collection<Holder<T>> getTag(TagKey<T> key) {
            return this.getAllTags(key.registry()).getOrDefault(key.location(), Set.of());
        }

        public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> var1);
    }
}

