/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface IItemExtension {
    private Item self() {
        return (Item)this;
    }

    default public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.self().getDefaultAttributeModifiers();
    }

    default public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return true;
    }

    default public Component getHighlightTip(ItemStack item, Component displayName) {
        return displayName;
    }

    default public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean isPiglinCurrency(ItemStack stack) {
        return stack.getItem() == PiglinAi.BARTERING_ITEM;
    }

    default public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.getItem() instanceof ArmorItem && ((ArmorItem)stack.getItem()).getMaterial() == ArmorMaterials.GOLD;
    }

    public boolean isRepairable(ItemStack var1);

    default public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    default public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
    }

    default public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return false;
    }

    default public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (!this.hasCraftingRemainingItem(itemStack)) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.self().getCraftingRemainingItem());
    }

    default public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.self().hasCraftingRemainingItem();
    }

    default public int getEntityLifespan(ItemStack itemStack, Level level) {
        return 6000;
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @Nullable
    default public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return null;
    }

    default public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return false;
    }

    default public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return entity.getEquipmentSlotForItem(stack) == armorType;
    }

    @Nullable
    default public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return null;
    }

    default public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Nullable
    default public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return null;
    }

    default public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    default public int getDamage(ItemStack stack) {
        return Mth.clamp((int)((Integer)stack.getOrDefault(DataComponents.DAMAGE, (Object)0)), (int)0, (int)stack.getMaxDamage());
    }

    default public int getMaxDamage(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.MAX_DAMAGE, (Object)0);
    }

    default public boolean isDamaged(ItemStack stack) {
        return stack.getDamageValue() > 0;
    }

    default public void setDamage(ItemStack stack, int damage) {
        stack.set(DataComponents.DAMAGE, (Object)Mth.clamp((int)damage, (int)0, (int)stack.getMaxDamage()));
    }

    default public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return false;
    }

    default public int getMaxStackSize(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
    }

    default public int getEnchantmentValue(ItemStack stack) {
        return this.self().getEnchantmentValue();
    }

    @ApiStatus.OverrideOnly
    default public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return stack.getItem() == Items.BOOK || ((Enchantment)enchantment.value()).isPrimaryItem(stack);
    }

    @ApiStatus.OverrideOnly
    default public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        ItemEnchantments itemenchantments = stack.getTagEnchantments();
        return itemenchantments.getLevel(enchantment);
    }

    @ApiStatus.OverrideOnly
    default public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return stack.getTagEnchantments();
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (!newStack.is(oldStack.getItem())) {
            return true;
        }
        if (!newStack.isDamageableItem() || !oldStack.isDamageableItem()) {
            return !ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)oldStack);
        }
        DataComponentMap newComponents = newStack.getComponents();
        DataComponentMap oldComponents = oldStack.getComponents();
        if (newComponents.isEmpty() || oldComponents.isEmpty()) {
            return !newComponents.isEmpty() || !oldComponents.isEmpty();
        }
        HashSet newKeys = new HashSet(newComponents.keySet());
        HashSet oldKeys = new HashSet(oldComponents.keySet());
        newKeys.remove(DataComponents.DAMAGE);
        oldKeys.remove(DataComponents.DAMAGE);
        if (!newKeys.equals(oldKeys)) {
            return true;
        }
        return !newKeys.stream().allMatch(key -> Objects.equals(newComponents.get(key), oldComponents.get(key)));
    }

    default public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (oldStack == newStack) {
            return true;
        }
        return !oldStack.isEmpty() && !newStack.isEmpty() && ItemStack.isSameItem((ItemStack)newStack, (ItemStack)oldStack);
    }

    @Nullable
    default public String getCreatorModId(ItemStack itemStack) {
        return CommonHooks.getDefaultCreatorModId(itemStack);
    }

    default public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this instanceof AxeItem;
    }

    @ApiStatus.OverrideOnly
    default public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        FurnaceFuel furnaceFuel = (FurnaceFuel)this.self().builtInRegistryHolder().getData(NeoForgeDataMaps.FURNACE_FUELS);
        return furnaceFuel == null ? 0 : furnaceFuel.burnTime();
    }

    @ApiStatus.OverrideOnly
    default public void onAnimalArmorTick(ItemStack stack, Level level, Mob horse) {
    }

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return amount;
    }

    default public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        this.self().onDestroyed(itemEntity);
    }

    default public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return stack.getItem() == Blocks.CARVED_PUMPKIN.asItem();
    }

    default public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return false;
    }

    default public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return false;
    }

    default public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is(Items.LEATHER_BOOTS);
    }

    default public boolean isDamageable(ItemStack stack) {
        return stack.has(DataComponents.MAX_DAMAGE);
    }

    default public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        return target.getBoundingBox().inflate(1.0, 0.25, 1.0);
    }

    @Nullable
    default public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return (FoodProperties)stack.get(DataComponents.FOOD);
    }

    default public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return stack.isEnchanted();
    }

    default public boolean canGrindstoneRepair(ItemStack stack) {
        return false;
    }
}

