/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record RegistryDataMapSyncPayload<T>(ResourceKey<? extends Registry<T>> registryKey, Map<ResourceLocation, Map<ResourceKey<T>, ?>> dataMaps) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RegistryDataMapSyncPayload<?>> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"registry_data_map_sync"));
    public static final StreamCodec<FriendlyByteBuf, RegistryDataMapSyncPayload<?>> STREAM_CODEC = StreamCodec.ofMember(RegistryDataMapSyncPayload::write, RegistryDataMapSyncPayload::decode);

    public static <T> RegistryDataMapSyncPayload<T> decode(FriendlyByteBuf buf) {
        ResourceKey registryKey = buf.readRegistryKey();
        Map attach = buf.readMap(FriendlyByteBuf::readResourceLocation, (b1, key) -> {
            DataMapType dataMap = RegistryManager.getDataMap(registryKey, key);
            return b1.readMap(bf -> bf.readResourceKey(registryKey), bf -> bf.readJsonWithCodec(dataMap.networkCodec()));
        });
        return new RegistryDataMapSyncPayload<T>(registryKey, attach);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceKey(this.registryKey);
        buf.writeMap(this.dataMaps, FriendlyByteBuf::writeResourceLocation, (b1, key, attach) -> {
            DataMapType dataMap = RegistryManager.getDataMap(this.registryKey, key);
            b1.writeMap(attach, FriendlyByteBuf::writeResourceKey, (bf, value) -> bf.writeJsonWithCodec(dataMap.networkCodec(), value));
        });
    }

    public CustomPacketPayload.Type<RegistryDataMapSyncPayload<?>> type() {
        return TYPE;
    }
}

