/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.ReservedConstructor;
import net.neoforged.neoforge.client.IArmPoseTransformer;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidModel<T extends LivingEntity>
extends AgeableListModel<T>
implements ArmedModel,
HeadedModel {
    public static final float OVERLAY_SCALE = 0.25f;
    public static final float HAT_OVERLAY_SCALE = 0.5f;
    public static final float LEGGINGS_OVERLAY_SCALE = -0.1f;
    private static final float DUCK_WALK_ROTATION = 0.005f;
    private static final float SPYGLASS_ARM_ROT_Y = 0.2617994f;
    private static final float SPYGLASS_ARM_ROT_X = 1.9198622f;
    private static final float SPYGLASS_ARM_CROUCH_ROT_X = 0.2617994f;
    private static final float HIGHEST_SHIELD_BLOCKING_ANGLE = -1.3962634f;
    private static final float LOWEST_SHIELD_BLOCKING_ANGLE = 0.43633232f;
    private static final float HORIZONTAL_SHIELD_MOVEMENT_LIMIT = 0.5235988f;
    public static final float TOOT_HORN_XROT_BASE = 1.4835298f;
    public static final float TOOT_HORN_YROT_BASE = 0.5235988f;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public ArmPose leftArmPose = ArmPose.EMPTY;
    public ArmPose rightArmPose = ArmPose.EMPTY;
    public boolean crouching;
    public float swimAmount;

    public HumanoidModel(ModelPart p_170677_) {
        this(p_170677_, RenderType::entityCutoutNoCull);
    }

    public HumanoidModel(ModelPart p_170679_, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170680_, true, 16.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.head = p_170679_.getChild("head");
        this.hat = p_170679_.getChild("hat");
        this.body = p_170679_.getChild("body");
        this.rightArm = p_170679_.getChild("right_arm");
        this.leftArm = p_170679_.getChild("left_arm");
        this.rightLeg = p_170679_.getChild("right_leg");
        this.leftLeg = p_170679_.getChild("left_leg");
    }

    public static MeshDefinition createMesh(CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.offset((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.extend(0.5f)), PartPose.offset((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)-5.0f, (float)(2.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)5.0f, (float)(2.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)-1.9f, (float)(12.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)1.9f, (float)(12.0f + p_170683_), (float)0.0f));
        return meshdefinition;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat);
    }

    public void prepareMobModel(T p_102861_, float p_102862_, float p_102863_, float p_102864_) {
        this.swimAmount = ((LivingEntity)((Object)p_102861_)).getSwimAmount(p_102864_);
        super.prepareMobModel(p_102861_, p_102862_, p_102863_, p_102864_);
    }

    public void setupAnim(T p_102866_, float p_102867_, float p_102868_, float p_102869_, float p_102870_, float p_102871_) {
        boolean flag2;
        boolean flag = ((LivingEntity)((Object)p_102866_)).getFallFlyingTicks() > 4;
        boolean flag1 = ((LivingEntity)((Object)p_102866_)).isVisuallySwimming();
        this.head.yRot = p_102870_ * ((float)Math.PI / 180);
        this.head.xRot = flag ? -0.7853982f : (this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, p_102871_ * ((float)Math.PI / 180))) : p_102871_ * ((float)Math.PI / 180));
        this.body.yRot = 0.0f;
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)((Entity)((Object)p_102866_)).getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.xRot = Mth.cos((float)(p_102867_ * 0.6662f + (float)Math.PI)) * 2.0f * p_102868_ * 0.5f / f;
        this.leftArm.xRot = Mth.cos((float)(p_102867_ * 0.6662f)) * 2.0f * p_102868_ * 0.5f / f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(p_102867_ * 0.6662f)) * 1.4f * p_102868_ / f;
        this.leftLeg.xRot = Mth.cos((float)(p_102867_ * 0.6662f + (float)Math.PI)) * 1.4f * p_102868_ / f;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        this.rightLeg.zRot = 0.005f;
        this.leftLeg.zRot = -0.005f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = flag2 = ((LivingEntity)((Object)p_102866_)).getMainArm() == HumanoidArm.RIGHT;
        if (((LivingEntity)((Object)p_102866_)).isUsingItem()) {
            boolean flag3;
            boolean bl2 = flag3 = ((LivingEntity)((Object)p_102866_)).getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm(p_102866_);
            } else {
                this.poseLeftArm(p_102866_);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if (flag2 != flag4) {
                this.poseLeftArm(p_102866_);
                this.poseRightArm(p_102866_);
            } else {
                this.poseRightArm(p_102866_);
                this.poseLeftArm(p_102866_);
            }
        }
        this.setupAttackAnimation(p_102866_, p_102869_);
        if (this.crouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z = 4.0f;
            this.leftLeg.z = 4.0f;
            this.rightLeg.y = 12.2f;
            this.leftLeg.y = 12.2f;
            this.head.y = 4.2f;
            this.body.y = 3.2f;
            this.leftArm.y = 5.2f;
            this.rightArm.y = 5.2f;
        } else {
            this.body.xRot = 0.0f;
            this.rightLeg.z = 0.0f;
            this.leftLeg.z = 0.0f;
            this.rightLeg.y = 12.0f;
            this.leftLeg.y = 12.0f;
            this.head.y = 0.0f;
            this.body.y = 0.0f;
            this.leftArm.y = 2.0f;
            this.rightArm.y = 2.0f;
        }
        if (this.rightArmPose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)p_102869_, (float)1.0f);
        }
        if (this.leftArmPose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)p_102869_, (float)-1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float f2;
            float f5 = p_102867_ % 26.0f;
            HumanoidArm humanoidarm = this.getAttackArm(p_102866_);
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f3 = f2 = humanoidarm == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!((LivingEntity)((Object)p_102866_)).isUsingItem()) {
                if (f5 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f)));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f * f6);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f * f6));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f6));
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f32 = (f5 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f - 1.5707964f * f32);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f32));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            float f7 = 0.3f;
            float f4 = 0.33333334f;
            this.leftLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(p_102867_ * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(p_102867_ * 0.33333334f))));
        }
        this.hat.copyFrom(this.head);
    }

    private void poseRightArm(T p_102876_) {
        switch (this.rightArmPose.ordinal()) {
            case 0: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 1: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 2: {
                this.poseBlockingArm(this.rightArm, true);
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 4: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 5: {
                AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, p_102876_, (boolean)true);
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
                break;
            }
            case 7: {
                this.rightArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (((Entity)((Object)p_102876_)).isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
                break;
            }
            case 8: {
                this.rightArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.rightArm.yRot = this.head.yRot - 0.5235988f;
                break;
            }
            case 9: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.62831855f;
                this.rightArm.yRot = 0.0f;
            }
            default: {
                this.rightArmPose.applyTransform(this, p_102876_, HumanoidArm.RIGHT);
            }
        }
    }

    private void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose.ordinal()) {
            case 0: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 1: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 2: {
                this.poseBlockingArm(this.leftArm, false);
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 4: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 5: {
                AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, p_102879_, (boolean)false);
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)false);
                break;
            }
            case 7: {
                this.leftArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (((Entity)((Object)p_102879_)).isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
                break;
            }
            case 8: {
                this.leftArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.leftArm.yRot = this.head.yRot + 0.5235988f;
                break;
            }
            case 9: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.62831855f;
                this.leftArm.yRot = 0.0f;
            }
            default: {
                this.leftArmPose.applyTransform(this, p_102879_, HumanoidArm.LEFT);
            }
        }
    }

    private void poseBlockingArm(ModelPart p_304530_, boolean p_304416_) {
        p_304530_.xRot = p_304530_.xRot * 0.5f - 0.9424779f + Mth.clamp((float)this.head.xRot, (float)-1.3962634f, (float)0.43633232f);
        p_304530_.yRot = (p_304416_ ? -30.0f : 30.0f) * ((float)Math.PI / 180) + Mth.clamp((float)this.head.yRot, (float)-0.5235988f, (float)0.5235988f);
    }

    protected void setupAttackAnimation(T p_102858_, float p_102859_) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            this.rightArm.z = Mth.sin((float)this.body.yRot) * 5.0f;
            this.rightArm.x = -Mth.cos((float)this.body.yRot) * 5.0f;
            this.leftArm.z = -Mth.sin((float)this.body.yRot) * 5.0f;
            this.leftArm.x = Mth.cos((float)this.body.yRot) * 5.0f;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    protected float rotlerpRad(float p_102836_, float p_102837_, float p_102838_) {
        float f = (p_102838_ - p_102837_) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return p_102837_ + p_102836_ * f;
    }

    private float quadraticArmUpdate(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    public void copyPropertiesTo(HumanoidModel<T> p_102873_) {
        super.copyPropertiesTo(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
        p_102873_.crouching = this.crouching;
        p_102873_.head.copyFrom(this.head);
        p_102873_.hat.copyFrom(this.hat);
        p_102873_.body.copyFrom(this.body);
        p_102873_.rightArm.copyFrom(this.rightArm);
        p_102873_.leftArm.copyFrom(this.leftArm);
        p_102873_.rightLeg.copyFrom(this.rightLeg);
        p_102873_.leftLeg.copyFrom(this.leftLeg);
    }

    public void setAllVisible(boolean p_102880_) {
        this.head.visible = p_102880_;
        this.hat.visible = p_102880_;
        this.body.visible = p_102880_;
        this.rightArm.visible = p_102880_;
        this.leftArm.visible = p_102880_;
        this.rightLeg.visible = p_102880_;
        this.leftLeg.visible = p_102880_;
    }

    public void translateToHand(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.getArm(p_102854_).translateAndRotate(p_102855_);
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    private HumanoidArm getAttackArm(T p_102857_) {
        HumanoidArm humanoidarm = ((LivingEntity)((Object)p_102857_)).getMainArm();
        return ((LivingEntity)((Object)p_102857_)).swingingArm == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.getOpposite();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose implements IExtensibleEnum
    {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true),
        SPYGLASS(false),
        TOOT_HORN(false),
        BRUSH(false);

        private final boolean twoHanded;
        @Nullable
        private final IArmPoseTransformer forgeArmPose;

        @ReservedConstructor
        private ArmPose(boolean p_102896_) {
            this.twoHanded = p_102896_;
            this.forgeArmPose = null;
        }

        private ArmPose(boolean twoHanded, IArmPoseTransformer forgeArmPose) {
            this.twoHanded = twoHanded;
            Preconditions.checkNotNull((Object)forgeArmPose, (Object)"Cannot create new ArmPose with null transformer!");
            this.forgeArmPose = forgeArmPose;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }

        public <T extends LivingEntity> void applyTransform(HumanoidModel<T> model, T entity, HumanoidArm arm) {
            if (this.forgeArmPose != null) {
                this.forgeArmPose.applyTransform(model, entity, arm);
            }
        }

        public static ExtensionInfo getExtensionInfo() {
            return ExtensionInfo.nonExtended(ArmPose.class);
        }
    }
}

