/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionContext;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.resource.ContextAwareReloadListener;
import org.slf4j.Logger;

public class ReloadableServerResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final ReloadableServerRegistries.Holder fullRegistryHolder;
    private final ConfigurableRegistryLookup registryLookup;
    private final Commands commands;
    private final RecipeManager recipes;
    private final TagManager tagManager;
    private final ServerAdvancementManager advancements;
    private final ServerFunctionLibrary functionLibrary;
    private final ICondition.IContext context;

    private ReloadableServerResources(RegistryAccess.Frozen p_206857_, FeatureFlagSet p_250695_, Commands.CommandSelection p_206858_, int p_206859_) {
        this.fullRegistryHolder = new ReloadableServerRegistries.Holder(p_206857_);
        this.registryLookup = new ConfigurableRegistryLookup((RegistryAccess)p_206857_);
        this.registryLookup.missingTagAccessPolicy(MissingTagAccessPolicy.CREATE_NEW);
        this.recipes = new RecipeManager(this.registryLookup);
        this.tagManager = new TagManager((RegistryAccess)p_206857_);
        this.commands = new Commands(p_206858_, CommandBuildContext.simple((HolderLookup.Provider)this.registryLookup, (FeatureFlagSet)p_250695_));
        this.advancements = new ServerAdvancementManager(this.registryLookup);
        this.functionLibrary = new ServerFunctionLibrary(p_206859_, this.commands.getDispatcher());
        this.context = new ConditionContext(this.tagManager);
    }

    public ServerFunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public ReloadableServerRegistries.Holder fullRegistries() {
        return this.fullRegistryHolder;
    }

    public RecipeManager getRecipeManager() {
        return this.recipes;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public ServerAdvancementManager getAdvancements() {
        return this.advancements;
    }

    public List<PreparableReloadListener> listeners() {
        return List.of(this.tagManager, this.recipes, this.functionLibrary, this.advancements);
    }

    public ICondition.IContext getConditionContext() {
        return this.context;
    }

    public HolderLookup.Provider getRegistryLookup() {
        return this.registryLookup;
    }

    public static CompletableFuture<ReloadableServerResources> loadResources(ResourceManager p_248588_, LayeredRegistryAccess<RegistryLayer> p_335667_, FeatureFlagSet p_250212_, Commands.CommandSelection p_249301_, int p_251126_, Executor p_249136_, Executor p_249601_) {
        return ReloadableServerRegistries.reload(p_335667_, (ResourceManager)p_248588_, (Executor)p_249136_).thenCompose(p_335211_ -> {
            ReloadableServerResources reloadableserverresources = new ReloadableServerResources(p_335211_.compositeAccess(), p_250212_, p_249301_, p_251126_);
            ArrayList<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>(reloadableserverresources.listeners());
            listeners.addAll(EventHooks.onResourceReload((ReloadableServerResources)reloadableserverresources, (RegistryAccess)p_335211_.compositeAccess()));
            listeners.forEach(rl -> {
                if (rl instanceof ContextAwareReloadListener) {
                    ContextAwareReloadListener srl = (ContextAwareReloadListener)rl;
                    srl.injectContext(reloadableserverresources.context, (HolderLookup.Provider)reloadableserverresources.registryLookup);
                }
            });
            return ((CompletableFuture)((CompletableFuture)SimpleReloadInstance.create((ResourceManager)p_248588_, listeners, (Executor)p_249136_, (Executor)p_249601_, DATA_RELOAD_INITIAL_TASK, (boolean)LOGGER.isDebugEnabled()).done().whenComplete((p_323178_, p_323179_) -> reloadableserverresources.registryLookup.missingTagAccessPolicy(MissingTagAccessPolicy.FAIL))).thenRun(() -> listeners.forEach(rl -> {
                if (rl instanceof ContextAwareReloadListener) {
                    ContextAwareReloadListener srl = (ContextAwareReloadListener)rl;
                    srl.injectContext(ICondition.IContext.EMPTY, (HolderLookup.Provider)RegistryAccess.EMPTY);
                }
            }))).thenApply(p_214306_ -> reloadableserverresources);
        });
    }

    public void updateRegistryTags() {
        this.tagManager.getResult().forEach(p_335204_ -> ReloadableServerResources.updateRegistryTags((RegistryAccess)this.fullRegistryHolder.get(), p_335204_));
        AbstractFurnaceBlockEntity.invalidateCache();
        Blocks.rebuildCache();
        NeoForge.EVENT_BUS.post((Event)new TagsUpdatedEvent((RegistryAccess)this.fullRegistryHolder.get(), false, false));
    }

    private static <T> void updateRegistryTags(RegistryAccess p_206871_, TagManager.LoadResult<T> p_206872_) {
        ResourceKey resourcekey = p_206872_.key();
        Map map = p_206872_.tags().entrySet().stream().collect(Collectors.toUnmodifiableMap(p_214303_ -> TagKey.create((ResourceKey)resourcekey, (ResourceLocation)((ResourceLocation)p_214303_.getKey())), p_214312_ -> List.copyOf((Collection)p_214312_.getValue())));
        p_206871_.registryOrThrow(resourcekey).bindTags(map);
    }

    static class ConfigurableRegistryLookup
    implements HolderLookup.Provider {
        private final RegistryAccess registryAccess;
        MissingTagAccessPolicy missingTagAccessPolicy = MissingTagAccessPolicy.FAIL;

        ConfigurableRegistryLookup(RegistryAccess p_324146_) {
            this.registryAccess = p_324146_;
        }

        public void missingTagAccessPolicy(MissingTagAccessPolicy p_324138_) {
            this.missingTagAccessPolicy = p_324138_;
        }

        @Override
        public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
            return this.registryAccess.listRegistries();
        }

        @Override
        public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_323818_) {
            return this.registryAccess.registry(p_323818_).map(p_324050_ -> this.createDispatchedLookup(p_324050_.asLookup(), p_324050_.asTagAddingLookup()));
        }

        private <T> HolderLookup.RegistryLookup<T> createDispatchedLookup(final HolderLookup.RegistryLookup<T> p_324196_, final HolderLookup.RegistryLookup<T> p_323710_) {
            return new HolderLookup.RegistryLookup.Delegate<T>(){

                @Override
                public HolderLookup.RegistryLookup<T> parent() {
                    return switch (missingTagAccessPolicy.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> p_323710_;
                        case 1 -> p_324196_;
                    };
                }
            };
        }
    }

    static enum MissingTagAccessPolicy {
        CREATE_NEW,
        FAIL;

    }
}

